package jp.co.sra.jun.goodies.colors;

import java.awt.Dialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunColorBarDialog class
 * 
 *  @author    nisinaka
 *  @created   2004/06/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarDialog.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarDialog extends StSimpleDialog {

	protected JunColorBarModel colorBarModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Open a dialog to request a color information with a color bar model.
	 * 
	 * @return java.lang.Object[]
	 * @category Utilities
	 */
	public static Object[] Request() {
		return Request(JunSystem.$String("Color Bar Dialog"));
	}

	/**
	 * Open a dialog to request a color information with a color bar model.
	 * 
	 * @param messageString java.lang.String
	 * @return java.lang.Object[]
	 * @category Utilities
	 */
	public static Object[] Request(String messageString) {
		return Request(messageString, 0.5);
	}

	/**
	 * Open a dialog to request a color information with a color bar model.
	 * 
	 * @param messageString java.lang.String
	 * @param aValue double
	 * @return java.lang.Object[]
	 * @category Utilities
	 */
	public static Object[] Request(String messageString, double aValue) {
		return Request(messageString, aValue, 0, 1);
	}

	/**
	 * Open a dialog to request a color information with a color bar model.
	 * 
	 * @param messageString java.lang.String
	 * @param aValue double
	 * @param firstMarker double
	 * @param lastMarker double
	 * @return java.lang.Object[]
	 * @category Utilities
	 */
	public static Object[] Request(String messageString, double aValue, double firstMarker, double lastMarker) {
		JunColorBarHSB colorBar = new JunColorBarHSB();
		colorBar.value_(aValue);
		colorBar.firstMarker_(firstMarker);
		colorBar.lastMarker_(lastMarker);
		return Request(messageString, colorBar, null, null);
	}

	/**
	 * Open a dialog to request a color information with a color bar model.
	 * 
	 * @param messageString java.lang.String
	 * @param colorBarModel jp.co.sra.jun.goodies.colors.JunColorBarModel
	 * @return java.lang.Object[]
	 * @category Utilities
	 */
	public static Object[] Request(String messageString, JunColorBarModel colorBarModel) {
		return Request(messageString, colorBarModel, null, null);
	}

	/**
	 * Open a dialog to request a color information with a color bar model.
	 * 
	 * @param messageString java.lang.String
	 * @param colorBarModel jp.co.sra.jun.goodies.colors.JunColorBarModel
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object[]
	 * @category Utilities
	 */
	public static Object[] Request(String messageString, JunColorBarModel colorBarModel, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunColorBarDialog colorBarDialog = new JunColorBarDialog();
		if (colorBarModel != null) {
			colorBarDialog.colorBarModel_(colorBarModel);
		}
		Dialog dialog = colorBarDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			colorBarDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			colorBarDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);

		Object[] answer = null;
		if (colorBarDialog.accept()._booleanValue()) {
			answer = new Object[] { colorBarDialog.colorBarModel().color(), colorBarDialog.colorBarModel().value(), colorBarDialog.colorBarModel().interval() };
		}
		return answer;
	}

	/**
	 * Answer my current color bar model.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarModel
	 * @category accessing
	 */
	public JunColorBarModel colorBarModel() {
		if (colorBarModel == null) {
			colorBarModel = new JunColorBarHSB();
		}
		return colorBarModel;
	}

	/**
	 * Set my new color bar model.
	 * 
	 * @param newColorBarModel jp.co.sra.jun.goodies.colors.JunColorBarModel
	 * @category accessing
	 */
	public void colorBarModel_(JunColorBarModel newColorBarModel) {
		colorBarModel = newColorBarModel;
	}

	/**
	 * Set the new accept block.
	 *
	 * @param newAcceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void acceptBlock_(StBlockClosure newAcceptBlock) {
		acceptBlock = newAcceptBlock;
	}

	/**
	 * Set the new cancel block.
	 *
	 * @param newCancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void cancelBlock_(StBlockClosure newCancelBlock) {
		cancelBlock = newCancelBlock;
	}

	/**
	 * Called when an accept button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			acceptBlock.value_(this.colorBarModel());
		}
		return true;
	}

	/**
	 * Called when an cancel button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			cancelBlock.value_(this.colorBarModel());
		}
		return true;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StSimpleDialog#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunColorBarDialogViewAwt(this);
		} else {
			return new JunColorBarDialogViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Color Bar Dialog");
	}
}
