package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import javax.swing.JPopupMenu;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunColorChoiceViewSwing class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/05 (by Hirotsugu Kondo)
 *  @updated   1999/08/31 (by m-asada)
 *  @updated   2003/04/02 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2005/03/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceViewSwing.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceViewSwing extends JunAbstractViewJPanel implements JunColorChoiceView {

	protected JPopupMenu _popupMenu = null;

	/**
	 * Create a new JunColorChoiceViewSwing.
	 * 
	 * @category Instance creation
	 */
	public JunColorChoiceViewSwing() {
		super();
	}

	/**
	 * Create a new JunColorChoiceViewSwing and initialize it.
	 * 
	 * @param aColorChoiceModel jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category Instance creation
	 */
	public JunColorChoiceViewSwing(JunColorChoiceModel aColorChoiceModel) {
		super(aColorChoiceModel);
	}

	/**
	 * Answer the area of color bar.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle barArea() {
		int originX = this.plateArea().x + this.plateArea().width + 16;
		int originY = this.plateArea().y;
		Rectangle area = this.getModel()._barArea();
		Rectangle box = new Rectangle(originX, originY, area.width, area.height);
		return box;
	}

	/**
	 * Answer the model's brightness value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double brightness() {
		return this.getModel().brightness();
	}

	/**
	 * Answer the area of color brightness.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle brightnessArea() {
		int originX = this.saturationArea().x;
		int originY = this.saturationArea().y + this.saturationArea().height + 3;
		Rectangle box = new Rectangle(originX, originY, 56, 18);
		return box;
	}

	/**
	 * Answer the model's brightness string.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String brightnessString() {
		double round = this.round();
		int size = String.valueOf(round).length();
		double brightness = this.brightness();
		String string = String.valueOf(Math.round(brightness / round) * round);
		string = string.substring(0, Math.min(string.length(), size));
		for (int i = 0; i < size - string.length(); i++) {
			string = string + "0";
		}
		return string;
	}

	/**
	 * Answer the area of color plate.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle colorArea() {
		int originX = this.barArea().x + this.barArea().width + 16;
		int originY = this.barArea().y - 1;
		Rectangle box = new Rectangle(originX, originY, 30, 30);
		return box;
	}

	/**
	 * Answer the store string of the specified color.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String colorString() {
		StringBuffer buf = new StringBuffer();
		buf.append("(ColorValue hue: ");
		buf.append(this.hueString());
		buf.append(" saturation: ");
		buf.append(this.saturationString());
		buf.append(" brightness: ");
		buf.append(this.brightnessString());
		buf.append(")");
		return buf.toString();
	}

	/**
	 * Update the view.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		if (!this.isShowing()) {
			return;
		}

		this.displayPlateOn_(aGraphics);
		this.displayXYOn_(aGraphics);
		this.displayBarOn_(aGraphics);
		this.displayZOn_(aGraphics);
		this.displayColorOn_(aGraphics);
		this.displaySpuitOn_(aGraphics);
		this.displayHueOn_(aGraphics);
		this.displaySaturationOn_(aGraphics);
		this.displayBrightnessOn_(aGraphics);
	}

	/**
	 * model property accessing.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category model accessing
	 */
	public JunColorChoiceModel getModel() {
		return (JunColorChoiceModel) this.model();
	}

	/**
	 * Answer the model's hue value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double hue() {
		return this.getModel().hue();
	}

	/**
	 * Answer the area of color hue.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle hueArea() {
		int originX = this.colorArea().x;
		int originY = this.colorArea().y + this.colorArea().height + 12;
		Rectangle box = new Rectangle(originX, originY, 56, 18);
		return box;
	}

	/**
	 * Answer the model's hue string.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String hueString() {
		double round = this.round();
		int size = String.valueOf(round).length();
		double hue = this.hue();
		String string = String.valueOf(Math.round(hue / round) * round);
		string = string.substring(0, Math.min(string.length(), size));
		for (int i = 0; i < size - string.length(); i++) {
			string = string + "0";
		}
		return string;
	}

	/**
	 * Answer the area of plate.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle plateArea() {
		Rectangle area = this.getModel()._plateArea();
		Rectangle box = new Rectangle(12, 12, area.width, area.height);
		return box;
	}

	/**
	 * Answer the area of rendering.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle renderingArea() {
		int originX = this.colorArea().x + this.colorArea().width + 9;
		int originY = this.colorArea().y + 7;
		Rectangle box = new Rectangle(originX, originY, 17, 17);
		return box;
	}

	/**
	 * Answer the model's saturation value.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double saturation() {
		return this.getModel().saturation();
	}

	/**
	 * Answer the area of saturation.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle saturationArea() {
		int originX = this.hueArea().x;
		int originY = this.hueArea().y + this.hueArea().height + 3;
		Rectangle box = new Rectangle(originX, originY, 56, 18);
		return box;
	}

	/**
	 * Answer the model's saturation string.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String saturationString() {
		double round = this.round();
		int size = String.valueOf(round).length();
		double saturation = this.saturation();
		String string = String.valueOf(Math.round(saturation / round) * round);
		string = string.substring(0, Math.min(string.length(), size));
		for (int i = 0; i < size - string.length(); i++) {
			string = string + "0";
		}
		return string;
	}

	/**
	 * model property accessing.
	 * 
	 * @param aModel jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category model accessing
	 */
	public void setModel(JunColorChoiceModel aModel) {
		this.model_(aModel);
	}

	/**
	 * Answer the area of squit.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle spuitArea() {
		int originX = this.colorArea().x + this.colorArea().width + 9;
		int originY = this.colorArea().y + 7;
		Rectangle box = new Rectangle(originX, originY, 17, 17);
		return box;
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (!this.isShowing()) {
			return;
		}

		if (evt.getAspect() == $("xy")) {
			Graphics gc = this.getGraphics();
			this.displayPlateOn_(gc);
			this.displayXYOn_(gc);
			this.displayBarOn_(gc);
			this.displayColorOn_(gc);
			this.displayHueOn_(gc);
			this.displaySaturationOn_(gc);
			this.displayBrightnessOn_(gc);
			gc.dispose();
		}

		if (evt.getAspect() == $("z")) {
			Graphics gc = this.getGraphics();
			this.displayPlateOn_(gc);
			this.displayXYOn_(gc);
			this.displayBarOn_(gc);
			this.displayZOn_(gc);
			this.displayColorOn_(gc);
			this.displayHueOn_(gc);
			this.displaySaturationOn_(gc);
			this.displayBrightnessOn_(gc);
			gc.dispose();
		}

		if (evt.getAspect() == $("color")) {
			Graphics gc = this.getGraphics();
			this.displayOn_(gc);
			gc.dispose();
		}
	}

	/**
	 * Build this component.
	 * 
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(null);
		this.setPreferredSize(new Dimension(230, 125));
	}

	/**
	 * Answer my default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunColorChoiceController();
	}

	/**
	 * Answer a default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @category model accessing
	 */
	protected StModel defaultModel() {
		return new JunColorChoiceHSB();
	}

	/**
	 * Display the bar.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayBarOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.barArea();
		this.getModel().bar().displayOn_at_(graphics, box.getLocation());
		graphics.setColor(Color.black);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}

	/**
	 * Display the brightness.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayBrightnessOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.brightnessArea();
		String text = "B:".concat(this.brightnessString());
		FontMetrics fontMetrics = graphics.getFontMetrics();
		int width = fontMetrics.stringWidth(text);
		int height = fontMetrics.getHeight();
		Point stringOrigin = new Point(((box.width - width) / 2) + box.x, (box.height - (height / 2) + box.y));
		graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
		graphics.setColor(StColorValue.VeryLightGray);
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawString(text, stringOrigin.x, stringOrigin.y);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}

	/**
	 * Display the color.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayColorOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.colorArea();
		graphics.setColor(this.getModel().color());
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}

	/**
	 * Display the hue.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayHueOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.hueArea();
		String text = "H:".concat(this.hueString());
		FontMetrics fontMetrics = graphics.getFontMetrics();
		int width = fontMetrics.stringWidth(text);
		int height = fontMetrics.getHeight();
		Point stringOrigin = new Point(((box.width - width) / 2) + box.x, (box.height - (height / 2) + box.y));
		graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
		graphics.setColor(StColorValue.VeryLightGray);
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawString(text, stringOrigin.x, stringOrigin.y);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}

	/**
	 * Display the plate.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayPlateOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.plateArea();
		this.getModel().plate().displayOn_at_(graphics, box.getLocation());
		graphics.setColor(Color.black);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}

	/**
	 * Display the saturation.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displaySaturationOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.saturationArea();
		String text = "S:".concat(this.saturationString());
		FontMetrics fontMetrics = graphics.getFontMetrics();
		int width = fontMetrics.stringWidth(text);
		int height = fontMetrics.getHeight();
		Point stringOrigin = new Point(((box.width - width) / 2) + box.x, (box.height - (height / 2) + box.y));
		graphics.clipRect(box.x, box.y, box.width + 1, box.height + 1);
		graphics.setColor(StColorValue.VeryLightGray);
		graphics.fillRect(box.x, box.y, box.width, box.height);
		graphics.setColor(Color.black);
		graphics.drawString(text, stringOrigin.x, stringOrigin.y);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}

	/**
	 * Display the spuit.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displaySpuitOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.spuitArea();
		graphics.drawImage(JunCursors.SpuitCursorImage(), box.x + 1, box.y + 1, this);
		graphics.setColor(Color.black);
		graphics.drawRect(box.x, box.y, box.width, box.height);
	}

	/**
	 * Display the XY.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayXYOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.plateArea();
		graphics.clipRect(box.x, box.y, box.width, box.height);
		int x = (int) (this.getModel().xy().x() * (box.width - 1) + box.x);
		int y = (int) (this.getModel().xy().y() * (box.height - 1) + box.y);
		Color white = Color.white;
		Color black = Color.black;
		graphics.setColor(white);
		for (int angle = 0; angle < 360; angle = angle + 30) {
			graphics.drawArc(x - 4, y - 4, 8, 8, angle, 30);
			if (black.equals(graphics.getColor())) {
				graphics.setColor(white);
			} else {
				graphics.setColor(black);
			}
		}
	}

	/**
	 * Display the Z.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	protected void displayZOn_(Graphics aGraphics) {
		Graphics graphics = aGraphics.create();
		Rectangle box = this.barArea();
		Rectangle boxL = new Rectangle(box.x - 4, box.y - 3, 4, box.height + 7);
		Rectangle boxR = new Rectangle(box.x + box.width + 1, box.y - 3, 4, box.height + 7);
		graphics.setColor(this.getBackground());
		graphics.fillRect(boxL.x, boxL.y, boxL.width, boxL.height);
		graphics.fillRect(boxR.x, boxR.y, boxR.width, boxR.height);

		Point[] points = new Point[4];
		points[0] = new Point(0, 0);
		points[1] = new Point(3, -3);
		points[2] = new Point(3, 3);
		points[3] = new Point(0, 0);

		int height = (int) (this.getModel().z() * (box.height - 1));
		Point offsetR = new Point(box.x + box.width + 1, height + box.y);
		Point offsetL = new Point(box.x - 1, height + box.y);
		int[] xLs = new int[4];
		int[] yLs = new int[4];
		int[] xRs = new int[4];
		int[] yRs = new int[4];
		for (int i = 0; i < 4; i++) {
			xRs[i] = offsetR.x + points[i].x;
			yRs[i] = offsetR.y + points[i].y;
			xLs[i] = offsetL.x - points[i].x;
			yLs[i] = offsetL.y + points[i].y;
		}

		graphics.setColor(Color.black);
		graphics.drawPolyline(xRs, yRs, 4);
		graphics.drawPolyline(xLs, yLs, 4);
	}

	/**
	 * Answer display round unit.
	 * 
	 * @return double
	 * @category string accessing
	 */
	protected double round() {
		return 0.01;
	}
	
}