package jp.co.sra.jun.goodies.colors;

import java.awt.Color;

import jp.co.sra.smalltalk.SystemInterface;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunColorSpuit class
 * 
 *  @author    Hoshi Takanori
 *  @created   2002/03/04 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorSpuit.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorSpuit extends JunAbstractObject {
	/**
	 * Request color spuit.
	 * 
	 * @return java.awt.Color
	 * @category Utilities
	 */
	public static Color Request() {
		SystemInterface StPLInterface = SystemInterface.Current();
		synchronized (StPLInterface) {
			return new Color(StPLInterface.utilColorSpuit());
		}
	}
}