package jp.co.sra.jun.goodies.drawing;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunDrawingViewAwt class
 * 
 *  @author    m-asada
 *  @created   2005/06/07 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDrawingViewAwt.java,v 8.11 2008/02/20 06:31:23 nisinaka Exp $
 */
public class JunDrawingViewAwt extends JunAbstractViewPanel implements JunDrawingView {
	protected JunDrawingMapViewAwt drawingMapView;
	protected JunButtonViewAwt selectButtonView;
	protected JunButtonViewAwt brushButtonView;
	protected JunButtonViewAwt cameraButtonView;
	protected JunButtonViewAwt ellipseButtonView;
	protected JunButtonViewAwt linkButtonView;
	protected JunButtonViewAwt pathButtonView;
	protected JunButtonViewAwt rectangleButtonView;
	protected JunButtonViewAwt roundRectangleButtonView;
	protected JunButtonViewAwt textButtonView;
	protected JunButtonViewAwt textboxButtonView;

	/**
	 * Create a new instance of <code>JunDrawingViewAwt</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunDrawingViewAwt() {
		super();
	}

	/**
	 * Create a new instance of <code>JunDrawingViewAwt</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.JunDrawing
	 * @category Instance creation
	 */
	public JunDrawingViewAwt(JunDrawing newModel) {
		super(newModel);
	}

	/**
	 * Answer the receiver's model as JunDrawing.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.JunDrawing
	 * @see jp.co.sra.jun.goodies.drawing.JunDrawingView#getDrawingModel()
	 * @category model accessing
	 */
	public JunDrawing getDrawingModel() {
		return (JunDrawing) this.model();
	}

	/**
	 * Initialize the JunDrawingViewAwt.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		drawingMapView = null;
		selectButtonView = null;

		brushButtonView = null;
		cameraButtonView = null;
		ellipseButtonView = null;
		linkButtonView = null;
		pathButtonView = null;
		rectangleButtonView = null;
		roundRectangleButtonView = null;
		textButtonView = null;
		textboxButtonView = null;
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		Dimension size = new Dimension(24, 24);
		this.setLayout(new WindowSpecLayout());
		this.add(this.drawingMapView().toComponent(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, -size.width, 1f, 0));

		this.add(this.selectButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 0 + 0, 1f, 0, 0f, size.height * 1 + 0));
		this.add(this.textButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 1 + 1, 1f, 0, 0f, size.height * 2 + 1));
		this.add(this.textboxButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 2 + 2, 1f, 0, 0f, size.height * 3 + 2));
		this.add(this.cameraButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 3 + 3, 1f, 0, 0f, size.height * 4 + 3));
		this.add(this.ellipseButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 4 + 4, 1f, 0, 0f, size.height * 5 + 4));
		this.add(this.rectangleButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 5 + 5, 1f, 0, 0f, size.height * 6 + 5));
		this.add(this.roundRectangleButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 6 + 6, 1f, 0, 0f, size.height * 7 + 6));
		this.add(this.pathButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 7 + 7, 1f, 0, 0f, size.height * 8 + 7));
		this.add(this.brushButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 8 + 8, 1f, 0, 0f, size.height * 9 + 8));
		this.add(this.linkButtonView(), WindowSpecLayout.Position(1f, -size.width, 0f, size.height * 9 + 11, 1f, 0, 0f, size.height * 10 + 11));
		this.setSize(500, 300);
	}

	/**
	 * Answer the drawing map view.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView
	 * @see jp.co.sra.jun.goodies.drawing.JunDrawingView#drawingMapView()
	 * @category interface opening
	 */
	public JunDrawingMapView drawingMapView() {
		if (drawingMapView == null) {
			drawingMapView = new JunDrawingMapViewAwt(this.getDrawingModel().mapModel());
			drawingMapView.toComponent().addPropertyChangeListener(new PropertyChangeListener() {
				public void propertyChange(PropertyChangeEvent evt) {
					if (evt.getPropertyName().equals("editMode")) {
						JunDrawingViewAwt.this.getDrawingModel().updateToolbar_(((Number) evt.getNewValue()).intValue());
					}
				}
			});
		}
		return drawingMapView;
	}

	/**
	 * Answer the brush button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt brushButtonView() {
		if (brushButtonView == null) {
			brushButtonView = new JunButtonViewAwt(this.getDrawingModel().brushButton());
		}
		return brushButtonView;
	}

	/**
	 * Answer the camera button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt cameraButtonView() {
		if (cameraButtonView == null) {
			cameraButtonView = new JunButtonViewAwt(this.getDrawingModel().cameraButton());
		}
		return cameraButtonView;
	}

	/**
	 * Answer the ellipse button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt ellipseButtonView() {
		if (ellipseButtonView == null) {
			ellipseButtonView = new JunButtonViewAwt(this.getDrawingModel().ellipseButton());
		}
		return ellipseButtonView;
	}

	/**
	 * Answer the link button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt linkButtonView() {
		if (linkButtonView == null) {
			linkButtonView = new JunButtonViewAwt(this.getDrawingModel().linkButton());
		}
		return linkButtonView;
	}

	/**
	 * Answer the path button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt pathButtonView() {
		if (pathButtonView == null) {
			pathButtonView = new JunButtonViewAwt(this.getDrawingModel().pathButton());
		}
		return pathButtonView;
	}

	/**
	 * Answer the rectangle button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt rectangleButtonView() {
		if (rectangleButtonView == null) {
			rectangleButtonView = new JunButtonViewAwt(this.getDrawingModel().rectangleButton());
		}
		return rectangleButtonView;
	}

	/**
	 * Answer the round rectangle button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt roundRectangleButtonView() {
		if (roundRectangleButtonView == null) {
			roundRectangleButtonView = new JunButtonViewAwt(this.getDrawingModel().roundRectangleButton());
		}
		return roundRectangleButtonView;
	}

	/**
	 * Answer the select button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt selectButtonView() {
		if (selectButtonView == null) {
			selectButtonView = new JunButtonViewAwt(this.getDrawingModel().selectButton());
		}
		return selectButtonView;
	}

	/**
	 * Answer the text button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt textButtonView() {
		if (textButtonView == null) {
			textButtonView = new JunButtonViewAwt(this.getDrawingModel().textButton());
		}
		return textButtonView;
	}

	/**
	 * Answer the text box button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category interface opening
	 */
	protected JunButtonViewAwt textboxButtonView() {
		if (textboxButtonView == null) {
			textboxButtonView = new JunButtonViewAwt(this.getDrawingModel().textboxButton());
		}
		return textboxButtonView;
	}
}
