package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.geom.RoundRectangle2D;
import jp.co.sra.jun.goodies.lisp.JunLispList;

/**
 * JunRoundRectangleElement class
 * 
 *  @author    m-asada
 *  @created   2005/04/04 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunRoundRectangleElement.java,v 8.11 2008/02/20 06:31:23 nisinaka Exp $
 */
public class JunRoundRectangleElement extends JunRectangularShapeElement {
	public static DataFlavor DataFlavor = new DataFlavor(JunRoundRectangleElement.class, "JunRoundRectangleElement");

	/**
	 * Create a new instance of JunRoundRectangleElement and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunRoundRectangleElement() {
		super();
	}

	/**
	 * Create a new instance of JunRoundRectangleElement and initialize it.
	 *
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunRoundRectangleElement(JunLispList aList) {
		super(aList);
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		Graphics2D graphicsContext = (Graphics2D) aGraphics.create();
		try {
			graphicsContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
			super.displayOn_(graphicsContext);
		} finally {
			if (graphicsContext != null) {
				graphicsContext.dispose();
			}
		}
	}

	/**
	 * Returns an array of DataFlavor objects indicating the flavors the data can be provided in. The array should be
	 * ordered according to preference for providing the data (from most richly descriptive to least descriptive).
	 * 
	 * @return java.awt.datatransfer.DataFlavor[]
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#getTransferDataFlavors()
	 * @category transfering
	 */
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { JunRoundRectangleElement.DataFlavor };
	}

	/**
	 * Answer the receiver's shape.
	 * 
	 * @return java.awt.Shape
	 * @see jp.co.sra.jun.goodies.drawing.element.JunRectangularShapeElement#shape()
	 * @category private
	 */
	protected Shape shape() {
		if (shape == null) {
			int lineWidth = this.lineWidth();
			int arcw = Math.min(16, (this.width() - lineWidth) / 2);
			int arch = Math.min(16, (this.height() - lineWidth) / 2);
			shape = new RoundRectangle2D.Double(this.x() + lineWidth / 2, this.y() + lineWidth / 2, this.width() - lineWidth, this.height() - lineWidth, arcw, arch);
		}
		return shape;
	}
}
