package jp.co.sra.jun.goodies.gauge;

import java.awt.Dialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunGaugeDialog class
 * 
 *  @author    nisinaka
 *  @created   2004/04/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGaugeDialog.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunGaugeDialog extends StSimpleDialog {

	protected JunGaugeModel gaugeModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Open JunGaugeDialog to request a value.
	 * 
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request() {
		return Request(JunSystem.$String("Select a value."));
	}

	/**
	 * Open a JunGaugeDialog to request a value.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString java.lang.String
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString) {
		return Request(messageString, new JunGaugeModel());
	}

	/**
	 * Open a JunGaugeDialog to request a value with the speicified gauge model.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString 
	 * @param aGaugeModel
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunGaugeModel aGaugeModel) {
		return Request(messageString, aGaugeModel, null, null);
	}

	/**
	 * Open a JunGaugeDialog to request a value with the speicified gauge model.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString
	 * @param aGaugeModel
	 * @param acceptBlock
	 * @param cancelBlock
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, JunGaugeModel aGaugeModel, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunGaugeDialog gaugeDialog = new JunGaugeDialog();
		if (aGaugeModel != null) {
			gaugeDialog.gaugeModel_(aGaugeModel);
		}
		Dialog aDialog = gaugeDialog.allButOpenDialog();
		if (messageString != null) {
			aDialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			gaugeDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			gaugeDialog.cancelBlock_(cancelBlock);
		}

		_ShowAtMousePoint(aDialog);

		return (gaugeDialog.accept()._booleanValue()) ? gaugeDialog.gaugeModel().value() : null;
	}

	/**
	 * Open a JunGaugeDialog to request a value with the speicified initial value.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString java.lang.String
	 * @param value double
	 * @return java.lang.Object
	 * @category Utilities
	 */
	public static Object Request(String messageString, double value) {
		return Request(messageString, new JunGaugeModel(value));
	}

	/**
	 * Open a JunGaugeDialog to request a value with the speicified initial value.
	 * The message string will be shown as the window title.
	 * 
	 * @param messageString java.lang.String
	 * @param value double
	 * @param fromValue double
	 * @param toValue double
	 * @param roundValue double
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static Object Request(String messageString, double value, double fromValue, double toValue, double roundValue) {
		return Request(messageString, new JunGaugeModel(value, fromValue, toValue, roundValue));
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		gaugeModel = null;
		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer my current gauge model.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunGaugeModel
	 * @category accessing
	 */
	public JunGaugeModel gaugeModel() {
		if (gaugeModel == null) {
			gaugeModel = new JunGaugeModel();
		}
		return gaugeModel;
	}

	/**
	 * Set my new gauge model.
	 * 
	 * @param newGaugeModel jp.co.sra.jun.goodies.gauge.JunGaugeModel
	 * @category accessing
	 */
	public void gaugeModel_(JunGaugeModel newGaugeModel) {
		gaugeModel = newGaugeModel;
	}

	/**
	 * Set my new accept block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void acceptBlock_(StBlockClosure aBlock) {
		acceptBlock = aBlock;
	}

	/**
	 * Set my new cancel block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void cancelBlock_(StBlockClosure aBlock) {
		cancelBlock = aBlock;
	}

	/**
	 * Called when the accept button is pressed.
	 * 
	 * @return boolean
	 * @category actions
	 */
	protected boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			return ((Boolean) acceptBlock.value_(this.gaugeModel())).booleanValue();
		}

		return true;

	}

	/**
	 * Called when the cancel button is pressed.
	 * 
	 * @return boolean
	 * @category actions
	 */
	protected boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			return ((Boolean) cancelBlock.value_(this.gaugeModel())).booleanValue();
		}

		return true;
	}

	/**
	 * Answer my default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunGaugeDialogViewAwt(this);
		} else {
			return new JunGaugeDialogViewSwing(this);
		}
	}

}
