package jp.co.sra.jun.goodies.gauge;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunGaugeDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2004/04/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGaugeDialogViewSwing.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunGaugeDialogViewSwing extends StSimpleDialogViewSwing implements JunGaugeDialogView {

	protected JunGaugeViewSwing gaugeView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of JunGaugeDialogViewSwing and initialize it.
	 * 
	 * @param aGaugeDialog jp.co.sra.jun.goodies.gauge.JunGaugeDialogViewSwing
	 * @category Instance creation
	 */
	public JunGaugeDialogViewSwing(JunGaugeDialog aGaugeDialog) {
		super(aGaugeDialog);
	}

	/**
	 * Answer my model as JunGaugeDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunGaugeDialog
	 * @see jp.co.sra.jun.goodies.gauge.JunGaugeDialogView#getGaugeDialog()
	 * @category model accessing
	 */
	public JunGaugeDialog getGaugeDialog() {
		return (JunGaugeDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @category interface specs
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.gaugeView()._onBorderedPanel(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, -104, 1f, 0));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.setPreferredSize(new Dimension(200, 200));

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my gauge view.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunGaugeViewSwing
	 * @category user interface
	 */
	protected JunGaugeViewSwing gaugeView() {
		if (gaugeView == null) {
			gaugeView = new JunGaugeViewSwing(this.getGaugeDialog().gaugeModel());
		}
		return gaugeView;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunGaugeDialogViewSwing.this.getGaugeDialog().acceptButtonPressed()) {
						JunGaugeDialogViewSwing.this.getGaugeDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunGaugeDialogViewSwing.this.getGaugeDialog().cancelButtonPressed()) {
						JunGaugeDialogViewSwing.this.getGaugeDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.gaugeView()._setupKeyboard(aWindow);
	}

}
