package jp.co.sra.jun.goodies.gauge;

import java.awt.Color;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunGaugeView interface
 * 
 *  @author    nisinaka
 *  @created   2004/04/13 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGaugeView.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public interface JunGaugeView extends JunAbstractView {

	public static Color SelectionBackgroundColor = new Color(0.0391894f, 0.141131f, 0.415578f);
	public static Color SelectionForegroundColor = Color.white;

	/**
	 * Answer my model as JunGaugeModel.
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunGaugeModel
	 * @category model accessing
	 */
	public JunGaugeModel getGaugeModel();

	/**
	 * Answer the border rectangle of the gauge.
	 * 
	 * @return java.awt.Rectangle
	 * @category accessing
	 */
	public StRectangle gaugeBorder();

}
