package jp.co.sra.jun.goodies.gauge;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Random;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.goodies.utilities.JunControlUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunLevelGaugeModelTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/03 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLevelGaugeModelTestExamples.java,v 8.8 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunLevelGaugeModelTestExamples extends JunTestExamples {
	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunLevelGaugeModelTestExamples();
	}

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Value_(0);
		levelGauge.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value.toString());
				return null;
			}
		});
		for (int i = -100; i <= 100; i += 10) {
			levelGauge.value_(i);
		}

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final int tickTime = 100;
		JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Value_(NextMillisecondClockValue_(tickTime));
		levelGauge.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(((Number) value).longValue());
				return null;
			}
		});
		for (int i = 0; i < 10; i++) {
			levelGauge.value_(NextMillisecondClockValue_(tickTime));
		}

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final int tickTime = 100;
		JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Initial_(NextMillisecondClockValue_(tickTime));
		levelGauge.compute_(new StBlockClosure() {
			public Object value_(Object value) {
				System.out.println(value.toString());
				return null;
			}
		});
		for (int i = 0; i < 10; i++) {
			levelGauge.value_(NextMillisecondClockValue_(tickTime));
		}
		System.out.println("--------");
		try {
			Thread.sleep(3000);
		} catch (InterruptedException e) {
		}
		levelGauge.resume_(NextMillisecondClockValue_(tickTime));
		for (int i = 0; i < 10; i++) {
			levelGauge.value_(NextMillisecondClockValue_(tickTime));
		}

		return true;
	}

	/**
	 * Example4: Open a JunLevelGaugeModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		final JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Value_maximum_minimum_(50, 100, 0);
		levelGauge.open();
		ExampleDo_(new StBlockClosure() {
			public Object value_(Object aRandom) {
				levelGauge.value_(((Random) aRandom).nextDouble() * levelGauge.range() + levelGauge.minimum());
				return null;
			}
		});

		return true;
	}

	/**
	 * Example5: Open a JunLevelGaugeModel with horizontail.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		final JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Value_maximum_minimum_(50, 100, 0);
		levelGauge.horizontalGauge_(true);
		levelGauge.gaugeWidth_(6);
		levelGauge.cellSize_(4);
		levelGauge.cellSpace_(3);
		levelGauge.open();
		ExampleDo_(new StBlockClosure() {
			public Object value_(Object aRandom) {
				levelGauge.value_(((Random) aRandom).nextDouble() * levelGauge.range() + levelGauge.minimum());
				return null;
			}
		});

		return true;
	}

	/**
	 * Example6: Open a JunLevelGaugeModel with reverse direction.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		final JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Value_maximum_minimum_(50, 100, 0);
		levelGauge.reverseDirection_(true);
		levelGauge.open();
		ExampleDo_(new StBlockClosure() {
			public Object value_(Object aRandom) {
				levelGauge.value_(((Random) aRandom).nextDouble() * levelGauge.range() + levelGauge.minimum());
				return null;
			}
		});

		return true;
	}

	/**
	 * Example7: Open a JunLevelGaugeModel with horizontail and reverse direction.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		final JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Value_maximum_minimum_(50, 100, 0);
		levelGauge.horizontalGauge_(true);
		levelGauge.reverseDirection_(true);
		levelGauge.gaugeWidth_(6);
		levelGauge.cellSize_(4);
		levelGauge.cellSpace_(3);
		levelGauge.open();
		ExampleDo_(new StBlockClosure() {
			public Object value_(Object aRandom) {
				levelGauge.value_(((Random) aRandom).nextDouble() * levelGauge.range() + levelGauge.minimum());
				return null;
			}
		});

		return true;
	}

	/**
	 * Example8: Open a JunLevelGaugeModel with rainbow color.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		final JunLevelGaugeModel levelGauge = JunLevelGaugeModel.Value_maximum_minimum_(50, 100, 0);
		levelGauge.verticalGauge_(false);
		levelGauge.gaugeWidth_(32);
		levelGauge.cellSize_(7);
		levelGauge.cellSpace_(3);
		levelGauge.backgroundColor_(Color.gray);
		levelGauge.valueColor_(Color.white);
		levelGauge.hillColor_(Color.white);
		levelGauge.averageColor_(Color.white);
		levelGauge.daleColor_(Color.white);
		levelGauge.rainbowColor_(true);
		levelGauge.showHill_(true);
		levelGauge.showDale_(false);
		levelGauge.showAverage_(false);
		levelGauge.openIn_(new Rectangle(200, 300, 512, 128));
		ExampleDo_(new StBlockClosure() {
			public Object value_(Object aRandom) {
				levelGauge.value_(((Random) aRandom).nextDouble() * levelGauge.range() + levelGauge.minimum());
				return null;
			}
		});

		return true;
	}

	/**
	 * Evaluation a example block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Examples
	 */
	protected static Object ExampleDo_(final StBlockClosure aBlock) {
		int howLong = 5000;
		int tickTime = 100;
		final Random aRandom = new Random();
		long currentTime = System.currentTimeMillis();
		long endTime = currentTime + howLong;
		final StValueHolder aResultHolder = new StValueHolder();
		try {
			Thread.sleep(tickTime);
		} catch (InterruptedException e) {
		}
		while (System.currentTimeMillis() <= endTime) {
			JunControlUtility.Do_forMilliseconds_(new StBlockClosure() {
				public Object value() {
					aResultHolder.value_(aBlock.value_(aRandom));
					return null;
				}
			}, tickTime);
		}
		return aResultHolder.value();
	}

	/**
	 * Wait next millisecond clock value with a tick time.
	 * 
	 * @param tickTime int
	 * @return long
	 * @category Private
	 */
	private static long NextMillisecondClockValue_(int tickTime) {
		long currentTime = System.currentTimeMillis();
		long nextTime = currentTime + tickTime;
		nextTime = (Math.round(Math.ceil(nextTime / (double) tickTime))) * tickTime;
		JunControlUtility.WaitUntilTimeMillis_(nextTime);
		return nextTime;
	}
}
