package jp.co.sra.jun.goodies.gauge;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSimpleGaugeModelTestExamples class
 * 
 *  @author    Hoshi Takanori
 *  @created   2003/08/28 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSimpleGaugeModelTestExamples.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunSimpleGaugeModelTestExamples extends JunTestExamples {

	/**
	 * Example1: Open a JunSimpleGaugeModel.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunSimpleGaugeModel simpleGaugeModel = new JunSimpleGaugeModel(0.5);
		simpleGaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		simpleGaugeModel.open();
		return true;
	}

	/**
	 * Example2: Open a JunJunSimpleGaugeModel with from, to, and round values.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunSimpleGaugeModel simpleGaugeModel = new JunSimpleGaugeModel(5, 0, 10, 0.1);
		simpleGaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		simpleGaugeModel.open();
		return true;
	}

	/**
	 * Example3: Open a JunJunSimpleGaugeModel with from, to, and round values.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunSimpleGaugeModel simpleGaugeModel = new JunSimpleGaugeModel(50, 0, 100, 0.01);
		simpleGaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		simpleGaugeModel.open();
		return true;
	}

	/**
	 * Example4: Open a JunJunSimpleGaugeModel with from, to, and round values.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunSimpleGaugeModel simpleGaugeModel = new JunSimpleGaugeModel(50, 100, -100, 1);
		simpleGaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		simpleGaugeModel.open();
		return true;
	}

	/**
	 * Example5: Open a JunSimpleGaugeModel.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunSimpleGaugeModel simpleGaugeModel = new JunSimpleGaugeModel(0.5);
		simpleGaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		simpleGaugeModel.valueStringBlock_(new StBlockClosure() {
			public Object value_(Object newValue) {
				return Long.toString(Math.round(((Double) newValue).doubleValue() * 100));
			}
		});
		simpleGaugeModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunSimpleGaugeModelTestExamples();
	}
}
