package jp.co.sra.jun.goodies.image.framework;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImageDisplayModelTestExamples class
 * 
 *  @author    m-asada
 *  @created   2006/04/06 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageDisplayModelTestExamples.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageDisplayModelTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunImageDisplayModel model = new JunImageDisplayModel(StImage._FromUser());
		model.open();
		return true;
	}

	/**
	 * Example2: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunImageDisplayModel model = new JunImageDisplayModel(StImage._OfArea(new Rectangle(0, 0, 300, 300)));
		model.open();
		return true;
	}

	/**
	 * Example3: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		JunImageDisplayModel model = new JunImageDisplayModel(StImage._OfArea(new Rectangle(0, 0, screenSize.width, screenSize.height)));
		model.open();
		return true;
	}

	/**
	 * Example4: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		StImage anImage = Border_(StImage._OfArea(new Rectangle(0, 0, 300, 300)));
		JunImageDisplayModel.Show_at_(anImage, new Point(200, 200));
		JunImageDisplayModel.Show_label_at_(anImage, "Example4", new Point(400, 400));
		return true;
	}

	/**
	 * Example5: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		StImage anImage = Border_(StImage._OfArea(new Rectangle(0, 0, 300, 300)));
		JunImageDisplayModel.Show_in_(anImage, new Rectangle(200, 200, 300, 200));
		JunImageDisplayModel.Show_label_in_(anImage, "Example5", new Rectangle(400, 400, 300, 200));
		return true;
	}

	/**
	 * Display border on the specified image, and answer it.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Utilities
	 */
	protected static StImage Border_(StImage anImage) {
		Graphics aGraphics = anImage.image().getGraphics();
		try {
			aGraphics.setColor(Color.red);
			aGraphics.drawRect(0, 0, anImage.width() - 1, anImage.height() - 1);
		} finally {
			aGraphics.dispose();
		}
		return anImage;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunImageDisplayModelTestExamples();
	}
}
