package jp.co.sra.jun.goodies.image.framework;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunImageDisplayViewSwing class
 * 
 *  @author    m-asada
 *  @created   2006/04/06 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageDisplayViewSwing.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageDisplayViewSwing extends JunAbstractViewJPanel implements JunImageDisplayView {
	protected boolean _scrollable;
	protected StViewJPanel canvas;
	protected JScrollPane scrollPane;

	/**
	 * Create a new instance of <code>JunImageDisplayViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunImageDisplayViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunImageDisplayViewSwing</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Instance creation
	 */
	public JunImageDisplayViewSwing(JunImageDisplayModel newModel) {
		super(newModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		canvas = null;
		scrollPane = null;
		this._scrollable(false);
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.scrollPane(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, 0));

		Dimension imageSize = this.getModel().bounds().getSize();
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		screenSize.setSize(screenSize.width - 50 * 2, screenSize.height - 60 * 2);
		Insets insets = this.scrollPane().getInsets();
		if (imageSize.width > screenSize.width || imageSize.height > screenSize.height) {
			this._scrollable(true);
			this.setPreferredSize(new Dimension(Math.min(imageSize.width, screenSize.width) + insets.left + insets.right, Math.min(imageSize.height, screenSize.height) + insets.top + insets.bottom));
		} else {
			this._scrollable(false);
			this.setPreferredSize(new Dimension(imageSize.width + insets.left + insets.right, imageSize.height + insets.top + insets.bottom));
		}
	}

	/**
	 * Answer whether the view is opened with scrollbars or not.
	 *
	 * @return boolean
	 * @category accessing
	 */
	public boolean _isScrollable() {
		return _scrollable;
	}

	/**
	 * Set whether the view is opened with scrollbars or not.
	 *
	 * @param aBoolean boolean
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#_scrollable(boolean)
	 * @category accessing
	 */
	public void _scrollable(boolean aBoolean) {
		_scrollable = aBoolean;
		if (_scrollable) {
			this.scrollPane().setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			this.scrollPane().setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		} else {
			this.scrollPane().setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
			this.scrollPane().setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		}
	}

	/**
	 * Do the layout on the scroll pane.
	 * 
	 * @see java.awt.Component#addNotify()
	 * @category actions
	 */
	public void addNotify() {
		super.addNotify();
		this.doLayout();
		this.scrollPane().doLayout();
	}

	/**
	 * Gets the preferred size of this component.
	 * 
	 * @return java.awt.Dimension
	 * @see java.awt.Component#getPreferredSize()
	 * @category bounds accessing
	 */
	public Dimension getPreferredSize() {
		Point location = this.scrollPane().getLocation();
		Dimension size = this.scrollPane().getPreferredSize();
		return new Dimension(size.width + location.x * 2, size.height + location.y * 2);
	}

	/**
	 * Answer the viewport bounds at the recevier's scroll pane.
	 * 
	 * @return java.awt.Rectangle
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#_getViewportBounds()
	 * @category bounds accessing
	 */
	public Rectangle _getViewportBounds() {
		return this.scrollPane().getViewport().getViewRect();
	}

	/**
	 * Answer a default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
	 * @category controller accessing
	 * 
	 */
	protected StController defaultController() {
		return new JunImageDisplayController();
	}

	/**
	 * Answer the receiver's model as JunImageDisplayModel.
	 * 
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#getModel()
	 * @category model accessing
	 */
	public JunImageDisplayModel getModel() {
		return (JunImageDisplayModel) this.model();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a dependent.
	 * The argument anAspectSymbol is typically a Symbol that indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.topComponent().isShowing() == false) {
			return;
		}
		if (evt.getAspect() == $("redisplay")) {
			this.canvas().repaint();
		} else {
			super.update_(evt);
		}
	}

	/**
	 * Answer my canvas.
	 *
	 * @return jp.co.sra.smalltalk.StViewJPanel
	 * @category user interface
	 */
	public StViewJPanel canvas() {
		if (canvas == null) {
			canvas = new StViewJPanel() {
				public StModel model() {
					return JunImageDisplayViewSwing.this.model();
				}

				public Dimension getPreferredSize() {
					if (JunImageDisplayViewSwing.this._isScrollable()) {
						return JunImageDisplayViewSwing.this.getModel() == null ? Toolkit.getDefaultToolkit().getScreenSize() : JunImageDisplayViewSwing.this.getModel().bounds().getSize();
					} else {
						return super.getPreferredSize();
					}
				}

				public void displayOn_(Graphics aGraphics) {
					if (JunImageDisplayViewSwing.this.getModel().displayImage() == null) {
						return;
					}
					JunImageDisplayViewSwing.this.getModel().displayImage().displayOn_(aGraphics);
				}

				public void _showPopupMenu(int x, int y) {
					JPopupMenu popupMenu = JunImageDisplayViewSwing.this.popupMenuView();
					if (popupMenu != null) {
						popupMenu.show(this, x, y);
					}
				}
			};
		}
		return canvas;
	}

	/**
	 * Answer the receiver's canvas as Component.
	 * 
	 * @return java.awt.Component
	 * @see jp.co.sra.jun.goodies.image.framework.JunImageDisplayView#_canvasComponent()
	 * @category user interface
	 */
	public Component _canvasComponent() {
		return this.canvas().toComponent();
	}

	/**
	 * Answer my scroll pane, which already contains the canvas.
	 *
	 * @return javax.swing.JScrollPane
	 * @category user interface
	 */
	public JScrollPane scrollPane() {
		if (scrollPane == null) {
			scrollPane = new JScrollPane(this.canvas()) {
				public Dimension getPreferredSize() {
					Dimension size = JunImageDisplayViewSwing.this.getModel().bounds().getSize();
					Insets insets = this.getInsets();
					return new Dimension(size.width + insets.left + insets.right, size.height + insets.top + insets.bottom);
				}
			};
			scrollPane.getHorizontalScrollBar().setFocusable(false);
			scrollPane.getVerticalScrollBar().setFocusable(false);
		}
		return scrollPane;
	}
}
