package jp.co.sra.jun.goodies.image.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jp.co.sra.smalltalk.StImage;

import com.sun.jimi.core.Jimi;

/**
 * JunJimiGifImageStream class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2000/11/22 (by Mitsuhiro Asada)
 *  @updated   2004/08/12 (by Mitsuhiro Asada)
 *  @updated   2005/08/15 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunJimiGifImageStream.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunJimiGifImageStream extends JunGifImageStream {
	/**
	 * Constructor with an input stream.
	 *
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream 
	 * @param stream java.io.InputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(InputStream stream) throws IOException {
		return On_(new JunJimiGifImageStream(), stream);
	}

	/**
	 * Constructor with an output stream.
	 *
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream 
	 * @param stream java.io.OutputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(OutputStream stream) throws IOException {
		throw new IOException("could not save image");
	}

	/**
	 * Read the image from the input stream.
	 * (used JIMI Software Development Kit)
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public StImage nextImage() throws IOException {
		if (inStream != null) {
			imageObject = new StImage(Jimi.getImage(inStream, "image/gif"));
		}
		return imageObject;
	}

	/**
	 * Write the image on the output stream.
	 * (used JIMI Software Development Kit)
	 *
	 * @param newImage jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public void nextPutImage_(StImage newImage) throws IOException {
		throw new IOException("could not save image");
	}

	/**
	 * Set the output stream.
	 * 
	 * @param stream java.io.OutputStream
	 * @exception java.io.IOException
	 * @category initialize-release
	 */
	protected void on_(OutputStream stream) throws IOException {
		throw new IOException("could not save image");
	}
}
