package jp.co.sra.jun.goodies.image.support;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunImageProcessor class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/16 (by Hirotsugu Kondo)
 *  @updated   2000/02/16 (by Mitsuhiro Asada)
 *  @updated   2003/09/09 (by Mitsuhiro Asada)
 *  @updated   2006/10/26 (by Mitsuhiro Asada)
 *  @updated   2007/06/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun668 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageProcessor.java,v 8.17 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageProcessor extends JunAbstractObject {

	private static int[] Stipples;
	private static StImage[] Masks;
	private static IndexColorModel ColorPalette256;
	private static IndexColorModel GrayPalette256;
	private static IndexColorModel _WhiteBlackPalette;
	private static IndexColorModel _BlackWhitePalette;

	static {
		Initialize();
	}

	/**
	 * Answer the ColorModel for Black and White.
	 * 
	 * @return java.awt.image.IndexColorModel
	 * @category Constants of palette
	 */
	public static final IndexColorModel _BlackWhitePalette() {
		if (_BlackWhitePalette == null) {
			byte[] palette = { (byte) 0, (byte) 255 };
			_BlackWhitePalette = new IndexColorModel(1, 2, palette, palette, palette);
		}

		return _BlackWhitePalette;
	}

	/**
	 * Answer shape image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param figure jp.co.sra.smalltalk.StImage
	 * @param shape jp.co.sra.smalltalk.StImage
	 * @category Opaque imaging
	 */
	public static StImage _MakeImage_Shape_(StImage figure, StImage shape) {
		if (figure.extent().equals(shape.extent())) {
			ColorModel colorModel = ColorModel.getRGBdefault();
			int width = figure.width();
			int height = figure.height();
			int[] pixels = new int[width * height];
			int[] figurePixels = figure.getPixels();
			int[] shapePixels = shape.getPixels();

			for (int i = 0; i < (width * height); i++) {
				if (figurePixels[i] != 0x00FFFFFF) {
					int red = colorModel.getRed(figurePixels[i]);
					int green = colorModel.getGreen(figurePixels[i]);
					int blue = colorModel.getBlue(figurePixels[i]);
					int alpha = colorModel.getAlpha(shapePixels[i]);
					pixels[i] = (alpha << 24) | (red << 16) | (green << 8) | (blue << 0);
				} else if (shapePixels[i] != 0x00FFFFFF) {
					pixels[i] = shapePixels[i];
				} else {
					pixels[i] = 0x00FFFFFF;
				}
			}

			return new StImage(width, height, pixels);
		}

		return null;
	}

	/**
	 * Answer the ColorModel for White and Black.
	 * 
	 * @return java.awt.image.IndexColorModel
	 * @category Constants of palette
	 */
	public static final IndexColorModel _WhiteBlackPalette() {
		if (_WhiteBlackPalette == null) {
			byte[] palette = { (byte) 255, (byte) 0 };
			_WhiteBlackPalette = new IndexColorModel(1, 2, palette, palette, palette);
		}
		return _WhiteBlackPalette;
	}

	/**
	 * Answer border following on anImage.
	 * 
	 * @return jp.co.sra.smalltalk.StAssociation[]
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category Tracing
	 */
	public static StAssociation[] BorderFollowing_(StImage anImage) {
		int b1;
		int b2;
		int b3;
		int b4;
		int direction;
		StImage temp = anImage.convertToPalette_(_WhiteBlackPalette());
		StImage image = new StImage(temp.width() + 2, temp.height() + 2);
		image.copy_from_in_rule_(new Rectangle(1, 1, temp.width(), temp.height()), new Point(0, 0), temp, StImage.Over);

		Vector borders = new Vector();
		int colorBlackValue = Color.black.getRGB();
		int colorWhiteValue = Color.white.getRGB();

		for (int i = 0; i < image.width(); i++) {
			for (int j = 0; j < image.height(); j++) {
				if (image.getPixel(i, j) == colorBlackValue) {
					b1 = image.getPixel(i, j + 1);
					b2 = image.getPixel(i - 1, j);
					b3 = image.getPixel(i, j - 1);
					b4 = image.getPixel(i + 1, j);
					if ((b1 | b2 | b3 | b4) == colorWhiteValue) {
						if (b4 == colorWhiteValue) {
							direction = 6; // in
						} else if (b3 == colorWhiteValue) {
							direction = 4; // out
						} else if (b2 == colorWhiteValue) {
							direction = 2; // out
						} else if (b1 == colorWhiteValue) {
							direction = 0; // in
						} else {
							direction = -1; // null
						}
						if (direction > 0) {
							Point[] collection = BorderFollowingPoint_direction_image_(new Point(i, j), direction, image);

							if (collection.length > 0) {
								borders.addElement(new StAssociation(new Integer(direction), collection));
							}
						}
					}
				}
			}
		}

		StAssociation[] answer = new StAssociation[borders.size()];
		borders.copyInto(answer);
		return answer;
	}

	/**
	 * Answer points of border following.
	 * 
	 * @return java.awt.Point[]
	 * @param point java.awt.Point
	 * @param ds int
	 * @param image jp.co.sra.smalltalk.StImage
	 * @category Tracing
	 */
	public static Point[] BorderFollowingPoint_direction_image_(Point point, int ds, StImage image) {
		int i;
		int iw;
		int is;
		int j;
		int jw;
		int js;
		int d;
		int n;
		int nb;
		int nc;
		int[] array1 = { 0, -1, -1, -1, 0, 1, 1, 1 };
		int[] array2 = { 1, 1, 0, -1, -1, -1, 0, 1 };
		int colorGrayValue = Color.gray.getRGB();
		int colorWhiteValue = Color.white.getRGB();
		boolean loop1;
		boolean loop2;
		Point p;
		Vector border = new Vector();
		i = point.x;
		iw = point.x;
		is = point.x;
		j = point.y;
		jw = point.y;
		js = point.y;
		d = ds;
		n = (d + 4) & 7;
		d = -1;
		nb = -1;
		nc = 0;
		nc = nc + (image.getPixel(i - 1, j - 1)) + 1;
		nc = nc + (image.getPixel(i - 1, j)) + 1;
		nc = nc + (image.getPixel(i - 1, j + 1)) + 1;
		nc = nc + (image.getPixel(i, j - 1)) + 1;
		nc = nc + (image.getPixel(i, j + 1)) + 1;
		nc = nc + (image.getPixel(i + 1, j - 1)) + 1;
		nc = nc + (image.getPixel(i + 1, j)) + 1;
		nc = nc + (image.getPixel(i + 1, j + 1)) + 1;

		if (nc < 0) {
			loop1 = true;
			while (loop1) {
				i = iw;
				j = jw;
				image.setPixel(iw, jw, colorGrayValue);
				p = new Point(iw - 1, jw - 1);
				border.addElement(p);
				n = (n + 4) & 7;
				loop2 = true;
				while (loop2) {
					n = (n + 1) & 7;
					iw = i + array1[n];
					jw = j + array2[n];
					loop2 = (image.getPixel(iw, jw) == colorWhiteValue);
				}
				if (d < 0) {
					if (nb < 0) {
						nb = n;
					} else {
						d = nb;
					}
				}
				loop1 = ((i != is) || (j != js) || (n != d));
			}
		} else {
			image.setPixel(i, j, colorGrayValue);
		}

		Point[] answer = new Point[border.size()];
		border.copyInto(answer);
		return answer;
	}

	/**
	 * Answer color histogram.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return java.util.Map.Entry[]
	 * @category Histogram
	 */
	public static Map.Entry[] ColorHistogram_(StImage anImage) {
		StImage image = null;
		if (JunImageProcessor.ColorPalette256().equals(anImage.image().getColorModel())) {
			image = anImage;
		} else {
			image = anImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.ColorPalette256());
		}

		HashMap aMap = new HashMap();
		for (int y = 0; y < image.height(); y++) {
			for (int x = 0; x < image.width(); x++) {
				Integer index = new Integer(image.getPixel(x, y) & 0x00FFFFFF);
				if (aMap.containsKey(index)) {
					aMap.put(index, new Integer((1 + ((Integer) aMap.get(index)).intValue())));
				} else {
					aMap.put(index, new Integer(1));
				}
			}
		}

		TreeMap aTreeMap = new TreeMap(new Comparator() {
			public int compare(Object arg0, Object arg1) {
				Color cx = (Color) arg0;
				Color cy = (Color) arg1;
				if (cx.equals(cy)) {
					return 0;
				} else {
					double dx = StColorValue._DistanceFrom(cx, Color.black);
					double dy = StColorValue._DistanceFrom(cy, Color.black);
					return (dx < dy) ? -1 : 1;
				}
			}
		});

		Iterator i = aMap.entrySet().iterator();
		while (i.hasNext()) {
			Map.Entry entry = (Map.Entry) i.next();
			Color color = new Color(((Integer) entry.getKey()).intValue());
			float value = ((Integer) entry.getValue()).floatValue() / (image.width() * image.height());
			aTreeMap.put(color, new Float(value));
		}

		return (Map.Entry[]) aTreeMap.entrySet().toArray(new Map.Entry[aTreeMap.size()]);
	}

	/**
	 * Answer the ColorModel for 256 colors.
	 * 
	 * @return java.awt.image.IndexColorModel
	 * @category Constants of palette
	 */
	public static final IndexColorModel ColorPalette256() {
		if (ColorPalette256 == null) {
			Color[] colors = new Color[256];
			colors[0] = new Color(0, 0, 0);
			colors[1] = new Color(16, 16, 16);
			colors[2] = new Color(33, 33, 33);
			colors[3] = new Color(67, 67, 67);
			colors[4] = new Color(84, 84, 84);
			colors[5] = new Color(118, 118, 118);
			colors[6] = new Color(136, 136, 136);
			colors[7] = new Color(170, 170, 170);
			colors[8] = new Color(187, 187, 187);
			colors[9] = new Color(221, 221, 221);
			colors[10] = new Color(238, 238, 238);
			colors[11] = new Color(0, 0, 16);
			colors[12] = new Color(0, 0, 33);
			colors[13] = new Color(0, 0, 67);
			colors[14] = new Color(0, 0, 84);
			colors[15] = new Color(0, 0, 118);
			colors[16] = new Color(0, 0, 136);
			colors[17] = new Color(0, 0, 170);
			colors[18] = new Color(0, 0, 187);
			colors[19] = new Color(0, 0, 221);
			colors[20] = new Color(0, 0, 238);
			colors[21] = new Color(0, 16, 0);
			colors[22] = new Color(0, 33, 0);
			colors[23] = new Color(0, 67, 0);
			colors[24] = new Color(0, 84, 0);
			colors[25] = new Color(0, 118, 0);
			colors[26] = new Color(0, 136, 0);
			colors[27] = new Color(0, 170, 0);
			colors[28] = new Color(0, 187, 0);
			colors[29] = new Color(0, 221, 0);
			colors[30] = new Color(0, 238, 0);
			colors[31] = new Color(16, 0, 0);
			colors[32] = new Color(33, 0, 0);
			colors[33] = new Color(67, 0, 0);
			colors[34] = new Color(84, 0, 0);
			colors[35] = new Color(118, 0, 0);
			colors[36] = new Color(136, 0, 0);
			colors[37] = new Color(170, 0, 0);
			colors[38] = new Color(187, 0, 0);
			colors[39] = new Color(221, 0, 0);
			colors[40] = new Color(238, 0, 0);
			colors[41] = new Color(0, 0, 50);
			colors[42] = new Color(0, 0, 101);
			colors[43] = new Color(0, 0, 153);
			colors[44] = new Color(0, 0, 204);
			colors[45] = new Color(0, 0, 255);
			colors[46] = new Color(0, 50, 0);
			colors[47] = new Color(0, 50, 50);
			colors[48] = new Color(0, 50, 101);
			colors[49] = new Color(0, 50, 153);
			colors[50] = new Color(0, 50, 204);
			colors[51] = new Color(0, 50, 255);
			colors[52] = new Color(0, 101, 0);
			colors[53] = new Color(0, 101, 50);
			colors[54] = new Color(0, 101, 101);
			colors[55] = new Color(0, 101, 153);
			colors[56] = new Color(0, 101, 204);
			colors[57] = new Color(0, 101, 255);
			colors[58] = new Color(0, 153, 0);
			colors[59] = new Color(0, 153, 50);
			colors[60] = new Color(0, 153, 101);
			colors[61] = new Color(0, 153, 153);
			colors[62] = new Color(0, 153, 204);
			colors[63] = new Color(0, 153, 255);
			colors[64] = new Color(0, 204, 0);
			colors[65] = new Color(0, 204, 50);
			colors[66] = new Color(0, 204, 101);
			colors[67] = new Color(0, 204, 153);
			colors[68] = new Color(0, 204, 204);
			colors[69] = new Color(0, 204, 255);
			colors[70] = new Color(0, 255, 0);
			colors[71] = new Color(0, 255, 50);
			colors[72] = new Color(0, 255, 101);
			colors[73] = new Color(0, 255, 153);
			colors[74] = new Color(0, 255, 204);
			colors[75] = new Color(0, 255, 255);
			colors[76] = new Color(50, 0, 0);
			colors[77] = new Color(50, 0, 50);
			colors[78] = new Color(50, 0, 101);
			colors[79] = new Color(50, 0, 153);
			colors[80] = new Color(50, 0, 204);
			colors[81] = new Color(50, 0, 255);
			colors[82] = new Color(50, 50, 0);
			colors[83] = new Color(50, 50, 50);
			colors[84] = new Color(50, 50, 101);
			colors[85] = new Color(50, 50, 153);
			colors[86] = new Color(50, 50, 204);
			colors[87] = new Color(50, 50, 255);
			colors[88] = new Color(50, 101, 0);
			colors[89] = new Color(50, 101, 50);
			colors[90] = new Color(50, 101, 101);
			colors[91] = new Color(50, 101, 153);
			colors[92] = new Color(50, 101, 204);
			colors[93] = new Color(50, 101, 255);
			colors[94] = new Color(50, 153, 0);
			colors[95] = new Color(50, 153, 50);
			colors[96] = new Color(50, 153, 101);
			colors[97] = new Color(50, 153, 153);
			colors[98] = new Color(50, 153, 204);
			colors[99] = new Color(50, 153, 255);
			colors[100] = new Color(50, 204, 0);
			colors[101] = new Color(50, 204, 50);
			colors[102] = new Color(50, 204, 101);
			colors[103] = new Color(50, 204, 153);
			colors[104] = new Color(50, 204, 204);
			colors[105] = new Color(50, 204, 255);
			colors[106] = new Color(50, 255, 0);
			colors[107] = new Color(50, 255, 50);
			colors[108] = new Color(50, 255, 101);
			colors[109] = new Color(50, 255, 153);
			colors[110] = new Color(50, 255, 204);
			colors[111] = new Color(50, 255, 255);
			colors[112] = new Color(101, 0, 0);
			colors[113] = new Color(101, 0, 50);
			colors[114] = new Color(101, 0, 101);
			colors[115] = new Color(101, 0, 153);
			colors[116] = new Color(101, 0, 204);
			colors[117] = new Color(101, 0, 255);
			colors[118] = new Color(101, 50, 0);
			colors[119] = new Color(101, 50, 50);
			colors[120] = new Color(101, 50, 101);
			colors[121] = new Color(101, 50, 153);
			colors[122] = new Color(101, 50, 204);
			colors[123] = new Color(101, 50, 255);
			colors[124] = new Color(101, 101, 0);
			colors[125] = new Color(101, 101, 50);
			colors[126] = new Color(101, 101, 101);
			colors[127] = new Color(101, 101, 153);
			colors[128] = new Color(101, 101, 204);
			colors[129] = new Color(101, 101, 255);
			colors[130] = new Color(101, 153, 0);
			colors[131] = new Color(101, 153, 50);
			colors[132] = new Color(101, 153, 101);
			colors[133] = new Color(101, 153, 153);
			colors[134] = new Color(101, 153, 204);
			colors[135] = new Color(101, 153, 255);
			colors[136] = new Color(101, 204, 0);
			colors[137] = new Color(101, 204, 50);
			colors[138] = new Color(101, 204, 101);
			colors[139] = new Color(101, 204, 153);
			colors[140] = new Color(101, 204, 204);
			colors[141] = new Color(101, 204, 255);
			colors[142] = new Color(101, 255, 0);
			colors[143] = new Color(101, 255, 50);
			colors[144] = new Color(101, 255, 101);
			colors[145] = new Color(101, 255, 153);
			colors[146] = new Color(101, 255, 204);
			colors[147] = new Color(101, 255, 255);
			colors[148] = new Color(153, 0, 0);
			colors[149] = new Color(153, 0, 50);
			colors[150] = new Color(153, 0, 101);
			colors[151] = new Color(153, 0, 153);
			colors[152] = new Color(153, 0, 204);
			colors[153] = new Color(153, 0, 255);
			colors[154] = new Color(153, 50, 0);
			colors[155] = new Color(153, 50, 50);
			colors[156] = new Color(153, 50, 101);
			colors[157] = new Color(153, 50, 153);
			colors[158] = new Color(153, 50, 204);
			colors[159] = new Color(153, 50, 255);
			colors[160] = new Color(153, 101, 0);
			colors[161] = new Color(153, 101, 50);
			colors[162] = new Color(153, 101, 101);
			colors[163] = new Color(153, 101, 153);
			colors[164] = new Color(153, 101, 204);
			colors[165] = new Color(153, 101, 255);
			colors[166] = new Color(153, 153, 0);
			colors[167] = new Color(153, 153, 50);
			colors[168] = new Color(153, 153, 101);
			colors[169] = new Color(153, 153, 153);
			colors[170] = new Color(153, 153, 204);
			colors[171] = new Color(153, 153, 255);
			colors[172] = new Color(153, 204, 0);
			colors[173] = new Color(153, 204, 50);
			colors[174] = new Color(153, 204, 101);
			colors[175] = new Color(153, 204, 153);
			colors[176] = new Color(153, 204, 204);
			colors[177] = new Color(153, 204, 255);
			colors[178] = new Color(153, 255, 0);
			colors[179] = new Color(153, 255, 50);
			colors[180] = new Color(153, 255, 101);
			colors[181] = new Color(153, 255, 153);
			colors[182] = new Color(153, 255, 204);
			colors[183] = new Color(153, 255, 255);
			colors[184] = new Color(204, 0, 0);
			colors[185] = new Color(204, 0, 50);
			colors[186] = new Color(204, 0, 101);
			colors[187] = new Color(204, 0, 153);
			colors[188] = new Color(204, 0, 204);
			colors[189] = new Color(204, 0, 255);
			colors[190] = new Color(204, 50, 0);
			colors[191] = new Color(204, 50, 50);
			colors[192] = new Color(204, 50, 101);
			colors[193] = new Color(204, 50, 153);
			colors[194] = new Color(204, 50, 204);
			colors[195] = new Color(204, 50, 255);
			colors[196] = new Color(204, 101, 0);
			colors[197] = new Color(204, 101, 50);
			colors[198] = new Color(204, 101, 101);
			colors[199] = new Color(204, 101, 153);
			colors[200] = new Color(204, 101, 204);
			colors[201] = new Color(204, 101, 255);
			colors[202] = new Color(204, 153, 0);
			colors[203] = new Color(204, 153, 50);
			colors[204] = new Color(204, 153, 101);
			colors[205] = new Color(204, 153, 153);
			colors[206] = new Color(204, 153, 204);
			colors[207] = new Color(204, 153, 255);
			colors[208] = new Color(204, 204, 0);
			colors[209] = new Color(204, 204, 50);
			colors[210] = new Color(204, 204, 101);
			colors[211] = new Color(204, 204, 153);
			colors[212] = new Color(204, 204, 204);
			colors[213] = new Color(204, 204, 255);
			colors[214] = new Color(204, 255, 0);
			colors[215] = new Color(204, 255, 50);
			colors[216] = new Color(204, 255, 101);
			colors[217] = new Color(204, 255, 153);
			colors[218] = new Color(204, 255, 204);
			colors[219] = new Color(204, 255, 255);
			colors[220] = new Color(255, 0, 0);
			colors[221] = new Color(255, 0, 50);
			colors[222] = new Color(255, 0, 101);
			colors[223] = new Color(255, 0, 153);
			colors[224] = new Color(255, 0, 204);
			colors[225] = new Color(255, 0, 255);
			colors[226] = new Color(255, 50, 0);
			colors[227] = new Color(255, 50, 50);
			colors[228] = new Color(255, 50, 101);
			colors[229] = new Color(255, 50, 153);
			colors[230] = new Color(255, 50, 204);
			colors[231] = new Color(255, 50, 255);
			colors[232] = new Color(255, 101, 0);
			colors[233] = new Color(255, 101, 50);
			colors[234] = new Color(255, 101, 101);
			colors[235] = new Color(255, 101, 153);
			colors[236] = new Color(255, 101, 204);
			colors[237] = new Color(255, 101, 255);
			colors[238] = new Color(255, 153, 0);
			colors[239] = new Color(255, 153, 50);
			colors[240] = new Color(255, 153, 101);
			colors[241] = new Color(255, 153, 153);
			colors[242] = new Color(255, 153, 204);
			colors[243] = new Color(255, 153, 255);
			colors[244] = new Color(255, 204, 0);
			colors[245] = new Color(255, 204, 50);
			colors[246] = new Color(255, 204, 101);
			colors[247] = new Color(255, 204, 153);
			colors[248] = new Color(255, 204, 204);
			colors[249] = new Color(255, 204, 255);
			colors[250] = new Color(255, 255, 0);
			colors[251] = new Color(255, 255, 50);
			colors[252] = new Color(255, 255, 101);
			colors[253] = new Color(255, 255, 153);
			colors[254] = new Color(255, 255, 204);
			colors[255] = new Color(255, 255, 255);

			byte[] rPalette = new byte[256];
			byte[] gPalette = new byte[256];
			byte[] bPalette = new byte[256];
			for (int index = 0; index < 256; index++) {
				rPalette[index] = (byte) colors[index].getRed();
				gPalette[index] = (byte) colors[index].getGreen();
				bPalette[index] = (byte) colors[index].getBlue();
			}
			ColorPalette256 = new IndexColorModel(8, 256, rPalette, gPalette, bPalette);
		}

		return ColorPalette256;
	}

	/**
	 * Answer color palette image for 256 colors.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param cellSize java.awt.Image
	 * @category Constants of palette
	 */
	public static StImage ColorPalette256Image_(Point cellSize) {
		Image cellImage;
		StImage anImage = new StImage(cellSize.x * 32, cellSize.y * 8);
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		IndexColorModel colorModel = ColorPalette256();
		int index = 0;
		int width = cellSize.x;
		int height = cellSize.y;
		int offset = 0;
		int scansize = width;

		for (int y = 0; y < 8; y++) {
			for (int x = 0; x < 32; x++) {
				int[] pixels = new int[width * height];
				for (int i = 0; i < pixels.length; i++) {
					pixels[i] = index;
				}
				MemoryImageSource source = new MemoryImageSource(width, height, colorModel, pixels, offset, scansize);
				cellImage = toolkit.createImage(source);
				anImage.copy_from_in_rule_(new Rectangle(x * width, y * height, width, height), new Point(0, 0), new StImage(cellImage), StImage.Over);
				cellImage.flush();
				index = index + 1;
			}
		}

		return anImage;
	}

	/**
	 * Answer fill image with black.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category Filling
	 */
	public static StImage Fill_(StImage anImage) {
		return Fill_rectangle_color_(anImage, anImage.bounds(), Color.black);
	}

	/**
	 * Answer fill image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param colorValue java.awt.Color
	 * @category Filling
	 */
	public static StImage Fill_color_(StImage anImage, Color colorValue) {
		return Fill_rectangle_color_(anImage, anImage.bounds(), colorValue);
	}

	/**
	 * Answer fill image at area with black.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aRectangle java.awt.Rectangle
	 * @category Filling
	 */
	public static StImage Fill_rectangle_(StImage anImage, Rectangle aRectangle) {
		return Fill_rectangle_color_(anImage, aRectangle, Color.black);
	}

	/**
	 * Answer fill image at area.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aRectangle java.awt.Rectangle
	 * @param colorValue java.awt.Color
	 * @category Filling
	 */
	public static StImage Fill_rectangle_color_(StImage anImage, Rectangle aRectangle, Color colorValue) {
		StImage pattern = new StImage(16, 16);
		int value = colorValue.getRGB();

		for (int x = 0; x < pattern.width(); x++) {
			for (int y = 0; y < pattern.height(); y++) {
				pattern.setPixel(x, y, value);
			}
		}

		return anImage.tile_from_in_rule_(aRectangle, new Point(0, 0), pattern, StImage.Over);
	}

	/**
	 * Answer fill image at point with black.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aPoint java.awt.Point
	 * @category Filling
	 */
	public static StImage Fill_seed_(StImage anImage, Point aPoint) {
		return Fill_seed_color_(anImage, aPoint, Color.black);
	}

	/**
	 * Answer fill image at point.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aPoint java.awt.Point
	 * @param colorValue java.awt.Color
	 * @category Filling
	 */
	public static StImage Fill_seed_color_(StImage anImage, Point aPoint, Color colorValue) {
		int x0;
		int x1;
		int y;
		int direction;
		int xLimit;
		int d;
		int xStart;
		int xEnd;
		int colorIndex = colorValue.getRGB();

		if (colorIndex == anImage.getPixel(aPoint.x, aPoint.y)) {
			return anImage;
		}

		int whiteIndex = Color.white.getRGB();
		int width = anImage.width();
		int height = anImage.height();
		Vector x0Stack = new Vector();
		x0Stack.addElement(new Integer(LastOn_before_after_index_(anImage, aPoint, -1, whiteIndex) + 1));
		Vector x1Stack = new Vector();
		x1Stack.addElement(new Integer(FirstOn_after_before_index_(anImage, aPoint, width, whiteIndex) - 1));
		Vector yStack = new Vector();
		yStack.addElement(new Integer(aPoint.y));
		Vector directionStack = new Vector();
		directionStack.addElement(new Integer(0));

		while (yStack.size() > 0) {
			x0 = ((Integer) x0Stack.lastElement()).intValue();
			x0Stack.removeElementAt(x0Stack.size() - 1);
			x1 = ((Integer) x1Stack.lastElement()).intValue();
			x1Stack.removeElementAt(x1Stack.size() - 1);
			y = ((Integer) yStack.lastElement()).intValue();
			yStack.removeElementAt(yStack.size() - 1);
			direction = ((Integer) directionStack.lastElement()).intValue();
			directionStack.removeElementAt(directionStack.size() - 1);
			xLimit = Math.min(x1, width - 1);

			Point point = new Point(x0, y);
			while (point.x <= xLimit) {
				anImage.setPixel(point.x, point.y, colorIndex);
				point = new Point(point.x + 1, point.y);
			}

			if ((direction != 1) && (y > 0)) {
				if (whiteIndex == anImage.getPixel(x0, y - 1)) {
					xStart = LastOn_before_after_index_(anImage, new Point(x0, y - 1), -1, whiteIndex) + 1;
				} else {
					xStart = FirstOff_after_before_index_(anImage, new Point(x0, y - 1), x1 + 1, whiteIndex);
				}
				while (xStart <= x1) {
					xEnd = FirstOn_after_before_index_(anImage, new Point(xStart, y - 1), width, whiteIndex) - 1;
					x0Stack.addElement(new Integer(xStart));
					x1Stack.addElement(new Integer(xEnd));
					yStack.addElement(new Integer(y - 1));
					if ((x0 - 1 > xStart) || (x1 + 1 < xEnd)) {
						d = 0;
					} else {
						d = 2;
					}
					directionStack.addElement(new Integer(d));
					if (xEnd >= x1) {
						xStart = xEnd + 1;
					} else {
						xStart = FirstOff_after_before_index_(anImage, new Point(xEnd + 1, y - 1), x1 + 1, whiteIndex);
					}
				}
			}

			if ((direction != 2) && (y < height - 1)) {
				if (whiteIndex == anImage.getPixel(x0, y + 1)) {
					xStart = LastOn_before_after_index_(anImage, new Point(x0, y + 1), -1, whiteIndex) + 1;
				} else {
					xStart = FirstOff_after_before_index_(anImage, new Point(x0, y + 1), x1 + 1, whiteIndex);
				}
				while (xStart <= x1) {
					xEnd = FirstOn_after_before_index_(anImage, new Point(xStart, y + 1), width, whiteIndex) - 1;
					x0Stack.addElement(new Integer(xStart));
					x1Stack.addElement(new Integer(xEnd));
					yStack.addElement(new Integer(y + 1));
					if ((x0 - 1 > xStart) || (x1 + 1 < xEnd)) {
						d = 0;
					} else {
						d = 1;
					}
					directionStack.addElement(new Integer(d));
					if (xEnd > x1) {
						xStart = xEnd;
					} else {
						xStart = FirstOff_after_before_index_(anImage, new Point(xEnd + 1, y + 1), x1 + 1, whiteIndex);
					}
				}
			}
		}

		return anImage;
	}

	/**
	 * Answer gray scale color histogram.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return java.util.Map.Entry[]
	 * @category Histogram
	 */
	public static Map.Entry[] GrayHistogram_(StImage anImage) {
		StImage image = null;
		if (JunImageProcessor.GrayPalette256().equals(anImage.image().getColorModel())) {
			image = anImage;
		} else {
			image = anImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.GrayPalette256());
		}

		HashMap aMap = new HashMap();
		for (int y = 0; y < image.height(); y++) {
			for (int x = 0; x < image.width(); x++) {
				Integer index = new Integer(image.getPixel(x, y) & 0x00FFFFFF);
				if (aMap.containsKey(index)) {
					aMap.put(index, new Integer((1 + ((Integer) aMap.get(index)).intValue())));
				} else {
					aMap.put(index, new Integer(1));
				}
			}
		}

		TreeMap aTreeMap = new TreeMap(new Comparator() {
			public int compare(Object arg0, Object arg1) {
				Color cx = (Color) arg0;
				Color cy = (Color) arg1;
				if (cx.equals(cy)) {
					return 0;
				} else {
					double dx = StColorValue._DistanceFrom(cx, Color.black);
					double dy = StColorValue._DistanceFrom(cy, Color.black);
					return (dx < dy) ? -1 : 1;
				}
			}
		});

		Iterator i = aMap.entrySet().iterator();
		while (i.hasNext()) {
			Map.Entry entry = (Map.Entry) i.next();
			Color color = new Color(((Integer) entry.getKey()).intValue());
			float value = ((Integer) entry.getValue()).floatValue() / (image.width() * image.height());
			aTreeMap.put(color, new Float(value));
		}

		return (Map.Entry[]) aTreeMap.entrySet().toArray(new Map.Entry[aTreeMap.size()]);
	}

	/**
	 * Answer the ColorModel for gray 256 colors.
	 * 
	 * @return java.awt.image.IndexColorModel
	 * @category Constants of palette
	 */
	public static final IndexColorModel GrayPalette256() {
		if (GrayPalette256 == null) {
			Color[] colors = new Color[256];
			colors[0] = new Color(0, 0, 0);
			colors[1] = new Color(0, 0, 0);
			colors[2] = new Color(1, 1, 1);
			colors[3] = new Color(2, 2, 2);
			colors[4] = new Color(3, 3, 3);
			colors[5] = new Color(5, 5, 5);
			colors[6] = new Color(6, 6, 6);
			colors[7] = new Color(7, 7, 7);
			colors[8] = new Color(8, 8, 8);
			colors[9] = new Color(8, 8, 8);
			colors[10] = new Color(9, 9, 9);
			colors[11] = new Color(10, 10, 10);
			colors[12] = new Color(11, 11, 11);
			colors[13] = new Color(13, 13, 13);
			colors[14] = new Color(14, 14, 14);
			colors[15] = new Color(15, 15, 15);
			colors[16] = new Color(16, 16, 16);
			colors[17] = new Color(16, 16, 16);
			colors[18] = new Color(17, 17, 17);
			colors[19] = new Color(18, 18, 18);
			colors[20] = new Color(19, 19, 19);
			colors[21] = new Color(21, 21, 21);
			colors[22] = new Color(22, 22, 22);
			colors[23] = new Color(23, 23, 23);
			colors[24] = new Color(24, 24, 24);
			colors[25] = new Color(24, 24, 24);
			colors[26] = new Color(25, 25, 25);
			colors[27] = new Color(26, 26, 26);
			colors[28] = new Color(27, 27, 27);
			colors[29] = new Color(29, 29, 29);
			colors[30] = new Color(30, 30, 30);
			colors[31] = new Color(31, 31, 31);
			colors[32] = new Color(32, 32, 32);
			colors[33] = new Color(32, 32, 32);
			colors[34] = new Color(33, 33, 33);
			colors[35] = new Color(34, 34, 34);
			colors[36] = new Color(35, 35, 35);
			colors[37] = new Color(36, 36, 36);
			colors[38] = new Color(38, 38, 38);
			colors[39] = new Color(39, 39, 39);
			colors[40] = new Color(40, 40, 40);
			colors[41] = new Color(41, 41, 41);
			colors[42] = new Color(41, 41, 41);
			colors[43] = new Color(42, 42, 42);
			colors[44] = new Color(43, 43, 43);
			colors[45] = new Color(44, 44, 44);
			colors[46] = new Color(46, 46, 46);
			colors[47] = new Color(47, 47, 47);
			colors[48] = new Color(48, 48, 48);
			colors[49] = new Color(49, 49, 49);
			colors[50] = new Color(49, 49, 49);
			colors[51] = new Color(50, 50, 50);
			colors[52] = new Color(51, 51, 51);
			colors[53] = new Color(52, 52, 52);
			colors[54] = new Color(54, 54, 54);
			colors[55] = new Color(55, 55, 55);
			colors[56] = new Color(56, 56, 56);
			colors[57] = new Color(57, 57, 57);
			colors[58] = new Color(57, 57, 57);
			colors[59] = new Color(58, 58, 58);
			colors[60] = new Color(59, 59, 59);
			colors[61] = new Color(60, 60, 60);
			colors[62] = new Color(62, 62, 62);
			colors[63] = new Color(63, 63, 63);
			colors[64] = new Color(64, 64, 64);
			colors[65] = new Color(65, 65, 65);
			colors[66] = new Color(65, 65, 65);
			colors[67] = new Color(66, 66, 66);
			colors[68] = new Color(67, 67, 67);
			colors[69] = new Color(68, 68, 68);
			colors[70] = new Color(70, 70, 70);
			colors[71] = new Color(71, 71, 71);
			colors[72] = new Color(72, 72, 72);
			colors[73] = new Color(73, 73, 73);
			colors[74] = new Color(74, 74, 74);
			colors[75] = new Color(74, 74, 74);
			colors[76] = new Color(75, 75, 75);
			colors[77] = new Color(76, 76, 76);
			colors[78] = new Color(77, 77, 77);
			colors[79] = new Color(79, 79, 79);
			colors[80] = new Color(80, 80, 80);
			colors[81] = new Color(81, 81, 81);
			colors[82] = new Color(82, 82, 82);
			colors[83] = new Color(82, 82, 82);
			colors[84] = new Color(83, 83, 83);
			colors[85] = new Color(84, 84, 84);
			colors[86] = new Color(85, 85, 85);
			colors[87] = new Color(87, 87, 87);
			colors[88] = new Color(88, 88, 88);
			colors[89] = new Color(89, 89, 89);
			colors[90] = new Color(90, 90, 90);
			colors[91] = new Color(90, 90, 90);
			colors[92] = new Color(91, 91, 91);
			colors[93] = new Color(92, 92, 92);
			colors[94] = new Color(93, 93, 93);
			colors[95] = new Color(95, 95, 95);
			colors[96] = new Color(96, 96, 96);
			colors[97] = new Color(97, 97, 97);
			colors[98] = new Color(98, 98, 98);
			colors[99] = new Color(98, 98, 98);
			colors[100] = new Color(99, 99, 99);
			colors[101] = new Color(100, 100, 100);
			colors[102] = new Color(101, 101, 101);
			colors[103] = new Color(103, 103, 103);
			colors[104] = new Color(104, 104, 104);
			colors[105] = new Color(105, 105, 105);
			colors[106] = new Color(106, 106, 106);
			colors[107] = new Color(106, 106, 106);
			colors[108] = new Color(107, 107, 107);
			colors[109] = new Color(108, 108, 108);
			colors[110] = new Color(109, 109, 109);
			colors[111] = new Color(110, 110, 110);
			colors[112] = new Color(112, 112, 112);
			colors[113] = new Color(113, 113, 113);
			colors[114] = new Color(114, 114, 114);
			colors[115] = new Color(115, 115, 115);
			colors[116] = new Color(115, 115, 115);
			colors[117] = new Color(116, 116, 116);
			colors[118] = new Color(117, 117, 117);
			colors[119] = new Color(118, 118, 118);
			colors[120] = new Color(120, 120, 120);
			colors[121] = new Color(121, 121, 121);
			colors[122] = new Color(122, 122, 122);
			colors[123] = new Color(123, 123, 123);
			colors[124] = new Color(123, 123, 123);
			colors[125] = new Color(124, 124, 124);
			colors[126] = new Color(125, 125, 125);
			colors[127] = new Color(126, 126, 126);
			colors[128] = new Color(128, 128, 128);
			colors[129] = new Color(129, 129, 129);
			colors[130] = new Color(130, 130, 130);
			colors[131] = new Color(131, 131, 131);
			colors[132] = new Color(131, 131, 131);
			colors[133] = new Color(132, 132, 132);
			colors[134] = new Color(133, 133, 133);
			colors[135] = new Color(134, 134, 134);
			colors[136] = new Color(136, 136, 136);
			colors[137] = new Color(137, 137, 137);
			colors[138] = new Color(138, 138, 138);
			colors[139] = new Color(139, 139, 139);
			colors[140] = new Color(139, 139, 139);
			colors[141] = new Color(140, 140, 140);
			colors[142] = new Color(141, 141, 141);
			colors[143] = new Color(142, 142, 142);
			colors[144] = new Color(144, 144, 144);
			colors[145] = new Color(145, 145, 145);
			colors[146] = new Color(146, 146, 146);
			colors[147] = new Color(147, 147, 147);
			colors[148] = new Color(148, 148, 148);
			colors[149] = new Color(148, 148, 148);
			colors[150] = new Color(149, 149, 149);
			colors[151] = new Color(150, 150, 150);
			colors[152] = new Color(151, 151, 151);
			colors[153] = new Color(153, 153, 153);
			colors[154] = new Color(154, 154, 154);
			colors[155] = new Color(155, 155, 155);
			colors[156] = new Color(156, 156, 156);
			colors[157] = new Color(156, 156, 156);
			colors[158] = new Color(157, 157, 157);
			colors[159] = new Color(158, 158, 158);
			colors[160] = new Color(159, 159, 159);
			colors[161] = new Color(161, 161, 161);
			colors[162] = new Color(162, 162, 162);
			colors[163] = new Color(163, 163, 163);
			colors[164] = new Color(164, 164, 164);
			colors[165] = new Color(164, 164, 164);
			colors[166] = new Color(165, 165, 165);
			colors[167] = new Color(166, 166, 166);
			colors[168] = new Color(167, 167, 167);
			colors[169] = new Color(169, 169, 169);
			colors[170] = new Color(170, 170, 170);
			colors[171] = new Color(171, 171, 171);
			colors[172] = new Color(172, 172, 172);
			colors[173] = new Color(172, 172, 172);
			colors[174] = new Color(173, 173, 173);
			colors[175] = new Color(174, 174, 174);
			colors[176] = new Color(175, 175, 175);
			colors[177] = new Color(177, 177, 177);
			colors[178] = new Color(178, 178, 178);
			colors[179] = new Color(179, 179, 179);
			colors[180] = new Color(180, 180, 180);
			colors[181] = new Color(180, 180, 180);
			colors[182] = new Color(181, 181, 181);
			colors[183] = new Color(182, 182, 182);
			colors[184] = new Color(183, 183, 183);
			colors[185] = new Color(184, 184, 184);
			colors[186] = new Color(186, 186, 186);
			colors[187] = new Color(187, 187, 187);
			colors[188] = new Color(188, 188, 188);
			colors[189] = new Color(189, 189, 189);
			colors[190] = new Color(189, 189, 189);
			colors[191] = new Color(190, 190, 190);
			colors[192] = new Color(191, 191, 191);
			colors[193] = new Color(192, 192, 192);
			colors[194] = new Color(194, 194, 194);
			colors[195] = new Color(195, 195, 195);
			colors[196] = new Color(196, 196, 196);
			colors[197] = new Color(197, 197, 197);
			colors[198] = new Color(197, 197, 197);
			colors[199] = new Color(198, 198, 198);
			colors[200] = new Color(199, 199, 199);
			colors[201] = new Color(200, 200, 200);
			colors[202] = new Color(202, 202, 202);
			colors[203] = new Color(203, 203, 203);
			colors[204] = new Color(204, 204, 204);
			colors[205] = new Color(205, 205, 205);
			colors[206] = new Color(205, 205, 205);
			colors[207] = new Color(206, 206, 206);
			colors[208] = new Color(207, 207, 207);
			colors[209] = new Color(208, 208, 208);
			colors[210] = new Color(210, 210, 210);
			colors[211] = new Color(211, 211, 211);
			colors[212] = new Color(212, 212, 212);
			colors[213] = new Color(213, 213, 213);
			colors[214] = new Color(213, 213, 213);
			colors[215] = new Color(214, 214, 214);
			colors[216] = new Color(215, 215, 215);
			colors[217] = new Color(216, 216, 216);
			colors[218] = new Color(218, 218, 218);
			colors[219] = new Color(219, 219, 219);
			colors[220] = new Color(220, 220, 220);
			colors[221] = new Color(221, 221, 221);
			colors[222] = new Color(222, 222, 222);
			colors[223] = new Color(222, 222, 222);
			colors[224] = new Color(223, 223, 223);
			colors[225] = new Color(224, 224, 224);
			colors[226] = new Color(225, 225, 225);
			colors[227] = new Color(227, 227, 227);
			colors[228] = new Color(228, 228, 228);
			colors[229] = new Color(229, 229, 229);
			colors[230] = new Color(230, 230, 230);
			colors[231] = new Color(230, 230, 230);
			colors[232] = new Color(231, 231, 231);
			colors[233] = new Color(232, 232, 232);
			colors[234] = new Color(233, 233, 233);
			colors[235] = new Color(235, 235, 235);
			colors[236] = new Color(236, 236, 236);
			colors[237] = new Color(237, 237, 237);
			colors[238] = new Color(238, 238, 238);
			colors[239] = new Color(238, 238, 238);
			colors[240] = new Color(239, 239, 239);
			colors[241] = new Color(240, 240, 240);
			colors[242] = new Color(241, 241, 241);
			colors[243] = new Color(243, 243, 243);
			colors[244] = new Color(244, 244, 244);
			colors[245] = new Color(245, 245, 245);
			colors[246] = new Color(246, 246, 246);
			colors[247] = new Color(246, 246, 246);
			colors[248] = new Color(247, 247, 247);
			colors[249] = new Color(248, 248, 248);
			colors[250] = new Color(249, 249, 249);
			colors[251] = new Color(251, 251, 251);
			colors[252] = new Color(252, 252, 252);
			colors[253] = new Color(253, 253, 253);
			colors[254] = new Color(254, 254, 254);
			colors[255] = new Color(255, 255, 255);

			byte[] rPalette = new byte[256];
			byte[] gPalette = new byte[256];
			byte[] bPalette = new byte[256];
			for (int index = 0; index < 256; index++) {
				rPalette[index] = (byte) colors[index].getRed();
				gPalette[index] = (byte) colors[index].getGreen();
				bPalette[index] = (byte) colors[index].getBlue();
			}
			GrayPalette256 = new IndexColorModel(8, 256, rPalette, gPalette, bPalette);
		}

		return GrayPalette256;
	}

	/**
	 * Answer gray palette image for 256 colors.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param cellSize java.awt.Point
	 * @category Constants of palette
	 */
	public static StImage GrayPalette256Image_(Point cellSize) {
		Image cellImage;
		StImage anImage = new StImage(cellSize.x * 32, cellSize.y * 8);
		Toolkit toolkit = Toolkit.getDefaultToolkit();
		IndexColorModel colorModel = GrayPalette256();
		int index = 0;
		int width = cellSize.x;
		int height = cellSize.y;
		int offset = 0;
		int scansize = width;

		for (int y = 0; y < 8; y++) {
			for (int x = 0; x < 32; x++) {
				int[] pixels = new int[width * height];
				for (int i = 0; i < pixels.length; i++) {
					pixels[i] = index;
				}
				MemoryImageSource source = new MemoryImageSource(width, height, colorModel, pixels, offset, scansize);
				cellImage = toolkit.createImage(source);
				anImage.copy_from_in_rule_(new Rectangle(x * width, y * height, width, height), new Point(0, 0), new StImage(cellImage), StImage.Over);
				cellImage.flush();
				index = index + 1;
			}
		}

		return anImage;
	}

	/**
	 * Answer halftone image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param halftoneScale double
	 * @category Halftone
	 */
	public static StImage Halftone_(double halftoneScale) {
		double scale = halftoneScale;
		scale = Math.max(scale, 0);
		scale = Math.min(scale, 1);
		int index = new Double((Masks().length) * scale).intValue() + 1;
		return MaskAt_(index);
	}

	/**
	 * Answer icon image with area.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param sizeInteger int
	 * @category Scaling
	 */
	public static StImage Icon_size_(StImage anImage, int sizeInteger) {
		double factor = (double) sizeInteger / Math.max(anImage.width(), anImage.height());
		StImage image = Scale_factor_(anImage, new Jun2dPoint(factor, factor));
		int maxSize = Math.max(image.width(), image.height());
		Point extent = new Point(maxSize, maxSize);
		Rectangle area = image.bounds();
		area.translate((int) ((extent.x / 2.0d) - (image.bounds().width / 2.0d)), (int) ((extent.y / 2.0d) - (image.bounds().height / 2.0d)));
		int[] bits = new int[maxSize * maxSize];
		for (int i = 0; i < (maxSize * maxSize); i++) {
			bits[i] = 0x00FFFFFF;
		}
		StImage figure = new StImage(extent.x, extent.y, (int[]) bits.clone());
		figure.copy_from_in_rule_(area, new Point(0, 0), image, StImage.Over);
		StImage shape = new StImage(extent.x, extent.y, (int[]) bits.clone());
		shape = Fill_rectangle_color_(shape, area, Color.black);

		return _MakeImage_Shape_(figure, shape);
	}

	/**
	 * Answer halftone image.
	 *
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param halftoneScale double
	 * @category Halftone
	 */
	public static StImage Image_halftone_(StImage anImage, double halftoneScale) {
		/*
		 Smalltalk version.
		 
		 StImage halftone = Mask_halftone_(anImage.extent(), halftoneScale);
		 StImage image = _CopyMaskdArea_fromImage_sourceOffset_destinationOffset_(halftone, anImage, new Point(5, 5), new Point(0, 0));
		 return image;
		 */

		int width = anImage.width();
		int height = anImage.height();
		StImage halftoneImage = new StImage(new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB));
		Graphics2D aGraphics = (Graphics2D) halftoneImage.image().getGraphics();
		try {
			aGraphics.setColor(Color.white);
			aGraphics.fillRect(0, 0, width, height);
			aGraphics.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, (float) halftoneScale));
			aGraphics.drawImage(anImage.image(), 0, 0, null);
		} finally {
			aGraphics.dispose();
		}
		return halftoneImage;
	}

	/**
	 * receives BMP, GIF, JPEG or PNG filename (full path), and return image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param file java.io.File
	 * @category Utilities
	 */
	public static StImage ImageFromFile_(File file) {
		return ImageFromFile_(file.getPath());
	}

	/**
	 * receives BMP, GIF, JPEG or PNG filename (full path), and return image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param filename java.lang.String
	 * @category Utilities
	 */
	public static StImage ImageFromFile_(String filename) {
		JunImageStream imageStream = null;
		StImage anImage = null;
		try {
			Class aClass = JunImageStream.ImageStreamClassForFileName_(filename);
			if (aClass == null) {
				JunDialog.Warn_("'" + filename + "'" + JunSystem.$String(" is not an image file."));
				return null;
			}

			imageStream = (JunImageStream) StObject._PerformWith(aClass, "On_", new FileInputStream(new File(filename)));
			anImage = imageStream.nextImage();
		} catch (IOException e) {
			System.out.println("IOException: " + e.getMessage());
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
		} finally {
			if (imageStream != null) {
				try {
					imageStream.close();
					imageStream = null;
				} catch (IOException e) {
					System.out.println("IOException: " + e.getMessage());
					e.printStackTrace();
				}
			}
		}

		return anImage;
	}

	/**
	 * open BMP, GIF, JPEG of PNG file with dialog and return java.awt.Image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Utilities
	 */
	public static StImage ImageFromFileDialog() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				JunFileModel.FileType.All(JunSystem.$String("All files")),
				new JunFileModel.FileType(JunSystem.$String("<1p> files", null, JunSystem.$String("Image")), JunSystem.DefaultImageExtensionPatterns()),
				new JunFileModel.FileType(JunSystem.$String("<1p> files", null, "GIF"), new String[] { "*.gif", "*.GIF", "*.giff", "*.GIFF" }),
				new JunFileModel.FileType(JunSystem.$String("<1p> files", null, "JPEG"), new String[] { "*.jpg", "*.JPG", "*.jpeg", "*.JPEG" }),
				new JunFileModel.FileType(JunSystem.$String("<1p> files", null, "PNG"), new String[] { "*.png", "*.PNG" }),
				new JunFileModel.FileType(JunSystem.$String("<1p> files", null, "BMP"), new String[] { "*.bmp", "*.BMP" }) };
		File file = JunFileRequesterDialog.RequestFile(JunSystem.$String("Select an <1p> file.", null, JunSystem.$String("Image")), fileTypes, fileTypes[1]);
		if (file == null) {
			return null;
		}
		return ImageFromFile_(file.getPath());
	}

	/**
	 * Juice the image with the specified color.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aDouble double
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Juicing
	 */
	public static StImage Juice_strongly_color_(StImage anImage, double aDouble, Color aColor) {
		return Juice_strongly_color_interim_(anImage, aDouble, aColor, new StBlockClosure());
	}

	/**
	 * Juice the image with the specified color.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aDouble double
	 * @param aColor java.awt.Color
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Juicing
	 */
	public static StImage Juice_strongly_color_interim_(StImage anImage, double aDouble, Color aColor, StBlockClosure aBlock) {
		StImage image = new StImage(anImage.width(), anImage.height(), _WhiteBlackPalette());
		int threshold = (int) ((1 - Math.max(0, Math.min(aDouble, 1))) * 255);
		int count = 1;
		for (int y = 0; y < anImage.height(); y++) {
			for (int x = 0; x < anImage.width(); x++) {
				Color color = anImage.valueAtPoint_(new Point(x, y));
				boolean bool = Math.abs(color.getRed() - aColor.getRed()) <= threshold;
				bool &= Math.abs(color.getGreen() - aColor.getGreen()) <= threshold;
				bool &= Math.abs(color.getBlue() - aColor.getBlue()) <= threshold;
				if (bool) {
					image.setPixel(x, y, Color.black.getRGB());
				} else {
					image.setPixel(x, y, Color.white.getRGB());
				}

				if (aBlock != null) {
					if (count % 16 == 0) {
						aBlock.value_(image);
					}
					count++;
				}
			}
		}

		if (aBlock != null) {
			aBlock.value_(image);
		}

		return image;
	}

	/**
	 * Answer the thin image from the specified image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category Thinning
	 */
	public static StImage MakeThin_(StImage anImage) {
		return MakeThin_interim_(anImage, new StBlockClosure() {
			public Object value_(Object obj) {
				// StImage image = (StImage) obj;
				return null;
			}
		});
	}

	/**
	 * Answer the thin image from the specified image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Thinning
	 */
	public static StImage MakeThin_interim_(StImage anImage, StBlockClosure aBlock) {
		int colorWhiteValue0 = Color.white.getRGB();
		int colorBlackValue1 = Color.black.getRGB();
		int colorGrayValue3 = Color.gray.getRGB();
		int colorGrayValue5 = Color.darkGray.getRGB();
		int colorGrayValue7 = Color.lightGray.getRGB();

		StImage image = anImage.convertToPalette_(_WhiteBlackPalette());
		byte[] bytes = { (byte) Color.white.getRed(), (byte) Color.black.getRed(), (byte) 100, (byte) Color.gray.getRed(), (byte) 100, (byte) Color.darkGray.getRed(), (byte) 100, (byte) Color.lightGray.getRed() };
		IndexColorModel palette = new IndexColorModel(8, bytes.length, bytes, bytes, bytes);
		StImage map = image.convertToPalette_(palette);

		int i1 = map.width() - 1;
		int j1 = map.height() - 1;
		int count = (aBlock != null) ? 0 : -1;
		boolean loop = true;
		while (loop) {
			for (int x = 1; x < i1 - 1; x++) {
				for (int y = 1; y < j1 - 1; y++) {
					if (map.getPixel(x, y) == colorBlackValue1) {
						if (map.getPixel(x - 1, y) == colorWhiteValue0) {
							map.setPixel(x, y, colorGrayValue3);
						} else {
							if (map.getPixel(x, y - 1) == colorWhiteValue0) {
								map.setPixel(x, y, colorGrayValue5);
							} else {
								if (map.getPixel(x + 1, y) == colorWhiteValue0) {
									map.setPixel(x, y, colorGrayValue3);
								} else {
									if (map.getPixel(x, y + 1) == colorWhiteValue0) {
										map.setPixel(x, y, colorGrayValue5);
									}
								}
							}
						}
					}
				}
			}

			int jsw = 0;
			int delta = 1;

			while (delta >= -1) {
				int ii1, ii2, jj1, jj2, data;
				if (delta == 1) {
					ii1 = 0;
					ii2 = i1;
					jj1 = 0;
					jj2 = j1;
					data = colorGrayValue3;
				} else {
					ii1 = i1 - 1;
					ii2 = -1;
					jj1 = j1 - 1;
					jj2 = -1;
					data = colorGrayValue5;
				}

				int i = ii1;

				while (i != ii2) {
					int im = i - 1;
					int ip = i + 1;
					int j = jj1;
					while (j != jj2) {
						int jm = j - 1;
						int jp = j + 1;
						if (map.getPixel(i, j) == data) {
							jsw = 1;
							int a1 = (map.getPixel(i, jp) == colorWhiteValue0) ? 1 : 0;
							int a2 = (map.getPixel(im, jp) == colorWhiteValue0) ? 1 : 0;
							int a3 = (map.getPixel(im, j) == colorWhiteValue0) ? 1 : 0;
							int a4 = (map.getPixel(im, jm) == colorWhiteValue0) ? 1 : 0;
							int a5 = (map.getPixel(i, jm) == colorWhiteValue0) ? 1 : 0;
							int a6 = (map.getPixel(ip, jm) == colorWhiteValue0) ? 1 : 0;
							int a7 = (map.getPixel(ip, j) == colorWhiteValue0) ? 1 : 0;
							int a8 = (map.getPixel(ip, jp) == colorWhiteValue0) ? 1 : 0;
							int ns = a1 + a3 + a5 + a7;
							if ((ns + a2 + a4 + a6 + a8) <= 6) {
								int k = ns - (a1 & a2 & a3) - (a3 & a4 & a5) - (a5 & a6 & a7) - (a7 & a8 & a1);
								if (k == 1) {
									map.setPixel(i, j, colorWhiteValue0);
									image.setPixel(i, j, colorWhiteValue0);
									if (aBlock != null) {
										if (count % 16 == 0) {
											aBlock.value_(image);
										}
										count += 1;
									}
								} else {
									map.setPixel(i, j, colorGrayValue7);
								}
							} else {
								map.setPixel(i, j, colorGrayValue7);
							}
						}
						j = j + delta;
					}
					i = i + delta;
				}
				delta = delta - 2;
			}
			loop = (jsw > 0);
		}
		if (aBlock != null) {
			aBlock.value_(image);
		}

		return image;
	}

	/**
	 * Answer mask halftone image.
	 *
	 * @return jp.co.sra.smalltalk.StImage
	 * @param extentPoint java.awt.Point
	 * @param halftoneScale double
	 * @category Halftone
	 */
	public static StImage Mask_halftone_(Point extentPoint, double halftoneScale) {
		StImage pattern = Halftone_(halftoneScale);
		StImage image = new StImage(extentPoint);
		image.tile_from_in_rule_(image.bounds(), new Point(0, 0), pattern, StImage.Over);
		return image;
	}

	/**
	 * Answer mask image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param indexInteger int
	 * @category Halftone
	 * @example: Evaluate in scrapbook.
	 *           jp.co.sra.jun.goodies.image.support.JunImageProcessor.MaskAt_(33);
	 */
	public static StImage MaskAt_(int indexInteger) {
		int index = indexInteger;
		index = Math.max(index, 1);
		index = Math.min(index, Masks().length);
		return Masks()[index - 1];
	}

	/**
	 * Answer masks and initialize its.
	 * 
	 * @return jp.co.sra.smalltalk.StImage[]
	 * @category Halftone
	 */
	public static StImage[] Masks() {
		if (Masks != null) {
			return Masks;
		}

		int[] map = new int[64];
		map[0] = 1;
		map[1] = 33;
		map[2] = 9;
		map[3] = 41;
		map[4] = 3;
		map[5] = 35;
		map[6] = 11;
		map[7] = 43;
		map[8] = 59;
		map[9] = 17;
		map[10] = 49;
		map[11] = 25;
		map[12] = 57;
		map[13] = 19;
		map[14] = 51;
		map[15] = 27;
		map[16] = 13;
		map[17] = 45;
		map[18] = 5;
		map[19] = 37;
		map[20] = 15;
		map[21] = 47;
		map[22] = 7;
		map[23] = 39;
		map[24] = 55;
		map[25] = 29;
		map[26] = 61;
		map[27] = 21;
		map[28] = 53;
		map[29] = 31;
		map[30] = 63;
		map[31] = 23;
		map[32] = 4;
		map[33] = 36;
		map[34] = 12;
		map[35] = 44;
		map[36] = 2;
		map[37] = 34;
		map[38] = 10;
		map[39] = 42;
		map[40] = 58;
		map[41] = 20;
		map[42] = 52;
		map[43] = 28;
		map[44] = 60;
		map[45] = 18;
		map[46] = 50;
		map[47] = 26;
		map[48] = 16;
		map[49] = 48;
		map[50] = 8;
		map[51] = 40;
		map[52] = 14;
		map[53] = 46;
		map[54] = 6;
		map[55] = 38;
		map[56] = 54;
		map[57] = 32;
		map[58] = 64;
		map[59] = 24;
		map[60] = 56;
		map[61] = 30;
		map[62] = 62;
		map[63] = 22;

		int pixelValue = Color.black.getRGB();
		StImage[] masks = new StImage[65];
		for (int index = 0; index < 65; index++) {
			StImage mask = new StImage(16, 16);
			if (index != 0) {
				int count = 0;
				for (int eachIndex = 0; eachIndex < map.length; eachIndex++) {
					int each = map[eachIndex];
					if (each <= index) {
						int x = count % 8;
						int y = count / 8;
						mask.setPixel(x, y, pixelValue);
						mask.setPixel(x + 8, y, pixelValue);
						mask.setPixel(x, y + 8, pixelValue);
						mask.setPixel(x + 8, y + 8, pixelValue);
					}
					count = count + 1;
				}
			}
			masks[index] = mask;
		}
		Masks = masks;
		return Masks;
	}

	/**
	 * Answer scale image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage StImage
	 * @param scaleFactor jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Scaling
	 */
	public static StImage Scale_factor_(StImage anImage, Jun2dPoint scaleFactor) {
		AffineTransformOp operation = new AffineTransformOp(AffineTransform.getScaleInstance(scaleFactor.x(), scaleFactor.y()), AffineTransformOp.TYPE_NEAREST_NEIGHBOR);

		return new StImage(operation.filter(anImage.image(), null));
	}

	/**
	 * Answer shape image with black.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category Shaping
	 */
	public static StImage Shape_(StImage anImage) {
		return Shape_color_(anImage, Color.black);
	}

	/**
	 * Answer shape image with color.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param colorValue java.awt.Color
	 * @category Shaping
	 */
	public static StImage Shape_color_(StImage anImage, Color colorValue) {
		StImage copyImage = (StImage) anImage.clone();
		StImage expandImage = new StImage(copyImage.width() + 2, copyImage.height() + 2);
		expandImage.copy_from_in_rule_(new Rectangle(1, 1, copyImage.width(), copyImage.height()), new Point(0, 0), copyImage, StImage.Over);
		Fill_seed_color_(expandImage, new Point(0, 0), colorValue);

		int width = copyImage.width();
		int height = copyImage.height();
		int index = colorValue.getRGB();
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				if ((index != copyImage.getPixel(x, y)) && (index != expandImage.getPixel(x + 1, y + 1))) {
					copyImage.setPixel(x, y, index);
				}
			}
		}

		return copyImage;
	}

	/**
	 * Answer number of stipple.
	 * 
	 * @return int
	 * @param stippleScale double
	 * @category Stipples
	 */
	public static int Stipple_(double stippleScale) {
		double scale = stippleScale;
		scale = Math.max(scale, 0);
		scale = Math.min(scale, 1);
		int index = new Double((Stipples().length - 1) * scale).intValue() + 1;
		return StippleAt_(index);
	}

	/**
	 * Answer number of stipple.
	 * 
	 * @return int
	 * @param indexInteger int
	 * @category Stipples
	 */
	public static int StippleAt_(int indexInteger) {
		int index = indexInteger;
		index = Math.max(index, 1);
		index = Math.min(index, Stipples().length);
		return Stipples()[index - 1];
	}

	/**
	 * Answer the stipples and initialize its.
	 * 
	 * @return int[]
	 * @category Stipples
	 */
	public static int[] Stipples() {
		if (Stipples != null) {
			return Stipples;
		}

		int[] stipples = new int[9];
		stipples[0] = Integer.parseInt("0000", 16);
		stipples[1] = Integer.parseInt("8080", 16);
		stipples[2] = Integer.parseInt("8888", 16);
		stipples[3] = Integer.parseInt("A8A8", 16);
		stipples[4] = Integer.parseInt("AAAA", 16);
		stipples[5] = Integer.parseInt("EAEA", 16);
		stipples[6] = Integer.parseInt("EEEE", 16);
		stipples[7] = Integer.parseInt("FEFE", 16);
		stipples[8] = Integer.parseInt("FFFF", 16);
		Stipples = stipples;
		return Stipples;
	}

	/**
	 * Answer trace border on anImage.
	 * 
	 * @return java.lang.Object[]
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category Tracing
	 */
	public static Object[] TraceBorder_(StImage anImage) {
		StAssociation[] collection = BorderFollowing_(anImage);
		Object[] array = new Object[collection.length];
		for (int i = 0; i < collection.length; i++) {
			array[i] = (collection[i]).value();
		}
		return array;
	}

	/**
	 * Answer x-spectrum on anImage.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return float[]
	 * @category Spectrum
	 */
	public static float[] XSpectrum_(StImage anImage) {
		StImage image = null;
		if (JunImageProcessor.ColorPalette256().equals(anImage.image().getColorModel())) {
			image = anImage;
		} else {
			image = anImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.ColorPalette256());
		}

		int width = image.width();
		int height = image.height();
		float[] spectrum = new float[width];
		for (int x = 0; x < width; x++) {
			double value = 0;
			for (int y = 0; y < height; y++) {
				Color color = image.valueAtPoint_(new Point(x, y));
				value += (1 - StColorValue._GetBrightness(color));
			}

			spectrum[x] = (float) (value / height);
		}

		return spectrum;
	}

	/**
	 * Answer y-spectrum on anImage.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return float[]
	 * @category Spectrum
	 */
	public static float[] YSpectrum_(StImage anImage) {
		StImage image = null;
		if (JunImageProcessor.ColorPalette256().equals(anImage.image().getColorModel())) {
			image = anImage;
		} else {
			image = anImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.ColorPalette256());
		}

		int width = image.width();
		int height = image.height();
		float[] spectrum = new float[width];
		for (int y = 0; y < height; y++) {
			double value = 0;
			for (int x = 0; x < width; x++) {
				Color color = image.valueAtPoint_(new Point(x, y));
				value += (1 - StColorValue._GetBrightness(color));
			}

			spectrum[y] = (float) (value / width);
		}

		return spectrum;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return int
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aPoint java.awt.Point
	 * @param max int
	 * @param paletteIndex int
	 * @category X accessing
	 */
	private static int FirstOff_after_before_index_(StImage anImage, Point aPoint, int max, int paletteIndex) {
		if (!(aPoint.x < max)) {
			return max;
		}

		Rectangle b = anImage.bounds();
		int x = Math.min(Math.max(aPoint.x, 0), b.width - 1);
		int y = Math.min(Math.max(aPoint.y, 0), b.height - 1);
		if (paletteIndex != anImage.getPixel(x, y)) {
			x = x + 1;
			while ((x < max) && (paletteIndex != anImage.getPixel(x, y))) {
				x = x + 1;
			}
		}

		return Math.min(x, max);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return int
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aPoint java.awt.Point
	 * @param max int
	 * @param paletteIndex int
	 * @category X accessing
	 */
	private static int FirstOn_after_before_index_(StImage anImage, Point aPoint, int max, int paletteIndex) {
		Rectangle b = anImage.bounds();
		int x = Math.min(Math.max(aPoint.x, 0), b.width - 1);
		int y = Math.min(Math.max(aPoint.y, 0), b.height - 1);
		if (paletteIndex == anImage.getPixel(x, y)) {
			x = x + 1;
			while ((x < max) && (paletteIndex == anImage.getPixel(x, y))) {
				x = x + 1;
			}
		}

		return Math.min(x, max);
	}

	/**
	 * Clean up my masks.
	 * 
	 * @category Halftone
	 */
	private static void FlushMasks() {
		Masks = null;
	}

	/**
	 * Clean up my palette
	 * 
	 * @category Constants of palette
	 */
	private static void FlushPalettes() {
		ColorPalette256 = null;
		GrayPalette256 = null;
		_WhiteBlackPalette = null;
		_BlackWhitePalette = null;
	}

	/**
	 * Initialize this class.
	 * 
	 * @category Class initialization
	 */
	private static void Initialize() {
		FlushPalettes();
		FlushMasks();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return int
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aPoint java.awt.Point
	 * @param min int
	 * @param paletteIndex int
	 * @category X accessing
	 */
	private static int LastOn_before_after_index_(StImage anImage, Point aPoint, int min, int paletteIndex) {
		Rectangle b = anImage.bounds();
		int x = Math.min(Math.max(aPoint.x, 0), b.width - 1);
		int y = Math.min(Math.max(aPoint.y, 0), b.height - 1);

		while ((x > min) && (paletteIndex == anImage.getPixel(x, y))) {
			x = x - 1;
		}

		return x;
	}

}
