package jp.co.sra.jun.goodies.image.support;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.util.Map;

import jp.co.sra.smalltalk.StAssociation;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.colors.JunColorChoiceSBH;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImageProcessorTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/11/16 (by Hirotsugu Kondo)
 *  @updated   2000/01/13 (by Mitsuhiro Asada)
 *  @updated   2007/06/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun668 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageProcessorTestExamples.java,v 8.12 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageProcessorTestExamples extends JunTestExamples {

	/**
	 * Example: Copy image onto another image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example01() {
		StImage source = new JunColorChoiceSBH().plate();
		StImage destination = (StImage) new jp.co.sra.jun.goodies.colors.JunColorChoiceHBS().plate().copy();
		Rectangle area = new Rectangle(25, 25, 55, 55);
		destination.copy_from_in_rule_(area, new Point(0, 0), source, StImage.Over);
		destination._display();

		return true;
	}

	/**
	 * Example: Tile image onto another image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example02() {
		StImage destination = (StImage) new StImage(JunOpenGLTextureTestExamples.ImageEarth()).copy();
		StImage source = new StImage(JunCursors.StopCursorImage());
		Rectangle area = new Rectangle(10, 10, 30, 30);
		destination.tile_from_in_rule_(area, new Point(0, 0), source, StImage.Over);
		destination._display();

		return true;
	}

	/**
	 * Example: Scaled image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example03() {
		StImage source = new jp.co.sra.jun.goodies.colors.JunColorChoiceSBH().plate();
		StImage result = JunImageProcessor.Scale_factor_(source, new Jun2dPoint(2.5, 2));
		result._display();

		return true;
	}

	/**
	 * Example: Scaled b/w image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example04() {
		StImage source = new StImage(JunSystem.LogoImage());
		StImage result = JunImageProcessor.Scale_factor_(source, new Jun2dPoint(2.5, 2));
		result._display();

		return true;
	}

	/**
	 * Example: get stippled image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example05() {
		StImage destination = new StImage(512, 512);

		for (int index = 0; index < 66; index++) {
			Rectangle area = new Rectangle(index % 8 * 24, index / 8 * 24, 16, 16);
			destination.copy_from_in_rule_(area, new Point(0, 0), JunImageProcessor.MaskAt_(index), StImage.Over);
		}

		destination._display();

		return true;
	}

	/**
	 * Example: get stippled value
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example06() {
		System.out.print(JunImageProcessor.Stipple_(0.5));

		return true;
	}

	/**
	 * Example: Fill image onto color.pink
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example07() {
		StImage anImage;
		anImage = JunImageProcessorTestExamples._TestImage();
		JunImageProcessor.Fill_rectangle_color_(anImage, new Rectangle(20, 20, 60, 60), Color.pink);
		anImage._display();
		anImage = JunImageProcessorTestExamples._TestImage();
		JunImageProcessor.Fill_seed_color_(anImage, new Point(75, 75), Color.pink);
		anImage._display();

		return true;
	}

	/**
	 * Example: Color histogram image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example08() {
		StImage anImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
		Map.Entry[] histogram = JunImageProcessor.ColorHistogram_(anImage);
		StImage image = new StImage(401, histogram.length * 4);
		for (int i = 0; i < histogram.length; i++) {
			int width = (int) (((Number) histogram[i].getValue()).floatValue() * 400);
			if (width == 0) {
				width = 1;
			}
			Rectangle box = new Rectangle(1, i * 4, width, 3);
			Color color = (Color) histogram[i].getKey();
			image = JunImageProcessor.Fill_rectangle_color_(image, box, color);
		}
		image._display();
		return true;
	}

	/**
	 * Example: icon image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example09() {
		StImage anImage = new StImage(10, 10);
		anImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
		anImage = JunImageProcessor.Scale_factor_(anImage, new Jun2dPoint(2, 1.5));
		JunImageProcessor.Icon_size_(anImage, 128)._display();

		return true;
	}

	/**
	 * Example: x spectrum image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example10() {
		StImage anImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
		float[] xspectrum = JunImageProcessor.XSpectrum_(anImage);
		StImage image = new StImage(xspectrum.length, 100);
		for (int x = 0; x < xspectrum.length; x++) {
			int value = (int) (xspectrum[x] * 100);
			if (value == 0) {
				value = 1;
			}
			Rectangle box = new Rectangle(x, 0, 1, value);
			image = JunImageProcessor.Fill_rectangle_color_(image, box, Color.black);
		}
		image._display();

		return true;
	}

	/**
	 * Example: y spectrum image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example11() {
		StImage anImage = new StImage(JunOpenGLTextureTestExamples.ImageSmalltalkBalloon());
		float[] yspectrum = JunImageProcessor.YSpectrum_(anImage);
		StImage image = new StImage(100, yspectrum.length);
		for (int y = 0; y < yspectrum.length; y++) {
			int value = (int) (yspectrum[y] * 100);
			if (value == 0) {
				value = 1;
			}
			Rectangle box = new Rectangle(0, y, value, 1);
			image = JunImageProcessor.Fill_rectangle_color_(image, box, Color.black);
		}
		image._display();

		return true;
	}

	/**
	 * Example: 256 color palette.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example12() {
		JunImageProcessor.ColorPalette256Image_(new Point(8, 8))._display();
		JunImageProcessor.GrayPalette256Image_(new Point(8, 8))._display();

		return true;
	}

	/**
	 * Example: Shape image onto color.green
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example13() {
		StImage anImage = JunImageProcessorTestExamples._TestImage();
		anImage = JunImageProcessor.Shape_color_(anImage, Color.green);
		anImage._display();

		return true;
	}

	/**
	 * Example: image border following
	 * 
	 * @return boolean.
	 * @category Examples
	 */
	public static boolean Example14() {
		Graphics gc = null;
		StImage anImage = new StImage(JunSystem.LogoImage());
		StAssociation[] collection = JunImageProcessor.BorderFollowing_(anImage);
		StImage stImage = new StImage(anImage.width() + 2, anImage.height() + 2);
		Image newImage = stImage.image();

		try {
			gc = newImage.getGraphics();

			if (gc instanceof Graphics2D) {
				((Graphics2D) gc).setBackground(SystemColor.window);
			}

			gc.setColor(Color.black);

			for (int i = 0; i < collection.length; i++) {
				StAssociation assoc = collection[i];
				Point[] points = (Point[]) assoc.value();
				int[] xPoints = new int[points.length];
				int[] yPoints = new int[points.length];

				for (int j = 0; j < points.length; j++) {
					xPoints[j] = points[j].x;
					yPoints[j] = points[j].y;
				}

				gc.drawPolyline(xPoints, yPoints, xPoints.length);
			}

			(new StImage(newImage))._display();
		} finally {
			gc.dispose();
			newImage.flush();
		}

		return true;
	}

	/**
	 * Example: image trace border
	 * 
	 * @return boolean.
	 * @category Examples
	 */
	public static boolean Example15() {
		Graphics gc = null;
		StImage anImage = new StImage(JunSystem.LogoImage());
		Object[] collection = JunImageProcessor.TraceBorder_(anImage);
		StImage stImage = new StImage(anImage.width() + 2, anImage.height() + 2);
		Image newImage = stImage.image();

		try {
			gc = newImage.getGraphics();

			if (gc instanceof Graphics2D) {
				((Graphics2D) gc).setBackground(SystemColor.window);
			}

			gc.setColor(Color.black);

			for (int i = 0; i < collection.length; i++) {
				Point[] points = (Point[]) collection[i];
				int[] xPoints = new int[points.length];
				int[] yPoints = new int[points.length];

				for (int j = 0; j < points.length; j++) {
					xPoints[j] = points[j].x;
					yPoints[j] = points[j].y;
				}

				gc.drawPolyline(xPoints, yPoints, xPoints.length);
			}

			stImage._display();
		} finally {
			gc.dispose();
			newImage.flush();
		}

		return true;
	}

	/**
	 * Example: thinning image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example16() {
		StImage anImage = new StImage(JunSystem.LogoImage());
		anImage = JunImageProcessor.MakeThin_(anImage);
		anImage._display();

		return true;
	}

	/**
	 * Example: image convert to palette
	 * 
	 * @return boolean.
	 * @category Examples
	 */
	public static boolean Example17() {
		StImage anImage = StImage._FromUser();
		anImage._display();
		StImage newImage = anImage._convertToPalette_RenderedByNearistPaint(JunImageProcessor.GrayPalette256());
		newImage._display();
		newImage = anImage._convertToPalette_RenderedByErrorDiffusion(JunImageProcessor.GrayPalette256());
		newImage._display();

		return true;
	}

	/**
	 * Example: halftone image
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example18() {
		StImage anImage = JunImageProcessor.Image_halftone_(StImage._FromUser(), 0.5);
		anImage._display();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunImageProcessorTestExamples();
	}

	/**
	 * Answer the test image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Private
	 */
	protected static StImage _TestImage() {
		int width = 50;
		int height = 50;
		int index = 0;
		StImage anImage = new StImage(width * 3, height * 3);
		Color[] colors = new Color[9];
		colors[0] = Color.black;
		colors[1] = Color.red;
		colors[2] = Color.green;
		colors[3] = Color.blue;
		colors[4] = Color.white;
		colors[5] = Color.yellow;
		colors[6] = Color.cyan;
		colors[7] = Color.magenta;
		colors[8] = Color.gray;

		for (int y = 0; y < 3; y++) {
			for (int x = 0; x < 3; x++) {
				StImage pattern = new StImage(16, 16);
				int value = colors[index].getRGB();

				for (int x2 = 0; x2 < pattern.width(); x2++) {
					for (int y2 = 0; y2 < pattern.height(); y2++) {
						pattern.setPixel(x2, y2, value);
					}
				}
				anImage.tile_from_in_rule_(new Rectangle((width * x) + 1, (height * y) + 1, width - 2, height - 2), new Point(0, 0), pattern, StImage.Over);
				index = index + 1;
			}
		}

		return anImage;
	}
}
