package jp.co.sra.jun.goodies.itemlist;

import java.awt.Dialog;
import jp.co.sra.smalltalk.*;

/**
 * JunItemListDialog class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/13 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunItemListDialog.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunItemListDialog extends JunOrderListDialog {
	/**
	 * Create a new instance of JunItemListDialog.
	 * 
	 * @category Instance creation
	 */
	public JunItemListDialog() {
		super();
	}

	/**
	 * Open a JunItemListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @category Utilities
	 */
	public static Object[] Request_labels_(String messageString, String[] stringCollection) {
		return Request_labels_onAccept_onCancel_(messageString, stringCollection, null, null);
	}

	/**
	 * Open a JunItemListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Utilities
	 */
	public static Object[] Request_labels_onAccept_onCancel_(String messageString, String[] stringCollection, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		return Request_labels_checks_onAccept_onCancel_(messageString, stringCollection, null, acceptBlock, cancelBlock);
	}

	/**
	 * Open a JunItemListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @param booleanCollection boolean[]
	 * @category Utilities
	 */
	public static Object[] Request_labels_checks_(String messageString, String[] stringCollection, boolean[] booleanCollection) {
		return Request_labels_checks_onAccept_onCancel_(messageString, stringCollection, booleanCollection, null, null);
	}

	/**
	 * Open a JunItemListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @param checkBooleanCollection boolean[]
	 * @param lockBooleanCollection boolean[]
	 * @category Utilities
	 */
	public static Object[] Request_labels_checks_locks_(String messageString, String[] stringCollection, boolean[] checkBooleanCollection, boolean[] lockBooleanCollection) {
		return Request_labels_checks_locks_onAccept_onCancel_(messageString, stringCollection, checkBooleanCollection, lockBooleanCollection, null, null);
	}

	/**
	 * Open a JunItemListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @param booleanCollection boolean[]
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Utilities
	 */
	public static Object[] Request_labels_checks_onAccept_onCancel_(String messageString, String[] stringCollection, boolean[] booleanCollection, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		return Request_labels_checks_locks_onAccept_onCancel_(messageString, stringCollection, booleanCollection, null, acceptBlock, cancelBlock);
	}

	/**
	 * Open a JunItemListDialog showing a message string and let a user to select item value.
	 * 
	 * @return java.lang.Object[]
	 * @param messageString java.lang.String
	 * @param stringCollection java.lang.String[]
	 * @param checkBooleanCollection boolean[]
	 * @param lockBooleanCollection boolean[]
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Utilities
	 */
	public static Object[] Request_labels_checks_locks_onAccept_onCancel_(String messageString, String[] stringCollection, boolean[] checkBooleanCollection, boolean[] lockBooleanCollection, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunItemListDialog itemListDialog = new JunItemListDialog();
		itemListDialog.itemListModel_(new JunItemListModel(stringCollection, checkBooleanCollection, lockBooleanCollection));

		Dialog dialog = itemListDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			itemListDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			itemListDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);

		if (itemListDialog.accept()._booleanValue()) {
			return itemListDialog.itemListModel().value();
		} else {
			return null;
		}
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category viewing
	 */
	protected String windowTitle() {
		return "Item List Dialog";
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunItemListDialogViewAwt(this);
		} else {
			return new JunItemListDialogViewSwing(this);
		}
	}
}
