package jp.co.sra.jun.goodies.itemlist;

import java.util.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunOrderListDialogTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOrderListDialogTestExamples.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunOrderListDialogTestExamples extends JunOrderListTestExamples {
	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOrderListDialogTestExamples();
	}

	/**
	 * Example1 : test for a JunOrderListDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Object[] answer = JunOrderListDialog.Request_labels_(JunSystem.$String("Arrange order."), _StringArray);
		_PrintObjects_(answer);
		return true;
	}

	/**
	 * Example2 : test for a JunOrderListDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Vector colorNames = StColorValue.ConstantNames();
		String[] stringArray = new String[colorNames.size()];
		for (int i = 0; i < stringArray.length; i++) {
			stringArray[i] = colorNames.get(i).toString();
		}
		Arrays.sort(stringArray);
		Object[] answer = JunOrderListDialog.Request_labels_(JunSystem.$String("Arrange order."), stringArray);
		_PrintObjects_(answer);
		return true;
	}

	/**
	 * Example3 : test for a JunOrderListDialog.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Object[] answer = JunOrderListDialog.Request_labels_onAccept_onCancel_(JunSystem.$String("Arrange order."), _StringArray, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOrderListModel model = (JunOrderListModel) anObject;
				System.out.print(JunSystem.$String("Accept button was pressed."));
				System.out.print(" \t");
				_PrintObjects_(model.value());
				return Boolean.TRUE;
			}
		}, new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOrderListModel model = (JunOrderListModel) anObject;
				System.out.print(JunSystem.$String("Cancel button was pressed."));
				System.out.print(" \t");
				_PrintObjects_(model.value());
				return Boolean.TRUE;
			}
		});
		_PrintObjects_(answer);
		return true;
	}

	/**
	 * Printing objects.
	 * 
	 * @param objects java.lang.Object[]
	 * @category Private
	 */
	static protected void _PrintObjects_(Object[] objects) {
		if (objects == null) {
			System.out.println(objects);
			return;
		}

		System.out.print("(");
		for (int i = 0; i < objects.length; i++) {
			System.out.print(objects[i].toString());
			if (i < objects.length - 1) {
				System.out.print(", ");
			}
		}
		System.out.println(")");
	}
}
