package jp.co.sra.jun.goodies.meter;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Random;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;

import jp.co.sra.jun.goodies.gauge.JunLevelGaugeModelTestExamples;

/**
 * JunLevelGaugeMeterTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/04 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLevelGaugeMeterTestExamples.java,v 8.6 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLevelGaugeMeterTestExamples extends JunLevelGaugeModelTestExamples {
	/**
	 * Example: Open a JunLevelGaugeMeter.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final JunLevelGaugeMeter aMeter = new JunLevelGaugeMeter(10, 0.5, 1, 0);
		aMeter.backgroundColor_(StColorValue.VeryLightGray);
		aMeter.frameColor_(StColorValue.VeryLightGray);
		aMeter.showAverage_(false);
		aMeter.open();
		if (aMeter.isEmpty()) {
			return false;
		}
		ExampleDo_(new StBlockClosure() {
			public Object value_(final Object aRandom) {
				Collection valueCollection = aMeter.collect_(new StBlockClosure() {
					public Object value_(Object gauge) {
						return new Double(((Random) aRandom).nextDouble() * aMeter.range() + aMeter.minimum());
					}
				});
				Number[] values = (Number[]) valueCollection.toArray(new Double[valueCollection.size()]);
				aMeter.values_(values);
				return null;
			}
		});
		return true;
	}

	/**
	 * Example: Open a JunLevelGaugeMeter with horizontal.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final JunLevelGaugeMeter aMeter = new JunLevelGaugeMeter(20, 0, 1, -1);
		aMeter.verticalGauge_(false);
		aMeter.backgroundColor_(StColorValue.VeryLightGray);
		aMeter.frameColor_(StColorValue.VeryLightGray);
		aMeter.showAverage_(false);
		aMeter.openIn_(new Rectangle(200, 200, 200, 400));
		if (aMeter.isEmpty()) {
			return false;
		}
		ExampleDo_(new StBlockClosure() {
			public Object value_(final Object aRandom) {
				Collection valueCollection = aMeter.collect_(new StBlockClosure() {
					public Object value_(Object gauge) {
						return new Double(((Random) aRandom).nextDouble() * aMeter.range() + aMeter.minimum());
					}
				});
				Number[] values = (Number[]) valueCollection.toArray(new Double[valueCollection.size()]);
				aMeter.values_(values);
				return null;
			}
		});
		return true;
	}

	/**
	 * Example: Open a JunLevelGaugeMeter with reverse direction.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final JunLevelGaugeMeter aMeter = new JunLevelGaugeMeter(10, 0.5, 1, 0);
		aMeter.reverseDirection_(true);
		aMeter.backgroundColor_(StColorValue.VeryLightGray);
		aMeter.frameColor_(StColorValue.VeryLightGray);
		aMeter.showAverage_(false);
		aMeter.open();
		if (aMeter.isEmpty()) {
			return false;
		}
		ExampleDo_(new StBlockClosure() {
			public Object value_(final Object aRandom) {
				Collection valueCollection = aMeter.collect_(new StBlockClosure() {
					public Object value_(Object gauge) {
						return new Double(((Random) aRandom).nextDouble() * aMeter.range() + aMeter.minimum());
					}
				});
				Number[] values = (Number[]) valueCollection.toArray(new Double[valueCollection.size()]);
				aMeter.values_(values);
				return null;
			}
		});
		return true;
	}

	/**
	 * Example: Open a JunLevelGaugeMeter with horizontal and reverse direction.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		final JunLevelGaugeMeter aMeter = new JunLevelGaugeMeter(20, 0, 1, -1);
		aMeter.verticalGauge_(false);
		aMeter.reverseDirection_(true);
		aMeter.backgroundColor_(StColorValue.VeryLightGray);
		aMeter.frameColor_(StColorValue.VeryLightGray);
		aMeter.showAverage_(false);
		aMeter.openIn_(new Rectangle(200, 200, 200, 400));
		if (aMeter.isEmpty()) {
			return false;
		}
		ExampleDo_(new StBlockClosure() {
			public Object value_(final Object aRandom) {
				Collection valueCollection = aMeter.collect_(new StBlockClosure() {
					public Object value_(Object gauge) {
						return new Double(((Random) aRandom).nextDouble() * aMeter.range() + aMeter.minimum());
					}
				});
				Number[] values = (Number[]) valueCollection.toArray(new Double[valueCollection.size()]);
				aMeter.values_(values);
				return null;
			}
		});
		return true;
	}

	/**
	 * Example: Open a JunLevelGaugeMeter with rainbow color.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		final JunLevelGaugeMeter aMeter = new JunLevelGaugeMeter(100, 0.5, 1, 0);
		aMeter.backgroundColor_(StColorValue.VeryLightGray);
		aMeter.frameColor_(StColorValue.VeryLightGray);
		aMeter.valueColor_(StColorValue.VeryLightGray);
		aMeter.hillColor_(Color.white);
		aMeter.averageColor_(Color.white);
		aMeter.daleColor_(Color.white);
		aMeter.edgeColor_(StColorValue.LightGray);
		aMeter.rainbowColor_(true);
		aMeter.gaugeWidth_(5);
		aMeter.cellSize_(3);
		aMeter.cellSpace_(1);
		aMeter.showHill_(true);
		aMeter.showAverage_(false);
		aMeter.showDale_(false);
		aMeter.showEdge_(false);
		aMeter.openIn_(new Rectangle(200, 200, 800, 200));
		if (aMeter.isEmpty()) {
			return false;
		}
		ExampleDo_(new StBlockClosure() {
			public Object value_(final Object aRandom) {
				Collection valueCollection = aMeter.collect_(new StBlockClosure() {
					public Object value_(Object gauge) {
						return new Double(((Random) aRandom).nextDouble() * aMeter.range() + aMeter.minimum());
					}
				});
				Number[] values = (Number[]) valueCollection.toArray(new Double[valueCollection.size()]);
				aMeter.values_(values);
				return null;
			}
		});
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunLevelGaugeMeterTestExamples();
	}
}
