package jp.co.sra.jun.goodies.milliseconds;

import java.awt.Dialog;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMillisecondDialog class
 * 
 *  @author    nisinaka
 *  @created   2003/05/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMillisecondDialog.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMillisecondDialog extends StSimpleDialog {

	protected JunMillisecondModel millisecondModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * JunMillisecondDialog constructor comment.
	 */
	public JunMillisecondDialog() {
		super();
	}

	/**
	 * Open a JunMillisecondDialog and let a user to enter millisecond value.
	 *
	 * @return long
	 */
	public static long Request() {
		return Request(null);
	}

	/**
	 * Open a JunMillisecondDialog showing a message string and let a user to enter millisecond value.
	 *
	 * @return long
	 * @param messageString java.lang.String
	 */
	public static long Request(String messageString) {
		return Request(messageString, 0);
	}

	/**
	 * Open a JunMillisecondDialog showing a message string and let a user to enter millisecond value.
	 *
	 * @return long
	 * @param messageString java.lang.String
	 * @param millisecondValue long
	 */
	public static long Request(String messageString, long millisecondValue) {
		return Request(messageString, millisecondValue, null, null);
	}

	/**
	 * Open a JunMillisecondDialog showing a message string and let a user to enter millisecond value.
	 *
	 * @return long
	 * @param messageString java.lang.String
	 * @param millisecondValue long
	 * @param validateBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public static long Request(String messageString, long millisecondValue, StBlockClosure validateBlock) {
		return Request(messageString, millisecondValue, null, null, validateBlock);
	}

	/**
	 * Open a JunMillisecondDialog showing a message string and let a user to enter millisecond value.
	 *
	 * @return long
	 * @param messageString java.lang.String
	 * @param millisecondValue long
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public static long Request(String messageString, long millisecondValue, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		return Request(messageString, millisecondValue, acceptBlock, cancelBlock, null);
	}

	/**
	 * Open a JunMillisecondDialog showing a message string and let a user to enter millisecond value.
	 *
	 * @return long
	 * @param messageString java.lang.String
	 * @param millisecondValue long
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param validateBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	public static long Request(String messageString, long millisecondValue, StBlockClosure acceptBlock, StBlockClosure cancelBlock, StBlockClosure validateBlock) {
		JunMillisecondDialog millisecondDialog = new JunMillisecondDialog();
		millisecondDialog.millisecondModel_(new JunMillisecondModel(millisecondValue));
		if (validateBlock != null) {
			millisecondDialog.millisecondModel().validateBlock_(validateBlock);
		}

		Dialog dialog = millisecondDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			millisecondDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			millisecondDialog.cancelBlock_(cancelBlock);
		}
		_ShowAtMousePoint(dialog);

		if (millisecondDialog.accept()._booleanValue()) {
			return millisecondDialog.millisecondModel().milliseconds();
		} else {
			return -1;
		}
	}

	/**
	 * Called when an accept button is pressed.
	 *
	 * @return boolean
	 */
	public boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			return ((Boolean) acceptBlock.value_(this.millisecondModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Called when a cancel button is pressed.
	 *
	 * @return boolean
	 */
	public boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			return ((Boolean) cancelBlock.value_(this.millisecondModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunMillisecondDialogViewAwt(this);
		} else {
			return new JunMillisecondDialogViewSwing(this);
		}
	}

	/**
	 * Answer my current millisecond model.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel
	 */
	public JunMillisecondModel millisecondModel() {
		if (millisecondModel == null) {
			millisecondModel = new JunMillisecondModel();
		}
		return millisecondModel;
	}

	/**
	 * Set my new millisecond model.
	 *
	 * @param newMillisecondModel jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel
	 */
	public void millisecondModel_(JunMillisecondModel newMillisecondModel) {
		millisecondModel = newMillisecondModel;
	}

	/**
	 * Set the new accept block.
	 *
	 * @param newAcceptBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	protected void acceptBlock_(StBlockClosure newAcceptBlock) {
		acceptBlock = newAcceptBlock;
	}

	/**
	 * Set the new cancel block.
	 *
	 * @param newCancelBlock jp.co.sra.smalltalk.StBlockClosure
	 */
	protected void cancelBlock_(StBlockClosure newCancelBlock) {
		cancelBlock = newCancelBlock;
	}

	/**
	 * Initialize the JunMillisecondDialog.
	 */
	protected void initialize() {
		super.initialize();

		millisecondModel = null;
		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 */
	protected String windowTitle() {
		return JunSystem.$String("Time Dialog", "Milliseconds Dialog");
	}
}
