package jp.co.sra.jun.goodies.milliseconds;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunMillisecondDialogTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2003/05/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMillisecondDialogTestExamples.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMillisecondDialogTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1: Use JunMillisecondDialog to request for a millisecond value.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		long milliseconds = JunMillisecondDialog.Request();
		if (milliseconds < 0) {
			return false;
		}

		String string = JunMillisecondModel.ConvertMillisecondsToString_(milliseconds);
		System.out.println(string);

		return true;
	}

	/**
	 * Example2: Use JunMillisecondDialog to request for a millisecond value.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		long milliseconds = JunMillisecondDialog.Request(JunSystem.$String("Input time."));
		if (milliseconds < 0) {
			return false;
		}

		String string = JunMillisecondModel.ConvertMillisecondsToString_(milliseconds);
		System.out.println(string);

		return true;
	}

	/**
	 * Example3: Use JunMillisecondDialog to request for a millisecond value.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		long milliseconds = JunMillisecondModel.ConvertStringToMilliseconds_("100:00:00.000");
		milliseconds = JunMillisecondDialog.Request(JunSystem.$String("Input time."), milliseconds);
		if (milliseconds < 0) {
			return false;
		}

		String string = JunMillisecondModel.ConvertMillisecondsToString_(milliseconds);
		System.out.println(string);

		return true;
	}

	/**
	 * Example4: Use JunMillisecondDialog to request for a millisecond value.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		long milliseconds = JunMillisecondModel.ConvertStringToMilliseconds_("100:00:00.000");
		milliseconds = JunMillisecondDialog.Request(JunSystem.$String("Input time."), milliseconds, new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println(JunSystem.$String("Accept button was pressed."));
				System.out.println(model);
				return Boolean.TRUE;
			}
		}, new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				System.out.println(model);
				return Boolean.TRUE;
			}
		});
		if (milliseconds < 0) {
			return false;
		}

		String string = JunMillisecondModel.ConvertMillisecondsToString_(milliseconds);
		System.out.println(string);

		return true;
	}

	/**
	 * Example5: Use JunMillisecondDialog to request for a millisecond value.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		final long maxValue = (new JunMillisecondModel(100, 0, 0, 10)).milliseconds();
		final long minValue = (new JunMillisecondModel(99, 59, 59, 990)).milliseconds();
		long milliseconds = JunMillisecondModel.ConvertStringToMilliseconds_("100:00:00.000");
		milliseconds = JunMillisecondDialog.Request(JunSystem.$String("Input time."), milliseconds, new StBlockClosure() {
			public Object value_value_(Object oldValue, Object newValue) {
				long value = ((Number) newValue).longValue();
				if (minValue <= value && value <= maxValue) {
					return newValue;
				} else {
					return oldValue;
				}
			}
		});
		if (milliseconds < 0) {
			return false;
		}

		String string = JunMillisecondModel.ConvertMillisecondsToString_(milliseconds);
		System.out.println(string);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunMillisecondDialogTestExamples();
	}
}
