package jp.co.sra.jun.goodies.milliseconds;

import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunMillisecondModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2003/05/08 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMillisecondModelTestExamples.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMillisecondModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1: Create a JunMillisecondModel and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunMillisecondModel millisecondModel = new JunMillisecondModel(1234567890);
		millisecondModel.open();

		return true;
	}

	/**
	 * Example2: Create a JunMillisecondModel and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunMillisecondModel millisecondModel = new JunMillisecondModel(123, 59, 59, 999);
		millisecondModel.open();

		return true;
	}

	/**
	 * Example3: Create a JunMillisecondModel and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunMillisecondModel millisecondModel = new JunMillisecondModel(100, 0, 0, 0);
		millisecondModel.open();

		return true;
	}

	/**
	 * Example4: Create a JunMillisecondModel and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		final long maxValue = (new JunMillisecondModel(100, 0, 0, 10)).milliseconds();
		final long minValue = (new JunMillisecondModel(99, 59, 59, 990)).milliseconds();
		JunMillisecondModel millisecondModel = new JunMillisecondModel(100, 0, 0, 0);
		millisecondModel.validateBlock_(new StBlockClosure() {
			public Object value_value_(Object oldValue, Object newValue) {
				long value = ((Number) newValue).longValue();
				if (minValue <= value && value <= maxValue) {
					return newValue;
				} else {
					return oldValue;
				}
			}
		});
		millisecondModel.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunMillisecondModelTestExamples();
	}
}
