package jp.co.sra.jun.goodies.milliseconds;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunMillisecondView interface
 * 
 *  @author    nisinaka
 *  @created   2003/05/08 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMillisecondView.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public interface JunMillisecondView extends JunAbstractView {

	/**
	 * The FrameInfo class defines an information for each component of the view.
	 */
	public static class FrameInfo {
		protected StSymbol key;
		protected StSymbol subkey;
		protected StRectangle box;

		public FrameInfo(StSymbol newKey, StSymbol newSubkey, StRectangle newBox) {
			key = newKey;
			subkey = newSubkey;
			box = newBox;
		}

		public FrameInfo(StSymbol newKey, StRectangle newBox) {
			this(newKey, null, newBox);
		}

		public StSymbol key() {
			return key;
		}

		public StSymbol subkey() {
			return subkey;
		}

		public StRectangle box() {
			return box;
		}

		public void displayStringOn_(Graphics aGraphics, String aString) {
			StComposedText text = new StComposedText(aString);
			StRectangle area = new StRectangle(text.bounds());
			area = area.align_with_(area.center(), this.box().center());
			Shape clip = aGraphics.getClip();
			if (clip.intersects(area.toRectangle())) {
				aGraphics.setColor(Color.black);
				text.displayOn_at_(aGraphics, area.origin());
			}
		}

		public void displayLabelOn_(Graphics aGraphics, String aString) {
			StComposedText text = new StComposedText(aString);
			StRectangle area = new StRectangle(text.bounds());
			area = area.align_with_(area.leftCenter(), this.box().leftCenter());
			Shape clip = aGraphics.getClip();
			if (clip.intersects(area.toRectangle())) {
				aGraphics.setColor(Color.black);
				text.displayOn_at_(aGraphics, area.origin());
			}
		}

		public void displayButtonOn_(Graphics aGraphics, boolean directionIsDown) {
			StRectangle area = this.box();
			Shape clip = aGraphics.getClip();
			if (clip.intersects(area.toRectangle())) {
				Point[] points;
				int nPoints;
				int[] xPoints, yPoints;

				if (directionIsDown) {
					points = new Point[] { area.topRight(), area.bottomRight(), area.leftCenter(), area.topRight()};
				} else {
					points = new Point[] { area.topLeft(), area.bottomLeft(), area.rightCenter(), area.topLeft()};
				}
				nPoints = points.length;
				xPoints = new int[nPoints];
				yPoints = new int[nPoints];
				for (int i = 0; i < nPoints; i++) {
					xPoints[i] = points[i].x;
					yPoints[i] = points[i].y;
				}
				aGraphics.setColor(StColorValue.VeryLightGray);
				aGraphics.fillPolygon(xPoints, yPoints, nPoints);

				area = area.insetBy_(new StRectangle(1, 1, 2, 2));
				if (directionIsDown) {
					points = new Point[] { area.topRight(), area.bottomRight(), area.leftCenter(), area.topRight()};
				} else {
					points = new Point[] { area.topLeft(), area.bottomLeft(), area.rightCenter(), area.topLeft()};
				}
				nPoints = points.length;
				xPoints = new int[nPoints];
				yPoints = new int[nPoints];
				for (int i = 0; i < nPoints; i++) {
					xPoints[i] = points[i].x;
					yPoints[i] = points[i].y;
				}
				aGraphics.setColor(StColorValue.VeryDarkGray);
				aGraphics.drawPolyline(xPoints, yPoints, nPoints);
			}
		}
	}

	/**
	 * Answer the array of FrameInfo for each component on the view.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo[]
	 */
	public JunMillisecondView.FrameInfo[] frames();

	/**
	 * Answer my model as JunMillisecondModel.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel
	 */
	public JunMillisecondModel getMillisecondModel();

}
