package jp.co.sra.jun.goodies.milliseconds;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import javax.swing.JPopupMenu;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMillisecondViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/05/28 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2005/03/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMillisecondViewSwing.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMillisecondViewSwing extends JunAbstractViewJPanel implements JunMillisecondView {

	protected JunMillisecondView.FrameInfo[] frames;
	protected JPopupMenu _popupMenu;

	/**
	 * Create a new instance of JunMillisecondViewSwing and initialize it.
	 *
	 * @param aMillisecondModel jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel
	 */
	public JunMillisecondViewSwing(JunMillisecondModel aMillisecondModel) {
		super(aMillisecondModel);
	}

	/**
	 * Paints this component.
	 * 
	 * @param aGraphics java.awt.Graphics
	 */
	public void displayOn_(Graphics aGraphics) {
		if (this.isShowing() == false) {
			return;
		}

		this.displayBordersOn_(aGraphics);
		this.displayObjectsOn_(aGraphics);
	}

	/**
	 * Answer the array of FrameInfo for each component on the view.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo[]
	 */
	public JunMillisecondView.FrameInfo[] frames() {
		if (frames == null) {
			this.makeFrames();
		}
		return frames;
	}

	/**
	 * Answer my model as JunMillisecondModel.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel
	 */
	public JunMillisecondModel getMillisecondModel() {
		return (JunMillisecondModel) this.model();
	}

	/**
	 * Moves and resizes this component.
	 * Override to make new frames.
	 *
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 */
	public void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);
		this.makeFrames();
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument anAspectSymbol is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		if (evt.getAspect() == $("value")) {
			repaint();
			return;
		}

		super.update_(evt);
	}

	/**
	 * Build this component.
	 */
	protected void buildComponent() {
		this.setPreferredSize(new Dimension(150, 100));
	}

	/**
	 * Answer my default controller. Subclasses may override this.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 */
	protected StController defaultController() {
		return new JunMillisecondController();
	}

	/**
	 * Display my borders on the graphics.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	protected void displayBordersOn_(Graphics aGraphics) {
		Shape clip = aGraphics.getClip();
		JunMillisecondView.FrameInfo[] info = this.frames();
		for (int i = 0; i < info.length; i++) {
			StSymbol key = info[i].key();
			if (key == $("hours") || key == $("minutes") || key == $("seconds") || key == $("msecs")) {
				StRectangle box = info[i].box();
				if (clip.intersects(box.toRectangle())) {
					aGraphics.setColor(StColorValue.VeryLightGray);
					aGraphics.fillRect(box.x(), box.y(), box.width(), box.height());
					StRectangle area = box.insetBy_(new StRectangle(1, 1, 2, 2));
					aGraphics.setColor(StColorValue.VeryDarkGray);
					aGraphics.drawRect(area.x(), area.y(), area.width(), area.height());
					area = box.insetBy_(new StRectangle(2, 2, 3, 3));
					aGraphics.setColor(StColorValue.Black);
					aGraphics.drawRect(area.x(), area.y(), area.width(), area.height());
				}
			}
		}
	}

	/**
	 * Display my objects on the graphcis.
	 *
	 * @param aGraphics java.awt.Graphics
	 */
	protected void displayObjectsOn_(Graphics aGraphics) {
		JunMillisecondView.FrameInfo[] info = this.frames();
		for (int i = 0; i < info.length; i++) {
			StSymbol key = info[i].key();
			if (key == $("hours")) {
				String aString = String.valueOf(this.getMillisecondModel().hours());
				while (aString.length() < 2) {
					aString = "0" + aString;
				}
				info[i].displayStringOn_(aGraphics, aString);
			} else if (key == $("minutes")) {
				String aString = String.valueOf(this.getMillisecondModel().minutes());
				while (aString.length() < 2) {
					aString = "0" + aString;
				}
				info[i].displayStringOn_(aGraphics, aString);
			} else if (key == $("seconds")) {
				String aString = String.valueOf(this.getMillisecondModel().seconds());
				while (aString.length() < 2) {
					aString = "0" + aString;
				}
				info[i].displayStringOn_(aGraphics, aString);
			} else if (key == $("msecs")) {
				String aString = String.valueOf(this.getMillisecondModel().msecs());
				while (aString.length() < 3) {
					aString = "0" + aString;
				}
				info[i].displayStringOn_(aGraphics, aString);
			} else if (key == $("label")) {
				info[i].displayLabelOn_(aGraphics, info[i].subkey().toString());
			} else if (key == $("button")) {
				StSymbol subkey = info[i].subkey();
				if (subkey == $("hourDown") || subkey == $("minuteDown") || subkey == $("secondDown") || subkey == $("msecDown")) {
					info[i].displayButtonOn_(aGraphics, true);
				} else {
					info[i].displayButtonOn_(aGraphics, false);
				}
			}
		}
	}

	/**
	 * Initialize the receiver.
	 */
	protected void initialize() {
		super.initialize();
		frames = null;
	}

	/**
	 * Make frame information of all components on the view.
	 */
	protected void makeFrames() {
		JunMillisecondView.FrameInfo[] collection = new JunMillisecondView.FrameInfo[16];

		Dimension size = this.getSize();
		int width = size.width / 10;
		int height = size.height / 4;
		StRectangle button = new StRectangle(0, 0, 12, 16);

		int x, y;
		StRectangle box;

		// #label 'hours:'
		x = width * 0;
		y = height * 0;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(width * 4, height)).insetBy_(new StRectangle(8, 0, 0, 0));
		collection[0] = new JunMillisecondView.FrameInfo($("label"), $(JunSystem.$String("hours:")), box);

		// #hours
		x = Math.round(width * 4.5f);
		y = height * 0;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(Math.round(width * 5.5f), height)).insetBy_(new StRectangle(button.width(), 0, button.width() + 8, 0));
		collection[1] = new JunMillisecondView.FrameInfo($("hours"), box);

		// #button #hourDown
		button = button.align_with_(button.rightCenter(), box.leftCenter());
		collection[2] = new JunMillisecondView.FrameInfo($("button"), $("hourDown"), button);

		// #button #hourUp
		button = button.align_with_(button.leftCenter(), box.rightCenter());
		collection[3] = new JunMillisecondView.FrameInfo($("button"), $("hourUp"), button);

		// #label 'minutes:'
		x = width * 0;
		y = height * 1;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(width * 4, height)).insetBy_(new StRectangle(8, 0, 0, 0));
		collection[4] = new JunMillisecondView.FrameInfo($("label"), $(JunSystem.$String("minutes:")), box);

		// #minutes
		x = Math.round(width * 4.5f);
		y = height * 1;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(Math.round(width * 5.5f), height)).insetBy_(new StRectangle(button.width(), 0, button.width() + 8, 0));
		collection[5] = new JunMillisecondView.FrameInfo($("minutes"), box);

		// #button #minuteDown
		button = button.align_with_(button.rightCenter(), box.leftCenter());
		collection[6] = new JunMillisecondView.FrameInfo($("button"), $("minuteDown"), button);

		// #button #minuteUp
		button = button.align_with_(button.leftCenter(), box.rightCenter());
		collection[7] = new JunMillisecondView.FrameInfo($("button"), $("minuteUp"), button);

		// #label 'seconds:'
		x = width * 0;
		y = height * 2;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(width * 4, height)).insetBy_(new StRectangle(8, 0, 0, 0));
		collection[8] = new JunMillisecondView.FrameInfo($("label"), $(JunSystem.$String("seconds:")), box);

		// #seconds
		x = Math.round(width * 4.5f);
		y = height * 2;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(Math.round(width * 5.5f), height)).insetBy_(new StRectangle(button.width(), 0, button.width() + 8, 0));
		collection[9] = new JunMillisecondView.FrameInfo($("seconds"), box);

		// #button #secondDown
		button = button.align_with_(button.rightCenter(), box.leftCenter());
		collection[10] = new JunMillisecondView.FrameInfo($("button"), $("secondDown"), button);

		// #button #secondUp
		button = button.align_with_(button.leftCenter(), box.rightCenter());
		collection[11] = new JunMillisecondView.FrameInfo($("button"), $("secondUp"), button);

		// #label 'msecs:'
		x = width * 0;
		y = height * 3;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(width * 4, height)).insetBy_(new StRectangle(8, 0, 0, 0));
		collection[12] = new JunMillisecondView.FrameInfo($("label"), $(JunSystem.$String("msecs:")), box);

		// #msecs
		x = Math.round(width * 4.5f);
		y = height * 3;
		box = StRectangle.Origin_extent_(new Point(x, y), new Point(Math.round(width * 5.5f), height)).insetBy_(new StRectangle(button.width(), 0, button.width() + 8, 0));
		collection[13] = new JunMillisecondView.FrameInfo($("msecs"), box);

		// #button #msecDown
		button = button.align_with_(button.rightCenter(), box.leftCenter());
		collection[14] = new JunMillisecondView.FrameInfo($("button"), $("msecDown"), button);

		// #button #msecUp
		button = button.align_with_(button.leftCenter(), box.rightCenter());
		collection[15] = new JunMillisecondView.FrameInfo($("button"), $("msecUp"), button);

		//
		frames = collection;
	}
}
