package jp.co.sra.jun.goodies.misc;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.goodies.display.JunDisplayModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunSampleTriangleTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/10/15 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun500 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSampleTriangleTestExamples.java,v 8.12 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunSampleTriangleTestExamples extends JunTestExamples {
	/**
	 * Example1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunSampleTriangle aTriangle = new JunSampleTriangle(new Jun2dPoint(10, -10), new Jun2dPoint(0, 10), new Jun2dPoint(-10, -10));
		aTriangle = aTriangle.scaledBy_(2);
		aTriangle = aTriangle.translatedBy_(new Jun2dPoint(100, 100));

		Frame aFrame = new Frame();
		aFrame.setTitle("JunSampleTriangleTestExamples");
		aFrame.setLayout(new BorderLayout());
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		final JunSampleTriangle _aTriangle = aTriangle;
		Canvas newCanvas = new Canvas() {
			public void paint(Graphics aGraphics) {
				_aTriangle.displayStrokedOn_(aGraphics);
				return;
			}
		};
		newCanvas.setBounds(0, 0, 200, 200);
		aFrame.add(newCanvas);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		return true;
	}

	/**
	 * Example2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunSampleTriangle aTriangle = new JunSampleTriangle(new Jun2dPoint(10, -10), new Jun2dPoint(0, 10), new Jun2dPoint(-10, -10));
		aTriangle = aTriangle.scaledBy_(2);
		aTriangle = aTriangle.translatedBy_(new Jun2dPoint(100, 100));

		Frame aFrame = new Frame();
		aFrame.setTitle("JunSampleTriangleTestExamples");
		aFrame.setLayout(new BorderLayout());
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		final JunSampleTriangle _aTriangle = aTriangle;
		Canvas newCanvas = new Canvas() {
			public void paint(Graphics aGraphics) {
				_aTriangle.displayFilledOn_(aGraphics);
				return;
			}
		};
		newCanvas.setBounds(0, 0, 200, 200);
		aFrame.add(newCanvas);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		return true;
	}

	/**
	 * Example3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunSampleTriangle aTriangle = new JunSampleTriangle(new Jun2dPoint(10, -10), new Jun2dPoint(0, 10), new Jun2dPoint(-10, -10));
		aTriangle = aTriangle.scaledBy_(2);
		aTriangle = aTriangle.translatedBy_(new Jun2dPoint(100, 100));

		Frame aFrame = new Frame();
		aFrame.setTitle("JunSampleTriangleTestExamples");
		aFrame.setLayout(new BorderLayout());
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		final JunSampleTriangle _aTriangle = aTriangle;
		Canvas newCanvas = new Canvas() {
			public void paint(Graphics aGraphics) {
				aGraphics.setColor(Color.cyan);
				Jun2dBoundingBox bounds = _aTriangle.bounds();
				aGraphics.fillRect((int) Math.round(bounds.origin().x()), (int) Math.round(bounds.origin().y()), (int) Math.round(bounds.width()), (int) Math.round(bounds.height()));
				aGraphics.setColor(Color.magenta);
				aGraphics.drawRect((int) Math.round(bounds.origin().x()), (int) Math.round(bounds.origin().y()), (int) Math.round(bounds.width()), (int) Math.round(bounds.height()));
				aGraphics.setColor(Color.green);
				_aTriangle.displayFilledOn_(aGraphics);
				aGraphics.setColor(Color.blue);
				_aTriangle.displayStrokedOn_(aGraphics);
				return;
			}
		};
		newCanvas.setBounds(0, 0, 200, 200);
		aFrame.add(newCanvas);
		aFrame.pack();
		StApplicationModel._ShowAtMousePoint(aFrame);

		return true;
	}

	/**
	 * Example5.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		StImage anImage = JunSampleTriangle.Aoki();
		JunDisplayModel aModel = new JunDisplayModel(anImage);
		aModel.openAt_(new Point(200, 200));

		return true;
	}

	/**
	 * Example6.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		StImage anImage = JunSampleTriangle.Mickey();
		JunDisplayModel aModel = new JunDisplayModel(anImage);
		aModel.openAt_(new Point(200, 200));

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunSampleTriangleTestExamples();
	}
}
