package jp.co.sra.jun.goodies.movie.framework;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.im.InputContext;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.qt4jun.JunQTPort;

import jp.co.sra.jun.goodies.button.JunButtonViewAwt;
import jp.co.sra.jun.goodies.button.JunButtonWithMenuViewAwt;
import jp.co.sra.jun.goodies.track.JunTrackSliderViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMovieViewAwt class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2001/01/24 (by NISHIHARA Satoshi)
 *  @updated   2002/11/11 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2005/03/03 (by nisinaka)
 *  @updated   2006/04/21 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun523 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMovieViewAwt.java,v 8.11 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMovieViewAwt extends JunAbstractViewPanel implements JunMovieView {

	protected JunTrackSliderViewAwt sliderView;
	protected JunTrackSliderViewAwt sliderView2;
	protected JunButtonViewAwt firstButtonView;
	protected JunButtonViewAwt lastButtonView;
	protected JunButtonViewAwt previousButtonView;
	protected JunButtonViewAwt nextButtonView;
	protected JunButtonViewAwt loopButtonView;
	protected JunButtonViewAwt playButtonView;
	protected JunButtonViewAwt firstMarkerButtonView;
	protected JunButtonViewAwt lastMarkerButtonView;
	protected JunButtonWithMenuViewAwt speakerButtonView;
	protected PopupMenu _popupMenu;
	protected boolean inited = false;

	/**
	 * Create a new instance of JunMovieViewAwt and initialize it.
	 * 
	 * @param aMoviePlayer jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @category Instance creation
	 */
	public JunMovieViewAwt(JunMoviePlayer aMoviePlayer) {
		super(aMoviePlayer);
	}

	/**
	 * Create a new view for the JunMoviePlayer.
	 * The view consists of a JunMovieView and two trackers.
	 * 
	 * @param aMoviePlayer jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @return jp.co.sra.smalltalk.StView
	 * @category Utilities
	 */
	public static StView WithDoubleTracker(JunMoviePlayer aMoviePlayer) {
		return new StViewPanel(aMoviePlayer) {

			protected JunMovieViewAwt movieView;

			protected JunMovieViewAwt movieView() {
				if (movieView == null) {
					movieView = new JunMovieViewAwt((JunMoviePlayer) this.model());
				}
				return movieView;
			}

			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.movieView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -39));
				this.add(this.movieView().sliderView(), WindowSpecLayout.Position(0f, 96, 1f, -19, 1f, -96, 1f, -1));
				this.add(this.movieView().sliderView2(), WindowSpecLayout.Position(0f, 1, 1f, -38, 1f, -1, 1f, -20));
				this.add(this.movieView().speakerButtonView(), WindowSpecLayout.Position(0f, 1, 1f, -19, 0f, 19, 1f, -1));
				this.add(this.movieView().firstButtonView(), WindowSpecLayout.Position(0f, 20, 1f, -19, 0f, 38, 1f, -1));
				this.add(this.movieView().lastButtonView(), WindowSpecLayout.Position(0f, 39, 1f, -19, 0f, 57, 1f, -1));
				this.add(this.movieView().previousButtonView(), WindowSpecLayout.Position(0f, 58, 1f, -19, 0f, 76, 1f, -1));
				this.add(this.movieView().nextButtonView(), WindowSpecLayout.Position(0f, 77, 1f, -19, 0f, 95, 1f, -1));
				this.add(this.movieView().loopButtonView(), WindowSpecLayout.Position(1f, -95, 1f, -19, 1f, -77, 1f, -1));
				this.add(this.movieView().playButtonView(), WindowSpecLayout.Position(1f, -76, 1f, -19, 1f, -58, 1f, -1));
				this.add(this.movieView().firstMarkerButtonView(), WindowSpecLayout.Position(1f, -57, 1f, -19, 1f, -39, 1f, -1));
				this.add(this.movieView().lastMarkerButtonView(), WindowSpecLayout.Position(1f, -38, 1f, -19, 1f, -20, 1f, -1));
				this.setSize(260, 180);
			}

			public void _setupKeyboard(Window aWindow) {
				this.movieView()._setupKeyboard(aWindow);
			}
		};
	}

	/**
	 * Create a new view for the JunMoviePlayer.
	 * The view consists of a JunMovieView and no tracker.
	 * 
	 * @param aMoviePlayer jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @return jp.co.sra.smalltalk.StView
	 * @category Utilities
	 */
	public static StView WithoutTracker(JunMoviePlayer aMoviePlayer) {
		return new StViewPanel(aMoviePlayer) {

			protected JunMovieViewAwt movieView;

			protected JunMovieViewAwt movieView() {
				if (movieView == null) {
					movieView = new JunMovieViewAwt((JunMoviePlayer) this.model());
				}
				return movieView;
			}

			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.movieView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -1));
				this.setSize(260, 180);
			}

			public void _setupKeyboard(Window aWindow) {
				this.movieView()._setupKeyboard(aWindow);
			}
		};
	}

	/**
	 * Create a new view for the JunMoviePlayer.
	 * The view consists of a JunMovieView and a tracker.
	 * 
	 * @param aMoviePlayer jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @return jp.co.sra.smalltalk.StView
	 * @category Utilities
	 */
	public static StView WithTracker(JunMoviePlayer aMoviePlayer) {
		return new StViewPanel(aMoviePlayer) {

			protected JunMovieViewAwt movieView;

			protected JunMovieViewAwt movieView() {
				if (movieView == null) {
					movieView = new JunMovieViewAwt((JunMoviePlayer) this.model());
				}
				return movieView;
			}

			protected void buildComponent() {
				this.setLayout(new WindowSpecLayout());
				this.add(this.movieView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -20));
				this.add(this.movieView().sliderView(), WindowSpecLayout.Position(0f, 58, 1f, -19, 1f, -58, 1f, -1));
				this.add(this.movieView().speakerButtonView(), WindowSpecLayout.Position(0f, 1, 1f, -19, 0f, 19, 1f, -1));
				this.add(this.movieView().previousButtonView(), WindowSpecLayout.Position(0f, 20, 1f, -19, 0f, 38, 1f, -1));
				this.add(this.movieView().nextButtonView(), WindowSpecLayout.Position(0f, 39, 1f, -19, 0f, 57, 1f, -1));
				this.add(this.movieView().loopButtonView(), WindowSpecLayout.Position(1f, -57, 1f, -19, 1f, -39, 1f, -1));
				this.add(this.movieView().playButtonView(), WindowSpecLayout.Position(1f, -38, 1f, -19, 1f, -20, 1f, -1));
				this.setSize(260, 180);
			}

			public void _setupKeyboard(Window aWindow) {
				this.movieView()._setupKeyboard(aWindow);
			}
		};
	}

	/**
	 * Answer my model as a JunMoviePlayer.
	 * 
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#getMoviePlayer()
	 * @category accessing
	 */
	public JunMoviePlayer getMoviePlayer() {
		return (JunMoviePlayer) this.model();
	}

	/**
	 * Answer the current movie handle.
	 * 
	 * @return jp.co.sra.jun.goodies.JunMovieHandle
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#movieHandle()
	 * @category accessing
	 */
	public JunMovieHandle movieHandle() {
		return this.getMoviePlayer().movieHandle();
	}

	/**
	 * Set the bounds of the view. Also needs to set the movie for the new bounds.
	 * 
	 * @param x The new <i>x</i>-coordinate of this component.
	 * @param y The new <i>y</i>-coordinate of this component.
	 * @param width The new <code>width</code> of this component.
	 * @param height The new <code>height</code> of this component.
	 * @see java.awt.Component#setBounds(int, int, int, int)
	 * @category bounds accessing
	 */
	public void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);
		this.setMovieView();
	}

	/**
	 * Answer the receiver's default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		if (JunSystem.IsMacOSX()) {
			return new StController() {
				public void mouseReleased(MouseEvent e) {
					if (e.isPopupTrigger() || e.isMetaDown()) {
						this.view()._showPopupMenu(e.getX(), e.getY());
					}
				}
			};
		} else {
			return super.defaultController();
		}
	}

	/**
	 * Answer my default model.
	 * 
	 * @return jp.co.sra.smalltalk.StModel
	 * @see jp.co.sra.smalltalk.StViewPanel#defaultModel()
	 * @category model accessing
	 */
	protected StModel defaultModel() {
		return new JunMoviePlayer();
	}

	/**
	 * Answer true if the view has a movie, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#hasMovie()
	 * @category testing
	 */
	public boolean hasMovie() {
		return this.getMoviePlayer().hasMovie();
	}

	/**
	 * Answer true if the view has a tracker, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#hasTracker()
	 * @category testing
	 */
	public boolean hasTracker() {
		Object[] dependents = this.getMoviePlayer().trackerModel().dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunTrackSliderViewAwt) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Answer true if the view has a second tracker, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#hasTracker2()
	 * @category testing
	 */
	public boolean hasTracker2() {
		Object[] dependents = this.getMoviePlayer().trackerModel2().dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunTrackSliderViewAwt) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Display the movie.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		if (this.isShowing() == false) {
			return;
		}
		if (this.hasMovie() == false) {
			return;
		}

		if (inited == false) {
			inited = true;
			setMovieView();
		}
		if (this.hasMovie()) {
			this.movieHandle().updateMovie();
			this.movieHandle().doMovieTask();
		}
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category user interface
	 */
	protected void buildComponent() {
		super.setBounds(0, 0, 240, 180);
	}

	/**
	 * Answer my first button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt firstButtonView() {
		if (firstButtonView == null) {
			firstButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().firstButton());
		}
		return firstButtonView;
	}

	/**
	 * Answer my first marker button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt firstMarkerButtonView() {
		if (firstMarkerButtonView == null) {
			firstMarkerButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().firstMarkerButton());
		}
		return firstMarkerButtonView;
	}

	/**
	 * Answer my last button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt lastButtonView() {
		if (lastButtonView == null) {
			lastButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().lastButton());
		}
		return lastButtonView;
	}

	/**
	 * Answer my last marker button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt lastMarkerButtonView() {
		if (lastMarkerButtonView == null) {
			lastMarkerButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().lastMarkerButton());
		}
		return lastMarkerButtonView;
	}

	/**
	 * Create a loop button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt loopButtonView() {
		if (loopButtonView == null) {
			loopButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().loopButton());
		}
		return loopButtonView;
	}

	/**
	 * Create a next button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt nextButtonView() {
		if (nextButtonView == null) {
			nextButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().nextButton());
		}
		return nextButtonView;
	}

	/**
	 * Answer my play button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt playButtonView() {
		if (playButtonView == null) {
			playButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().playButton());
		}
		return playButtonView;
	}

	/**
	 * Answer my previous button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewAwt
	 * @category user interface
	 */
	public JunButtonViewAwt previousButtonView() {
		if (previousButtonView == null) {
			previousButtonView = new JunButtonViewAwt(this.getMoviePlayer().trackerModel().previousButton());
		}
		return previousButtonView;
	}

	/**
	 * Answer my speaker button view.
	 * 
	 * @return jp.co.sra.jun.goodies.button.JunButtonWithMenuViewAwt
	 * @category user interface
	 */
	public JunButtonWithMenuViewAwt speakerButtonView() {
		if (speakerButtonView == null) {
			speakerButtonView = new JunButtonWithMenuViewAwt(this.getMoviePlayer().trackerModel().speakerButton());
		}
		return speakerButtonView;
	}

	/**
	 * Answer my first slider view.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunTrackSliderViewAwt
	 * @category user interface
	 */
	public JunTrackSliderViewAwt sliderView() {
		if (sliderView == null) {
			sliderView = new JunTrackSliderViewAwt(this.getMoviePlayer().trackerModel());
		}
		return sliderView;
	}

	/**
	 * Answer my second slider view.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunTrackSliderViewAwt
	 * @category user interface
	 */
	public JunTrackSliderViewAwt sliderView2() {
		if (sliderView2 == null) {
			sliderView2 = new JunTrackSliderViewAwt(this.getMoviePlayer().trackerModel2());
		}
		return sliderView2;
	}

	/**
	 * Show the popup menu at the specified point on the view.
	 * 
	 * @param x int
	 * @param y int
	 * @see jp.co.sra.smalltalk.StView#_showPopupMenu(int, int)
	 * @category popup menu accessing
	 */
	public void _showPopupMenu(int x, int y) {
		this.getMoviePlayer()._updatePopupMenu();
		super._showPopupMenu(x, y);
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(final Window aWindow) {
		this.addKeyListener(this.getMoviePlayer()._keyListener());

		if (this.hasTracker()) {
			this.firstButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.firstMarkerButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.lastButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.lastMarkerButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.loopButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.nextButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.playButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.previousButtonView().addKeyListener(this.getMoviePlayer()._keyListener());
			this.sliderView().addKeyListener(this.getMoviePlayer()._keyListener());
		}
		if (this.hasTracker2()) {
			this.sliderView2().addKeyListener(this.getMoviePlayer()._keyListener());
		}

		this.addMouseListener(new MouseAdapter() {
			public void mouseEntered(MouseEvent e) {
				Component focusOwner = aWindow.getFocusOwner();
				if (focusOwner != null && focusOwner != JunMovieViewAwt.this) {
					JunMovieViewAwt.this.requestFocus();
				}
			}
		});

		aWindow.addWindowListener(new WindowAdapter() {
			public void windowActivated(WindowEvent e) {
				Component focusOwner = aWindow.getFocusOwner();
				if (focusOwner == null || focusOwner != JunMovieViewAwt.this) {
					JunMovieViewAwt.this.requestFocus();
				}
			}
		});
	}

	/**
	 * Set the movie view.
	 * 
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#setMovieView()
	 * @category private
	 */
	public void setMovieView() {
		if (this.topComponent() == null) {
			return;
		}

		if (this.hasMovie()) {
			JunQTPort moviePort = this.getMoviePlayer().moviePort(inited);
			if (moviePort != null && inited) {
				this.movieHandle().moviePort_(moviePort);
				Rectangle box = this.movieBox();
				Point offset = new Point(0, 0);
				this.movieHandle().movieBox_(moviePort, box, offset);
				this.movieHandle().active_(true);
			}
		}
	}

	/**
	 * Answer the current area of the movie.
	 * 
	 * @return java.awt.Rectangle
	 * @category private
	 */
	protected Rectangle movieBox() {
		if (this.getMoviePlayer().keepAspect() && this.hasMovie()) {
			Rectangle movieOriginalBox = new Rectangle(new Point(0, 0), this.movieHandle().originalExtent());
			Rectangle movieViewBox = new Rectangle(0, 0, this.getWidth(), this.getHeight());
			return this.getMoviePlayer().AlignRectangle_withRectangle_(movieOriginalBox, movieViewBox);
		}

		return new Rectangle(0, 0, this.getWidth(), this.getHeight());
	}

	/**
	 * Override this method to suppress the following exception when closing.
	 * 
	 * 	java.lang.IllegalStateException: Can't dispose InputContext while it's active
	 * 
	 * @see http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=4289940
	 * @see java.awt.Component#getInputContext()
	 * @category private
	 */
	public InputContext getInputContext() {
		return null;
	}

}
