package jp.co.sra.jun.goodies.movie.support;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.swing.JFrame;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoard;
import jp.co.sra.jun.goodies.bulletinboard.JunBulletinBoardViewSwing;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.utilities.JunImageUtility;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImagesToMovieTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/12/07 (by m-asada)
 *  @updated   2007/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun693 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImagesToMovieTestExamples.java,v 8.16 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunImagesToMovieTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final Rectangle aRectangle = new Rectangle(0, 0, 320, 240);
		final Point aPoint = new Point(4, 3);
		final int tick = 20;
		File aFile = new File("Screen.mov");

		JunImagesToMovie.File_extent_do_(aFile, aRectangle.getSize(), new StBlockClosure() {
			public Object value_(Object anObject) {
				JunImagesToMovie imagesToMovie = (JunImagesToMovie) anObject;

				Rectangle screenBounds = JunSystem.ScreenBoundingBox();
				while (screenBounds.contains(aRectangle)) {
					System.out.println(aRectangle);
					StImage anImage = StImage._OfArea(aRectangle);
					imagesToMovie.add_milliseconds_(anImage, tick);
					aRectangle.translate(aPoint.x, aPoint.y);
				}

				return null;
			}
		});

		JunMoviePlayer aPlayer = new JunMoviePlayer(aFile);
		if (aPlayer == null) {
			return false;
		}
		aPlayer.open();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final Rectangle aRectangle = new Rectangle(0, 0, 320, 240);
		final Point aPoint = new Point(4, 3);
		final int tick = 20;
		Dimension screenSize = JunSystem.ScreenBoundingBox().getSize();
		Dimension aBox = new Dimension(screenSize.width - aRectangle.width, screenSize.height - aRectangle.height);
		final int howMany = Math.min(aBox.width / aPoint.x, aBox.height / aPoint.y);
		File aFile = new File("Screen.mov");

		final JunImagesToMovie imagesToMovie = new JunImagesToMovie(aFile, new Dimension(180, 120));
		imagesToMovie.do_(new StBlockClosure() {
			public Object value() {
				imagesToMovie.background_(Color.gray);
				for (int i = 0; i < howMany; i++) {
					System.out.print(i);
					System.out.print(' ');
					System.out.println("(" + aRectangle + ")");
					StImage anImage = StImage._OfArea(aRectangle);
					imagesToMovie.add_milliseconds_(anImage, tick);
					aRectangle.translate(aPoint.x, aPoint.y);
				}

				return null;
			}
		});

		JunMoviePlayer aMovie = new JunMoviePlayer(aFile);
		if (aMovie == null) {
			return false;
		}
		aMovie.open();

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final JunBulletinBoard aModel = new JunBulletinBoard();
		String aString = "Eclipse VisualJ++ VisualAge ...";
		for (int i = 0; i < aString.length(); i++) {
			aModel.color_(new Color(Color.HSBtoRGB(i / (float) aString.length(), 1f, 1f)));
			aModel.add_(aString.charAt(i));
		}
		final JunBulletinBoardViewSwing aView = new JunBulletinBoardViewSwing(aModel);
		aView.controller_(null);

		JFrame aFrame = new JFrame();
		aFrame.getContentPane().add(aView);
		aFrame.setResizable(false);
		aFrame.setBounds(100, 250, 200, 74);
		aFrame.pack();
		aFrame.setVisible(true);

		final Rectangle aRectangle = new Rectangle(aView.getLocationOnScreen().x, aView.getLocationOnScreen().y, aView.getWidth(), aView.getHeight());
		File aFile = new File("BulletinBoard.mov");

		JunImagesToMovie.File_extent_do_(aFile, aRectangle.getSize(), new StBlockClosure() {
			public Object value_(Object anObject) {
				JunImagesToMovie imagesToMovie = (JunImagesToMovie) anObject;

				for (int i = 0; i < (aModel.width() + aView.getWidth()) / aView.displaySpeed(); i++) {
					BufferedImage anImage = JunImageUtility.FromDisplay_(aRectangle);
					imagesToMovie.add_(new StImage(anImage));
					aView.repaint();
				}

				return null;
			}
		});

		aFrame.setVisible(false);
		aFrame.invalidate();

		JunMoviePlayer aPlayer = new JunMoviePlayer(aFile);
		if (aPlayer == null) {
			return false;
		}
		aPlayer.open();

		return true;
	}

	/**
	 * Example4:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		File aDirectory = JunFileRequesterDialog.RequestDirectory($String("Select a directory."));
		if (aDirectory == null) {
			return false;
		}

		String aString = "*.jpg";
		int aNumber = 15;
		String aFilename = new File("ImageSequence.mov").getAbsolutePath();
		try {
			JunImagesToMovie.ImageSequenceDirectory_jpegImageFileNamePattern_framesPerSecond_movieFile_(aDirectory, aString, aNumber, new File(aFilename));
		} catch (IOException e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
			return false;
		}

		JunMoviePlayer aPlayer = new JunMoviePlayer(new File(aFilename));
		if (aPlayer == null) {
			return false;
		}
		aPlayer.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunImagesToMovieTestExamples();
	}

}
