package jp.co.sra.jun.goodies.multimedia;

import java.io.File;

import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMultiMediaTextModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaTextModelTestExamples.java,v 8.12 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaTextModelTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * Example1: Open a JunMultiMediaViewer.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] { new JunFileModel.FileType(JunSystem.$String("<1p> files", null, JunSystem.$String("Text")), JunSystem.DefaultTextExtensionPatterns()), JunFileModel.FileType.All(JunSystem.$String("All files"))};
		File aFile = JunFileRequesterDialog.Request(JunSystem.$String("Select a <1p> file.", null, JunSystem.$String("Text")), fileTypes, fileTypes[0]);
		if (aFile == null) {
			return false;
		}

		JunMultiMediaTextModel textModel = new JunMultiMediaTextModel(aFile);
		textModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunMultiMediaTextModelTestExamples();
	}
}
