package jp.co.sra.jun.goodies.nib;

import java.awt.Color;
import java.io.StringWriter;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunNibChoiceDialogTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/23 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceDialogTestExamples.java,v 8.11 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceDialogTestExamples extends JunTestExamples {

	/**
	 * Example1: open nib choice dialog
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Object answer = JunNibChoiceDialog.Request();
		if (answer == null) {
			return true;
		}
		Object[] anArray = (Object[]) answer;
		PrintAnswer(anArray);
		return true;
	}

	/**
	 * Example2: open nib choice dialog
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Object answer = JunNibChoiceDialog.Request(JunSystem.$String("Select nib."));
		if (answer == null) {
			return true;
		}
		Object[] anArray = (Object[]) answer;
		PrintAnswer(anArray);
		return true;
	}

	/**
	 * Example3: open nib choice dialog
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		double[] nibCollection = new double[] { 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25 };
		Object[] valueArray = new Object[] { nibCollection, new Double(13), Color.blue, $("circle")};
		Object answer = JunNibChoiceDialog.Request(JunSystem.$String("Select nib."), valueArray);
		if (answer == null) {
			return true;
		}
		Object[] anArray = (Object[]) answer;
		PrintAnswer(anArray);
		return true;
	}

	/**
	 * Example4: open nib choice dialog
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		double[] nibCollection = new double[] { 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25 };
		JunNibChoice nibChoice = new JunNibChoice(nibCollection, 13, Color.red, $("circle"));
		Object answer = JunNibChoiceDialog.Request(JunSystem.$String("Select nib."), nibChoice);
		if (answer == null) {
			return true;
		}
		Object[] anArray = (Object[]) answer;
		PrintAnswer(anArray);
		return true;
	}

	/**
	 * Example5: open nib choice dialog
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		double[] nibCollection = new double[] { 1, 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25 };
		JunNibChoice nibChoice = new JunNibChoice(nibCollection, 13, Color.red, $("circle"));
		StBlockClosure acceptBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				JunNibChoice model = (JunNibChoice) anObject;
				System.out.println(JunSystem.$String("Accept button was pressed."));
				PrintAnswer((Object[]) model.value());
				return Boolean.TRUE;
			}
		};
		StBlockClosure cancelBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				JunNibChoice model = (JunNibChoice) anObject;
				System.out.println(JunSystem.$String("Cancel button was pressed."));
				PrintAnswer((Object[]) model.value());
				return Boolean.TRUE;
			}
		};
		Object answer = JunNibChoiceDialog.Request(JunSystem.$String("Select nib."), nibChoice, acceptBlock, cancelBlock);
		if (answer == null) {
			return true;
		}
		Object[] anArray = (Object[]) answer;
		PrintAnswer(anArray);
		return true;
	}

	/**
	 * Print the answer to System.out. 
	 * 
	 * @param answer java.lang.Object[]
	 * @category Private
	 */
	private static void PrintAnswer(Object[] answer) {
		double[] nibCollection = (double[]) answer[0];
		Double nibWidth = (Double) answer[1];
		Color nibColor = (Color) answer[2];
		StSymbol nibShape = (StSymbol) answer[3];
		StringWriter writer = new StringWriter();
		for (int i = 0; i < nibCollection.length; i++) {
			if (i == 0) {
				writer.write("(");
			} else {
				writer.write(" ");
			}
			writer.write(String.valueOf(nibCollection[i]));
		}
		writer.write(") ");
		writer.write(nibWidth.toString());
		writer.write(" ");
		writer.write("(r=");
		writer.write(String.valueOf(nibColor.getRed()));
		writer.write(",g=");
		writer.write(String.valueOf(nibColor.getGreen()));
		writer.write(",b=");
		writer.write(String.valueOf(nibColor.getBlue()));
		writer.write(",a=");
		writer.write(String.valueOf(nibColor.getAlpha()));
		writer.write(") ");
		writer.write(nibShape.toString());
		System.out.println(writer.toString());
	}

	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunNibChoiceDialogTestExamples();
	}

}
