package jp.co.sra.jun.goodies.nib;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunNibChoiceWithColorDialogViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/26 (By Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceWithColorDialogViewSwing.java,v 8.10 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceWithColorDialogViewSwing extends StSimpleDialogViewSwing implements JunNibChoiceWithColorDialogView {

	protected JunNibChoiceWithColorViewSwing nibChoiceView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create instance.
	 * @param aModel jp.co.sra.jun.goodies.nib.JunNibChoiceWithColorDialog
	 * 
	 * @category Instance creation
	 */
	public JunNibChoiceWithColorDialogViewSwing(JunNibChoiceWithColorDialog aModel) {
		super(aModel);
	}

	/**
	 * Answer my model as a JunNibChoiceWithColorDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunNibChoiceWithColorDialog
	 * @category model accessing
	 */
	public JunNibChoiceWithColorDialog getNibChoiceDialog() {
		return (JunNibChoiceWithColorDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.nibChoiceView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -50));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.25f, -44, 1f, -40, 0.25f, 44, 1f, -8));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.75f, -44, 1f, -40, 0.75f, 44, 1f, -8));
		defaultButton = this.acceptButton();
		this.setPreferredSize(new Dimension(238, 227));
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getNibChoiceDialog().acceptButtonPressed()) {
						getNibChoiceDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category interface opening
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getNibChoiceDialog().cancelButtonPressed()) {
						getNibChoiceDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my nib choice view.
	 *
	 * @return jp.co.sra.smalltalk.StViewPanel
	 * @category interface opening
	 */
	protected JunNibChoiceWithColorViewSwing nibChoiceView() {
		if (nibChoiceView == null) {
			nibChoiceView = new JunNibChoiceWithColorViewSwing(this.getNibChoiceDialog().nibChoiceWithColorModel());
		}
		return nibChoiceView;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.nibChoiceView()._setupKeyboard(aWindow);
	}

}
