package jp.co.sra.jun.goodies.nib;

import java.awt.Dimension;
import java.awt.Window;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunNibChoiceWithColorViewSwing class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2004/03/26 (By Nobuto Matsubara)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun538 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunNibChoiceWithColorViewSwing.java,v 8.10 2008/02/20 06:31:51 nisinaka Exp $
 */
public class JunNibChoiceWithColorViewSwing extends JunAbstractViewJPanel implements JunNibChoiceWithColorView {

	protected JunColorChoiceViewSwing colorChoiceView;
	protected StViewJPanel nibChoiceView;

	/**
	 * Create a new instance of JunNibChoiceWithColorViewSwing and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.goodies.nib.JunNibChoiceWithColorViewSwing
	 * @category Instance creation
	 */
	public JunNibChoiceWithColorViewSwing(JunNibChoiceWithColor aModel) {
		super(aModel);
	}

	/**
	 * Answer my model as JunNibChoiceWithColor.
	 * 
	 * @return jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor
	 * @see jp.co.sra.jun.goodies.nib.JunNibChoiceWithColorView#getNibChoiceWithColor()
	 * @category model accessing
	 */
	public JunNibChoiceWithColor getNibChoiceWithColor() {
		return (JunNibChoiceWithColor) this.model();
	}

	/**
	 * Build component.
	 * 
	 * @category interface opening
	 */
	public void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.nibChoiceView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -128));
		this.add(this.colorChoiceView(), WindowSpecLayout.Position(0f, 1, 1f, -127, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(234, 182));
	}

	/**
	 * Answer a color choice view.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceView
	 * @category user interface
	 */
	public JunColorChoiceViewSwing colorChoiceView() {
		if (colorChoiceView == null) {
			colorChoiceView = new JunColorChoiceViewSwing(this.getNibChoiceWithColor().colorModel());
		}
		return colorChoiceView;
	}

	/**
	 * Answer a nib choice view.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceView
	 * @category user interface
	 */
	public StViewJPanel nibChoiceView() {
		if (nibChoiceView == null) {
			nibChoiceView = (StViewJPanel) JunNibChoiceViewSwing.WithSlider(this.getNibChoiceWithColor());
		}
		return nibChoiceView;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.nibChoiceView()._setupKeyboard(aWindow);
	}

}
