package jp.co.sra.jun.goodies.parameter;

import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunParametersModel class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/12/11 (by MATSUDA Ryouichi)
 *  @updated   2003/01/16 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParametersModel.java,v 8.11 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunParametersModel extends JunApplicationModel {

	protected JunParameter[] parameters;

	/**
	 * Create a new instance of <code>JunParametersModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunParametersModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunParametersModel</code> and initialize it.
	 * 
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameter.JunParameter[]
	 * @category Instance creation
	 */
	public JunParametersModel(JunParameter[] anArrayOfParameters) {
		this();
		this.parameters_(anArrayOfParameters);
	}

	/**
	 * Create a new instance of JunParametersModel and set Parameters.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterModel
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameter.JunParameter[]
	 * @deprecated since Jun379, use the constructor.
	 * @category Instance creation
	 */
	public static JunParametersModel On_(JunParameter[] anArrayOfParameters) {
		return new JunParametersModel(anArrayOfParameters);
	}

	/**
	 * Create a new instance of JunParametersModel and set Parameters and open it.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterModel
	 * @param anArrayOfParameters jp.co.sra.jun.goodies.parameter.JunParameter[]
	 * @category Instance creation
	 */
	public static JunParametersModel OpenOnParameters_(JunParameter[] anArrayOfParameters) {
		JunParametersModel aParametersModel = new JunParametersModel(anArrayOfParameters);
		aParametersModel.open();
		return aParametersModel;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunParametersViewAwt(this);
		} else {
			return new JunParametersViewSwing(this);
		}
	}

	/**
	 * Answer my current parameters.
	 *
	 * @return jp.co.sra.jun.goodies.parameter.JunParameter[]
	 * @category accessing
	 */
	public JunParameter[] parameters() {
		if (parameters == null) {
			parameters = new JunParameter[0];
		}
		return parameters;
	}

	/**
	 * Set my new parameters.
	 *
	 * @param newParameters jp.co.sra.jun.goodies.parameter.JunParameter[]
	 * @category accessing
	 */
	public void parameters_(JunParameter[] newParameters) {
		parameters = newParameters;
		this.buildComposite();
	}

	/**
	 * Build the composite.
	 * 
	 * @category private
	 */
	protected void buildComposite() {
		this.changed_($("build"));
	}

	/**
	 * Initialize this object.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		parameters = null;
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Parameter Model");
	}
}
