package jp.co.sra.jun.goodies.pen;

/**
 * JunPenAngle class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1999/1/5 (by Hirotsugu Kondo)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPenAngle.java,v 8.11 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunPenAngle extends JunPenGeometry {
	private double deg = Double.NaN;
	private double rad = Double.NaN;
	private double sin = Double.NaN;
	private double cos = Double.NaN;
	private double tan = Double.NaN;

	/**
	 * Create a new instance of <code>JunPenAngle</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunPenAngle() {
		super();
		this.deg = 0.0d;
		this.rad = Double.NaN;
		this.sin = Double.NaN;
		this.cos = Double.NaN;
		this.tan = Double.NaN;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anObject DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenAngle Coerce_(Object anObject) {
		if (anObject.getClass() == JunPenAngle.class) {
			return (JunPenAngle) anObject;
		} else {
			return FromDeg_(((Double) anObject).doubleValue());
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param degrees DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenAngle FromDeg_(double degrees) {
		JunPenAngle angle = new JunPenAngle();
		angle.deg_(degrees);

		return angle;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param radians DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenAngle FromRad_(double radians) {
		JunPenAngle angle = new JunPenAngle();
		angle.rad_(radians);

		return angle;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenAngle Pi() {
		return FromRad_(Math.PI);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenAngle Unity() {
		return FromDeg_(1);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static JunPenAngle Zero() {
		return FromDeg_(0);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public JunPenAngle abs() {
		return this.FromDeg_(Math.abs(this.deg()));
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double cos() {
		double cos = this.cos;

		if (Double.isNaN(cos)) {
			cos = Math.cos(this.rad());
			this.cos = cos;
		}

		return cos;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double deg() {
		return this.deg;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param degrees DOCUMENT ME!
	 */
	public void deg_(double degrees) {
		this.setDeg_(degrees);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param anAngle DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public boolean isGreaterThan_(Object anAngle) {
		JunPenAngle theAngle = Coerce_(anAngle);

		return this.deg() > theAngle.deg();
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double rad() {
		double rad = this.rad;

		if (Double.isNaN(rad)) {
			rad = (Math.PI * this.deg) / 180.0;
			this.rad = rad;
		}

		return rad;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param radians DOCUMENT ME!
	 */
	public void rad_(double radians) {
		this.setDeg_((radians * 180.0) / Math.PI);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double sin() {
		double sin = this.sin;

		if (Double.isNaN(sin)) {
			sin = Math.sin(this.rad());
			this.sin = sin;
		}

		return sin;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public double tan() {
		double tan = this.tan;

		if (Double.isNaN(tan)) {
			tan = Math.tan(this.rad());
			this.tan = tan;
		}

		return tan;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param degrees DOCUMENT ME!
	 */
	private void setDeg_(double degrees) {
		this.deg = degrees;
		this.rad = Double.NaN;
		this.sin = Double.NaN;
		this.cos = Double.NaN;
		this.tan = Double.NaN;
	}
}
