package jp.co.sra.jun.goodies.progress;

import java.awt.Cursor;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.goodies.cursors.JunCursors;

/**
 * JunCursorAnimatorTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2001/11/20 (by nisinaka)
 *  @updated   2003/05/14 (by nisinaka)
 *  @updated   2007/04/12 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCursorAnimatorTestExamples.java,v 8.13 2008/02/20 06:32:01 nisinaka Exp $
 */
public class JunCursorAnimatorTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * Example1: Show and restore.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunCursorAnimator cursorAnimator = new JunCursorAnimator();
		Cursor[] cursors = new Cursor[] { JunCursors.ArrowCursor(), JunCursors.BetweenCursor(), JunCursors.BrushCursor(), JunCursors.BullCursor(), JunCursors.CameraCursor(), JunCursors.ClockCursor(), JunCursors.CrossCursor(), JunCursors.DollyCursor(), };
		cursorAnimator.cursors_(cursors);

		try {
			// Start the cursor animation.
			cursorAnimator._show();

			// Do something while animating the cursor.
			try {
				Thread.sleep(5000);
			} catch (InterruptedException e) {
			}
		} finally {
			// Stop the cursor animation and restore the cursors for all frames.
			cursorAnimator._restore();
		}

		return true;
	}

	/**
	 * Example1: The original way to show cursor animation.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1X() {
		JunCursorAnimator cursorAnimator = new JunCursorAnimator();
		Cursor[] cursors = new Cursor[] { JunCursors.ArrowCursor(), JunCursors.BetweenCursor(), JunCursors.BrushCursor(), JunCursors.BullCursor(), JunCursors.CameraCursor(), JunCursors.ClockCursor(), JunCursors.CrossCursor(), JunCursors.DollyCursor(), };
		cursorAnimator.cursors_(cursors);
		cursorAnimator.showWhile_(new StBlockClosure() {
			public Object value() {
				try {
					Thread.sleep(5000);
				} catch (InterruptedException e) {
				}
				return null;
			}
		});

		return true;
	}

	/**
	 * Example2: Clock cursors animation.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunCursorAnimator cursorAnimator = JunCursorAnimator.ClockCursors();
		cursorAnimator.tick_(125);

		try {
			// Start the cursor animation.
			cursorAnimator._show();

			// Do something while animating the cursor.
			try {
				Thread.sleep(5000);
			} catch (InterruptedException e) {
			}
		} finally {
			// Stop the cursor animation and restore the cursors for all frames.
			cursorAnimator._restore();
		}

		return true;
	}

	/**
	 * Example3: Hand cursors animation.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunCursorAnimator cursorAnimator = JunCursorAnimator.HandCursors();
		cursorAnimator.tick_(125);

		try {
			// Start the cursor animation.
			cursorAnimator._show();

			// Do something while animating the cursor.
			try {
				Thread.sleep(5000);
			} catch (InterruptedException e) {
			}
		} finally {
			// Stop the cursor animation and restore the cursors for all frames.
			cursorAnimator._restore();
		}

		return true;
	}

	/**
	 * Example4: Stopwatch cursors animation.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunCursorAnimator cursorAnimator = JunCursorAnimator.StopwatchCursors();
		cursorAnimator.tick_(125);

		try {
			// Start the cursor animation.
			cursorAnimator._show();

			// Do something while animating the cursor.
			try {
				Thread.sleep(5000);
			} catch (InterruptedException e) {
			}
		} finally {
			// Stop the cursor animation and restore the cursors for all frames.
			cursorAnimator._restore();
		}

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunCursorAnimatorTestExamples();
	}
}
