package jp.co.sra.jun.goodies.prolog;

import java.io.*;
import jp.co.sra.smalltalk.*;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunPrologEntity class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologEntity.java,v 8.11 2008/02/20 06:32:02 nisinaka Exp $
 */
public abstract class JunPrologEntity extends JunAbstractObject {

	/**
	 * Print the string representation of the car part.
	 *
	 * @param aWriter java.io.Writer
	 * @exception java.io.IOException The exception description.
	 */
	public void _carPrintJunPrologOn_(Writer aWriter) throws IOException {
		if (this.car() == null) {
			aWriter.write("[]");
		} else {
			this.car().printJunPrologOn_(aWriter);
		}
	}

	/**
	 * Answer my car part.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	public JunPrologEntity car() {
		throw SmalltalkException.Error("send message car to atom");
	}

	/**
	 * Set my new car part.
	 *
	 * @param newCdrPart jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	public void car_(JunPrologEntity newCdrPart) {
		throw SmalltalkException.Error("send message car: to atom");
	}

	/**
	 * Answer my car part.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	public JunPrologEntity cdr() {
		throw SmalltalkException.Error("send message cdr to atom");
	}

	/**
	 * Set my new cdr part.
	 *
	 * @param newCdrPart jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	public void cdr_(JunPrologEntity newCdrPart) {
		throw SmalltalkException.Error("send message cdr: to atom");
	}

	/**
	 * Answer the cons with the JunPrologEntity.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologList
	 * @param aJunPrologEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	public JunPrologList cons_(JunPrologEntity aJunPrologEntity) {
		return new JunPrologList(this, aJunPrologEntity);
	}

	/**
	 * Answer true if the receiver is a kind of JunPrologList, otherwise false.
	 *
	 * @return boolean
	 */
	public boolean consp() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of JunPrologVariable, otherwise false.
	 *
	 * @return boolean
	 */
	public boolean isJunPrologVariable() {
		return false;
	}

	/**
	 * Answer true if the receiver is a NIL object, otherwise false.
	 *
	 * @return boolean
	 */
	public boolean isNil() {
		return false;
	}

	/**
	 * Print my string representation on the writer.
	 *
	 * @param aWriter java.io.Writer
	 * @exception java.io.IOException if failed.
	 */
	public abstract void printJunPrologOn_(Writer aWriter) throws IOException;

	/**
	 * Print my string representation on the writer.
	 *
	 * @param aWriter java.io.Writer
	 * @param level int
	 * @exception java.io.IOException if failed.
	 */
	public abstract void printJunPrologOn_level_(Writer aWriter, int level) throws IOException;

	/**
	 * Answer the string representation of the receiver.
	 *
	 * @return java.lang.String
	 */
	public String printJunPrologString() {
		try {
			Writer aWriter = new StringWriter(20);
			this.printJunPrologOn_(aWriter);
			return aWriter.toString();
		} catch (IOException e) {
			throw new SmalltalkException(e);
		}
	}
}
