package jp.co.sra.jun.goodies.prolog;

import java.io.*;
import java.lang.reflect.InvocationTargetException;

/**
 * JunPrologNumber class
 * 
 *  @author    kondo
 *  @created   1999/09/14 (by kondo)
 *  @updated   2003/04/30 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologNumber.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologNumber extends JunPrologObject {

	/**
	 * Create a new instance of JunPrologNumber with the int value.
	 *
	 * @param intValue int
	 */
	public JunPrologNumber(int intValue) {
		this(new Integer(intValue));
	}

	/**
	 * Create a new instance of JunPrologNumber and initialize it.
	 *
	 * @param newNumber java.lang.Number
	 */
	public JunPrologNumber(Number newNumber) {
		super(newNumber);
	}

	/**
	 * Answer my object as a Number.
	 *
	 * @return java.lang.Number
	 */
	public Number number() {
		return (Number) this.object();
	}

	/**
	 * Override to handle the number specific selectors.
	 * 
	 * @return java.lang.Object
	 * @param selector java.lang.String
	 * @param arguments java.lang.Object[]
	 * @exception NoSuchMethodException if the method cannot be found.
	 * @exception IllegalAccessException if the underlying method is inaccessible.
	 * @exception IllegalArgumentException if the number of actual and formal parameters differ, or if an unwrapping conversion fails.
	 * @exception InvocationTargetException if the underlying method throws an exception.
	 */
	public Object perform_withArguments_(String selector, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
		if (selector.equals("+")) {
			return this.plus((Number) arguments[0]);
		} else if (selector.equals("-")) {
			return this.minus((Number) arguments[0]);
		} else if (selector.equals("*")) {
			return this.multipliedBy((Number) arguments[0]);
		} else if (selector.equals("/")) {
			return this.dividedBy((Number) arguments[0]);
		}
		return super.perform_withArguments_(selector, arguments);
	}

	/**
	 * Print my string representation on the writer.
	 *
	 * @param aWriter java.io.Writer
	 * @exception java.io.IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		aWriter.write(this.number().toString());
	}

	/**
	 * Answer the result of dividing receiver by aNumber.
	 *
	 * @return java.lang.Number
	 * @param aNumber java.lang.Number
	 */
	protected Number dividedBy(Number aNumber) {
		Number myNumber = this.number();

		if (myNumber instanceof Double || aNumber instanceof Double) {
			return new Double(myNumber.doubleValue() / aNumber.doubleValue());
		} else if (myNumber instanceof Float || aNumber instanceof Float) {
			return new Float(myNumber.floatValue() / aNumber.floatValue());
		} else if (myNumber instanceof Long || aNumber instanceof Long) {
			return new Long(myNumber.longValue() / aNumber.longValue());
		}
		return new Integer(myNumber.intValue() / aNumber.intValue());
	}

	/**
	 * Answer the difference between the receiver and aNumber.
	 *
	 * @return java.lang.Number
	 * @param aNumber java.lang.Number
	 */
	protected Number minus(Number aNumber) {
		Number myNumber = this.number();

		if (myNumber instanceof Double || aNumber instanceof Double) {
			return new Double(myNumber.doubleValue() - aNumber.doubleValue());
		} else if (myNumber instanceof Float || aNumber instanceof Float) {
			return new Float(myNumber.floatValue() - aNumber.floatValue());
		} else if (myNumber instanceof Long || aNumber instanceof Long) {
			return new Long(myNumber.longValue() - aNumber.longValue());
		}
		return new Integer(myNumber.intValue() - aNumber.intValue());
	}

	/**
	 * Answer the result of multiplying the receiver by aNumber.
	 *
	 * @return java.lang.Number
	 * @param aNumber java.lang.Number
	 */
	protected Number multipliedBy(Number aNumber) {
		Number myNumber = this.number();

		if (myNumber instanceof Double || aNumber instanceof Double) {
			return new Double(myNumber.doubleValue() * aNumber.doubleValue());
		} else if (myNumber instanceof Float || aNumber instanceof Float) {
			return new Float(myNumber.floatValue() * aNumber.floatValue());
		} else if (myNumber instanceof Long || aNumber instanceof Long) {
			return new Long(myNumber.longValue() * aNumber.longValue());
		}
		return new Integer(myNumber.intValue() * aNumber.intValue());
	}

	/**
	 * Answer the sum of the receiver and aNumber.
	 *
	 * @return java.lang.Number
	 * @param aNumber java.lang.Number
	 */
	protected Number plus(Number aNumber) {
		Number myNumber = this.number();

		if (myNumber instanceof Double || aNumber instanceof Double) {
			return new Double(myNumber.doubleValue() + aNumber.doubleValue());
		} else if (myNumber instanceof Float || aNumber instanceof Float) {
			return new Float(myNumber.floatValue() + aNumber.floatValue());
		} else if (myNumber instanceof Long || aNumber instanceof Long) {
			return new Long(myNumber.longValue() + aNumber.longValue());
		}
		return new Integer(myNumber.intValue() + aNumber.intValue());
	}
}
