package jp.co.sra.jun.goodies.prolog;

import java.io.*;

/**
 * JunPrologStructure class
 * 
 *  @author    kondo
 *  @created   1999/09/09 (by kondo)
 *  @updated   2003/04/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun301 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrologStructure.java,v 8.10 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunPrologStructure extends JunPrologList {

	/**
	 * Create a new instance of JunPrologStructure and initialize it.
	 *
	 * @param aJunPrologSymbolOrVariable jp.co.sra.jun.goodies.prolog.JunPrologString
	 * @param aJunPrologTerms jp.co.sra.jun.goodies.prolog.JunPrologTerms
	 */
	public JunPrologStructure(JunPrologString aJunPrologSymbolOrVariable, JunPrologTerms aJunPrologTerms) {
		this.functor_terms_(aJunPrologSymbolOrVariable, aJunPrologTerms);
	}

	/**
	 * Answer my car part as JunPrologString.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologString
	 */
	public JunPrologString functor() {
		return (JunPrologString) carPart;
	}

	/**
	 * Set the JunPrologString as my car part.
	 *
	 * @param aJunPrologSymbolOrVariable jp.co.sra.jun.goodies.prolog.JunPrologString
	 */
	public void functor_(JunPrologString aJunPrologSymbolOrVariable) {
		carPart = aJunPrologSymbolOrVariable;
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_(Writer aWriter) throws IOException {
		JunPrologEntity functor = this.functor();
		JunPrologEntity terms = this.terms();
		functor.printJunPrologOn_(aWriter);
		if (terms != null) {
			if (terms.consp()) {
				terms.printJunPrologOn_(aWriter);
			} else {
				aWriter.write("(|");
				terms.printJunPrologOn_(aWriter);
				aWriter.write(')');
			}
		}
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @param anInteger int
	 * @throws IOException if failed.
	 */
	public void printJunPrologOn_level_(Writer aWriter, int anInteger) throws IOException {
		this.printJunPrologOn_(aWriter);
	}

	/**
	 * Answer my cdr part as JunPrologTerms.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologTerms
	 */
	public JunPrologTerms terms() {
		return (JunPrologTerms) cdrPart;
	}

	/**
	 * Set the JunPrologTerms as my cdr part.
	 *
	 * @param aJunPrologTerms jp.co.sra.jun.goodies.prolog.JunPrologTerms
	 */
	public void terms_(JunPrologTerms aJunPrologTerms) {
		cdrPart = aJunPrologTerms;
	}

	/**
	 * Create a new instance with the specified arguments.
	 * This method have to be overrided to create a subclass specified instance.
	 *
	 * @return jp.co.sra.jun.goodies.prolog.JunPrologList
	 * @param carEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 * @param cdrEntity jp.co.sra.jun.goodies.prolog.JunPrologEntity
	 */
	protected JunPrologList _newInstanceWith(JunPrologEntity carEntity, JunPrologEntity cdrEntity) {
		return new JunPrologStructure((JunPrologString) carEntity, (JunPrologTerms) cdrEntity);
	}

	/**
	 * Initialize the variables.
	 *
	 * @param aJunPrologSymbolOrVariable jp.co.sra.jun.goodies.prolog.JunPrologString
	 * @param aJunPrologTerms jp.co.sra.jun.goodies.prolog.JunPrologTerms
	 */
	protected void functor_terms_(JunPrologString aJunPrologSymbolOrVariable, JunPrologTerms aJunPrologTerms) {
		this.functor_(aJunPrologSymbolOrVariable);
		this.terms_(aJunPrologTerms);
	}
}
