package jp.co.sra.jun.goodies.revision;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunRevisionManagerTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/15 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun500 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunRevisionManagerTestExamples.java,v 8.4 2008/02/20 06:32:02 nisinaka Exp $
 */
public class JunRevisionManagerTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final StValueHolder stringModel = new StValueHolder(null);
		final JunRevisionManager revisionManager = new JunRevisionManager(new StBlockClosure() {
			public Object value() {
				stringModel.value_("Hello, World");
				return null;
			}
		}, false);
		StBlockClosure displayBlock = new StBlockClosure() {
			public Object value_(Object msg) {
				System.out.println(Integer.toString(revisionManager.currentRevision()) + "." + revisionManager.currentStep + " : " + stringModel.value() + " ... " + msg.toString());
				return null;
			}
		};

		System.out.println("vanilla");
		displayBlock.value_("vanilla");

		revisionManager.newOperation_(new StBlockClosure() {
			public Object value() {
				stringModel.value_(stringModel.value() + ", sir");
				return null;
			}
		});
		displayBlock.value_("append ', sir'");

		revisionManager.newOperation_(new StBlockClosure() {
			public Object value() {
				stringModel.value_(stringModel.value() + "!");
				return null;
			}
		});
		displayBlock.value_("append '!'");

		revisionManager.undo();
		displayBlock.value_("undo");

		revisionManager.newOperation_(new StBlockClosure() {
			public Object value() {
				stringModel.value_(stringModel.value() + ".");
				return null;
			}
		});
		displayBlock.value_("append '.'");

		revisionManager.undo();
		displayBlock.value_("undo");

		revisionManager.redo();
		displayBlock.value_("redo");

		revisionManager.revision_step_(1, 3);
		displayBlock.value_("revision 1.3");

		revisionManager.revision_step_(2, 3);
		displayBlock.value_("revision 2.3");

		revisionManager.removeOtherRevisions();
		displayBlock.value_("removeOtherRevisions");

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunRevisionManagerTestExamples();
	}
}
