package jp.co.sra.jun.goodies.spirodesign;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StInputState;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StCheckBoxMenuItem;
import jp.co.sra.smalltalk.menu.StMenu;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor;
import jp.co.sra.jun.system.framework.JunDialog;

/**
 * JunSpiroDesignModel class
 * 
 *  @author    m-asada
 *  @created   2006/03/28 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun676 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSpiroDesignModel.java,v 8.11 2008/02/20 06:32:03 nisinaka Exp $
 */
public class JunSpiroDesignModel extends JunSpiroDesignAbstractModel {
	protected List spiroDesignCollection;
	protected transient JunSpiroDesignAnimationThread spiroDesignProcess;
	protected boolean spiroDesignState;
	protected JunNibChoiceWithColor nibChoice;

	protected transient StPopupMenu _popupMenu;

	/**
	 * Create a new instance of <code>JunSpiroDesignModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunSpiroDesignModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunSpiroDesignModel</code> and initialize it.
	 * 
	 * @param spiroDesign jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @category Instance creation
	 */
	public JunSpiroDesignModel(JunSpiroDesign spiroDesign) {
		this(new JunSpiroDesign[] { spiroDesign });
	}

	/**
	 * Create a new instance of <code>JunSpiroDesignModel</code> and initialize it.
	 * 
	 * @param spiroDesigns jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign[]
	 * @category Instance creation
	 */
	public JunSpiroDesignModel(JunSpiroDesign[] spiroDesigns) {
		super();
		this.setSpiroDesigns_(spiroDesigns);
	}

	/**
	 * Initialize the receiver when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		spiroDesignCollection = null;
		spiroDesignProcess = null;
		spiroDesignState = false;
		nibChoice = null;

		_popupMenu = null;
	}

	/**
	 * Invoked when a window is in the process of being closed.
	 * 
	 * @param evt java.awt.event.WindowEvent
	 * @see jp.co.sra.smalltalk.StApplicationModel#noticeOfWindowClose(java.awt.event.WindowEvent)
	 * @category interface closing
	 */
	public void noticeOfWindowClose(WindowEvent evt) {
		this.endAnimation();
		this.nibChoice().closeRequest();
		super.noticeOfWindowClose(evt);
	}

	/**
	 * Answer the receiver's moon circle.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#moonCircle()
	 * @category accessing
	 */
	public JunSpiroCircle moonCircle() {
		return this.spiroDesign().moonCircle();
	}

	/**
	 * Answer the receiver's spiro design.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @category accessing
	 */
	public JunSpiroDesign spiroDesign() {
		return (JunSpiroDesign) this.getSpiroDesigns().get(this.getSpiroDesigns().size() - 1);
	}

	/**
	 * Answer the receiver's spiro designs as Array.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign[]
	 * @category accessing
	 */
	public JunSpiroDesign[] spiroDesigns() {
		return (JunSpiroDesign[]) this.getSpiroDesigns().toArray(new JunSpiroDesign[this.getSpiroDesigns().size()]);
	}

	/**
	 * Answer the receiver's spiro designs as List.
	 * 
	 * @return java.uitl.List
	 * @category accessing
	 */
	public List getSpiroDesigns() {
		if (spiroDesignCollection == null) {
			spiroDesignCollection = new ArrayList();
			spiroDesignCollection.add(new JunSpiroDesign());
		}
		return spiroDesignCollection;
	}

	/**
	 * Answer the receiver's spiro pen.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroPen
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#spiroPen()
	 * @category accessing
	 */
	public JunSpiroPen spiroPen() {
		return this.spiroDesign().spiroPen();
	}

	/**
	 * Answer the receiver's tera circle.
	 * 
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroCircle
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#teraCircle()
	 * @category accessing
	 */
	public JunSpiroCircle teraCircle() {
		return this.spiroDesign().teraCircle();
	}

	/**
	 * Answer the receiver's nib choice model.
	 * 
	 * @return jp.co.sra.jun.goodies.nib.JunNibChoiceWithColor
	 * @category aspects
	 */
	public JunNibChoiceWithColor nibChoice() {
		if (nibChoice == null) {
			nibChoice = new JunNibChoiceWithColor(new double[] { 1, 2, 3, 4, 5 }, this.spiroPen().width(), this.spiroPen().color(), $("rectangle"));
			nibChoice.compute_(new StBlockClosure() {
				public Object value_(Object obj) {
					Object[] nib = (Object[]) obj;
					JunSpiroDesignModel.this.spiroDesign().color_width_((Color) nib[2], ((Number) nib[1]).intValue());
					JunSpiroDesignModel.this.changed_($("spiroDesign"));
					return null;
				}
			});
		}
		return nibChoice;
	}

	/**
	 * Answer the receiver's bounding box.
	 * 
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle boundingBox() {
		return this.preferredBounds();
	}

	/**
	 * Answer the bounding box of the receiver.
	 *
	 * @return java.awt.Rectangle
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#bounds()
	 * @category bounds accessing
	 */
	public Rectangle bounds() {
		return this.preferredBounds();
	}

	/**
	 * Answer the receiver's preferred bounds.
	 * 
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle preferredBounds() {
		Rectangle aBox = null;
		JunSpiroDesign[] spiroDesigns = this.spiroDesigns();
		for (int i = 0; i < spiroDesigns.length; i++) {
			if (aBox == null) {
				aBox = new Rectangle(spiroDesigns[i].boundingBox());
			} else {
				aBox.add(spiroDesigns[i].boundingBox());
			}
		}
		if (aBox == null) {
			aBox = new Rectangle(0, 0, 0, 0);
		}
		return aBox;
	}

	/**
	 * Display the receiver on the graphics at the specified point.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param displayPoint java.awt.Point
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#displayOn_at_(java.awt.Graphics, java.awt.Point)
	 * @category displaying
	 */
	public void displayOn_at_(Graphics graphicsContext, Point displayPoint) {
		JunSpiroDesign[] spiroDesigns = this.spiroDesigns();
		for (int i = 0; i < spiroDesigns.length; i++) {
			Rectangle clipBox = graphicsContext.getClipBounds();
			if (clipBox == null) {
				clipBox = this.boundingBox();
			}
			// Debug
			// graphicsContext.setColor(Color.gray);
			// graphicsContext.drawRect(clipBox.x, clipBox.y, clipBox.width - 1, clipBox.height - 1);
			Rectangle spiroBounds = spiroDesigns[i].bounds();
			spiroBounds.translate(displayPoint.x, displayPoint.y);
			if (clipBox.intersects(spiroBounds)) {
				if (spiroDesigns[i] == this.spiroDesign()) {
					spiroDesigns[i].displayOn_at_(graphicsContext, displayPoint);
				} else {
					spiroDesigns[i].spiroPen().displayOn_at_with_Marks_(graphicsContext, displayPoint, false);
				}
			}
		}
	}

	/**
	 * Display the receiver on the graphics at the specified point.
	 *
	 * @param graphicsContext java.awt.Graphics
	 * @param displayPoint java.awt.Point
	 * @param aBoolean boolean
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#displayOn_at_withParts_(java.awt.Graphics, java.awt.Point, boolean)
	 * @category displaying
	 */
	public void displayOn_at_withParts_(Graphics graphicsContext, Point displayPoint, boolean aBoolean) {
		JunSpiroDesign[] spiroDesigns = this.spiroDesigns();
		for (int i = 0; i < spiroDesigns.length; i++) {
			JunSpiroPen spiroPen = (JunSpiroPen) spiroDesigns[i].spiroPen().copy();
			spiroPen.points_(spiroDesigns[i].spiroLocus());
			spiroPen.displayOn_at_with_Marks_(graphicsContext, displayPoint, aBoolean);
		}
	}

	/**
	 * Update the menu indication.
	 * 
	 * @param aMenu jp.co.sra.smalltalk.menu.StMenu
	 * @return jp.co.sra.smalltalk.menu.StMenu
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#updateMenuIndication_(jp.co.sra.smalltalk.menu.StMenu)
	 * @category menu accessing
	 */
	public StMenu updateMenuIndication_(StMenu aMenu) {
		if (aMenu == null) {
			return null;
		}

		StMenuItem menuElement = (StMenuItem) aMenu.atNameKey_($("startAnimation"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(false);
			} else {
				menuElement.beEnabled(true);
			}
		}

		menuElement = aMenu.atNameKey_($("pauseAnimation"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(true);
			} else {
				menuElement.beEnabled(false);
			}
			if (this.isSuspendSpiroDesignProcess()) {
				menuElement.label_($String("Resume animation"));
			} else {
				menuElement.label_($String("Pause animation"));
			}
		}

		menuElement = aMenu.atNameKey_($("endAnimation"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(true);
			} else {
				menuElement.beEnabled(false);
			}
		}

		menuElement = aMenu.atNameKey_($("beInscribe"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(false);
			} else {
				if (this.spiroDesign().isInscribe()) {
					menuElement.beEnabled(false);
				} else {
					menuElement.beEnabled(true);
				}
			}
		}

		menuElement = aMenu.atNameKey_($("beCircumscribe"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(false);
			} else {
				if (this.spiroDesign().isCircumscribe()) {
					menuElement.beEnabled(false);
				} else {
					menuElement.beEnabled(true);
				}
			}
		}

		menuElement = aMenu.atNameKey_($("toggleRainbow"));
		if (menuElement != null) {
			if (this.spiroDesign().isRainbow()) {
				((StCheckBoxMenuItem) menuElement).beOn();
			} else {
				((StCheckBoxMenuItem) menuElement).beOff();
			}
		}

		menuElement = aMenu.atNameKey_($("pushSpiroDesign"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(false);
			} else {
				if (this.spiroDesigns().length <= 0) {
					menuElement.beEnabled(false);
				} else {
					menuElement.beEnabled(true);
				}
			}
		}

		menuElement = aMenu.atNameKey_($("addSpiroDesign"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(false);
			} else {
				menuElement.beEnabled(true);
			}
		}

		menuElement = aMenu.atNameKey_($("removeSpiroDesign"));
		if (menuElement != null) {
			if (this.isActiveSpiroDesignProcess()) {
				menuElement.beEnabled(false);
			} else {
				if (this.spiroDesigns().length <= 0) {
					menuElement.beEnabled(false);
				} else {
					menuElement.beEnabled(true);
				}
			}
		}

		return aMenu;
	}

	/**
	 * Added the new spiro design to the receiver.
	 * 
	 * @category menu messages
	 */
	public void addSpiroDesign() {
		this.spiroDesign().spiroPen().points_(this.spiroDesign().spiroLocus());
		this.getSpiroDesigns().add((StInputState.Default().shiftDown() || StInputState.Default().altDown()) ? JunSpiroDesignTestExamples.ExampleSpiroDesign() : new JunSpiroDesign());
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver be circumscribe.
	 * 
	 * @category menu messages
	 */
	public void beCircumscribe() {
		this.spiroDesign().beCircumscribe();
		this.changed_($("spiroDesign"));
	}

	/**
	 * Set the receiver be inscribe.
	 * 
	 * @category menu messages
	 */
	public void beInscribe() {
		this.spiroDesign().beInscribe();
		this.changed_($("spiroDesign"));
	}

	/**
	 * Open the choice nib window.
	 * 
	 * @category menu messages
	 */
	public void choiceNib() {
		JunNibChoiceWithColor model = this.nibChoice();
		Window[] windows = model.builder().windows();
		for (int i = 0; i < windows.length; i++) {
			if (windows[i].isShowing()) {
				windows[i].toFront();
			} else {
				windows[i].setVisible(true);
			}
		}
		if (windows.length == 0) {
			StView view = this.getView();
			if (view == null) {
				model.open();
			} else {
				Rectangle box = view.topComponent().getBounds();
				Rectangle area = new Rectangle(0, 0, box.width, box.height);
				area.translate((box.x + box.width) - area.x, box.y - area.y);
				model.openAt_(area.getLocation());
			}
		}
		model.nibWidth_nibColor_(this.spiroDesign().spiroPen().width(), this.spiroDesign().spiroPen().color());
	}

	/**
	 * End animation on the receiver.
	 * 
	 * @category menu messages
	 */
	public synchronized void endAnimation() {
		if (this.isActiveSpiroDesignProcess()) {
			try {
				if (spiroDesignProcess.isAlive()) {
					spiroDesignProcess.animationStop();
				}
			} catch (ThreadDeath e) {
			}
		}
		spiroDesignProcess = null;
		spiroDesignState = false;
		this.spiroDesign().animationState_(false);
		this.changed_($("spiroDesign"));
	}

	/**
	 * Pause/restart animation on the receiver.
	 * 
	 * @category menu messages
	 */
	public synchronized void pauseAnimation() {
		if (this.isActiveSpiroDesignProcess()) {
			if (this.isSuspendSpiroDesignProcess()) {
				try {
					spiroDesignProcess.animationResume();
					spiroDesignState = true;
				} catch (Exception e) {
					System.out.println(e.getMessage());
					e.printStackTrace();
					this.endAnimation();
				}
			} else {
				try {
					spiroDesignProcess.yield();
					spiroDesignProcess.animationSuspend();
					spiroDesignState = false;
				} catch (Exception e) {
					System.out.println(e.getMessage());
					e.printStackTrace();
					this.endAnimation();
				}
			}
		}
		this.changed_($("spiroDesign"));
	}

	/**
	 * Push the current spiro design.
	 * 
	 * @category menu messages
	 */
	public void pushSpiroDesign() {
		if (this.spiroDesigns().length <= 1) {
			return;
		}

		JunSpiroDesign spiroDesign = this.spiroDesign();
		spiroDesign.spiroPen().points_(spiroDesign.spiroLocus());
		if (this.getSpiroDesigns().remove(spiroDesign) == false) {
			return;
		}
		this.getSpiroDesigns().add(0, spiroDesign);
		this.spiroDesign().spiroPen().point_(this.spiroDesign().spiroPen().points()[0]);
		this.changed_($("spiroDesign"));
	}

	/**
	 * Remove the current spiro design.
	 * 
	 * @category menu messages
	 */
	public void removeSpiroDesign() {
		if (this.spiroDesigns().length <= 1) {
			return;
		}
		if (JunDialog.Confirm_($String("Really remove?"), true) == false) {
			return;
		}
		this.getSpiroDesigns().remove(this.spiroDesign());
		this.spiroDesign().spiroPen().point_(this.spiroDesign().spiroPen().points()[0]);
		this.changed_($("spiroDesign"));
	}

	/**
	 * Start animation on the receiver.
	 * 
	 * @category menu messages
	 */
	public synchronized void startAnimation() {
		this.endAnimation();
		spiroDesignProcess = new JunSpiroDesignAnimationThread(this.spiroDesign(), this.getSpiroDesignViews(), null) {
			public void run() {
				try {
					super.run();
				} finally {
					JunSpiroDesignModel.this.endAnimation();
				}
			}
		};
		spiroDesignProcess.setPriority(Thread.NORM_PRIORITY - 1);
		spiroDesignProcess.start();
		spiroDesignState = true;
	}

	/**
	 * Toggle the receiver's rainbow.
	 * 
	 * @category menu messages
	 */
	public void toggleRainbow() {
		this.spiroDesign().toggleRainbow();
		this.changed_($("spiroDesign"));
	}

	/**
	 * Select the spiro design and answer it.
	 * 
	 * @param spiroDesign jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#selectSpiroDesign_(jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign)
	 * @category selecting
	 */
	public JunSpiroDesign selectSpiroDesign_(JunSpiroDesign spiroDesign) {
		if (spiroDesign == null) {
			return null;
		}
		this.spiroDesign().spiroPen().points_(this.spiroDesign().spiroLocus());
		if (this.getSpiroDesigns().remove(spiroDesign) == false) {
			return null;
		}
		this.getSpiroDesigns().add(spiroDesign);
		this.spiroDesign().spiroPen().point_(new Jun2dPoint(this.spiroDesign().spiroPen().points()[0]));
		this.nibChoice().nibWidth_nibColor_(this.spiroDesign().spiroPen().width(), this.spiroDesign().spiroPen().color());
		return null;
	}

	/**
	 * Which the spiro design with the specified point and answer it.
	 * 
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#whichSpiroDesign_(java.awt.Point)
	 * @category selecting
	 */
	public JunSpiroDesign whichSpiroDesign_(Point aPoint) {
		JunSpiroDesign[] spiroDesigns = this.spiroDesigns();
		for (int i = spiroDesigns.length - 1; i >= 0; i--) {
			if (spiroDesigns[i].containsPoint_(aPoint)) {
				return spiroDesigns[i];
			}
		}
		return null;
	}

	/**
	 * Set the receiver's center of moon circle with the specified point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#centerOfMoonCircle_(jp.co.sra.jun.geometry.basic.Jun2dPoint)
	 * @category setting
	 */
	public void centerOfMoonCircle_(Jun2dPoint aPoint) {
		Rectangle previous = this.spiroDesign().bounds();
		this.spiroDesign().centerOfMoonCircle_(aPoint);
		Rectangle current = this.spiroDesign().bounds();
		previous.add(current);
		this.changed_with_($("invalidate"), previous);
	}

	/**
	 * Set the receiver's center of tera circle with the specified point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#centerOfTeraCircle_(jp.co.sra.jun.geometry.basic.Jun2dPoint)
	 * @category setting
	 */
	public void centerOfTeraCircle_(Jun2dPoint aPoint) {
		Rectangle previous = this.spiroDesign().bounds();
		this.spiroDesign().centerOfTeraCircle_(aPoint);
		Rectangle current = this.spiroDesign().bounds();
		previous.add(current);
		this.changed_with_($("invalidate"), previous);
	}

	/**
	 * Set the receiver's point of spiro pen with the specified point.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#pointOfSpiroPen_(jp.co.sra.jun.geometry.basic.Jun2dPoint)
	 * @category setting
	 */
	public void pointOfSpiroPen_(Jun2dPoint aPoint) {
		Rectangle previous = this.spiroDesign().bounds();
		this.spiroDesign().pointOfSpiroPen_(aPoint);
		Rectangle current = this.spiroDesign().bounds();
		previous.add(current);
		this.changed_with_($("invalidate"), previous);
	}

	/**
	 * Set the receiver's radius of moon circle with the specified number.
	 * 
	 * @param aNumber double
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#radiusOfMoonCircle_(double)
	 * @category setting
	 */
	public void radiusOfMoonCircle_(double aNumber) {
		Rectangle previous = this.spiroDesign().bounds();
		this.spiroDesign().radiusOfMoonCircle_(aNumber);
		Rectangle current = this.spiroDesign().bounds();
		previous.add(current);
		this.changed_with_($("invalidate"), previous);
	}

	/**
	 * Set the receiver's radius of tera circle with the specified number.
	 * 
	 * @param aNumber double
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#radiusOfTeraCircle_(double)
	 * @category setting
	 */
	public void radiusOfTeraCircle_(double aNumber) {
		Rectangle previous = this.spiroDesign().bounds();
		this.spiroDesign().radiusOfTeraCircle_(aNumber);
		Rectangle current = this.spiroDesign().bounds();
		previous.add(current);
		this.changed_with_($("invalidate"), previous);
	}

	/**
	 * Sst the receiver's spiro designs.
	 * 
	 * @param spiroDesigns jp.co.sra.jun.goodies.spirodesign.JunSpiroDesign[]
	 * @category setting
	 */
	protected void setSpiroDesigns_(JunSpiroDesign[] spiroDesigns) {
		spiroDesignCollection = Arrays.asList(spiroDesigns);
	}

	/**
	 * Answer true if the receiver having active spiro design process, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.spirodesign.JunSpiroDesignAbstractModel#isActiveSpiroDesignProcess()
	 * @category testing
	 */
	public boolean isActiveSpiroDesignProcess() {
		return spiroDesignProcess != null;
	}

	/**
	 * Answer true if the receiver having suspend spiro design process, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isSuspendSpiroDesignProcess() {
		return this.isActiveSpiroDesignProcess() && spiroDesignState == false;
	}

	/**
	 * Answer the receiver's popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (_popupMenu == null) {
			_popupMenu = new StPopupMenu();
			_popupMenu.add(new StMenuItem($String("Start animation"), $("startAnimation"), new MenuPerformer(this, "startAnimation")));
			_popupMenu.add(new StMenuItem($String("Pause animation"), $("pauseAnimation"), new MenuPerformer(this, "pauseAnimation")));
			_popupMenu.add(new StMenuItem($String("End animation"), $("endAnimation"), new MenuPerformer(this, "endAnimation")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StMenuItem($String("Inscribe"), $("beInscribe"), new MenuPerformer(this, "beInscribe")));
			_popupMenu.add(new StMenuItem($String("Circumscribe"), $("beCircumscribe"), new MenuPerformer(this, "beCircumscribe")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StCheckBoxMenuItem($String("Rainbow"), $("toggleRainbow"), new MenuPerformer(this, "toggleRainbow")));
			_popupMenu.add(new StMenuItem($String("Choice nib"), $("choiceNib"), new MenuPerformer(this, "choiceNib")));
			_popupMenu.add(new StMenuItem($String("Spawn as image"), $("spawnAsImage"), new MenuPerformer(this, "spawnAsImage")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StMenuItem($String("Push"), $("pushSpiroDesign"), new MenuPerformer(this, "pushSpiroDesign")));
			_popupMenu.add(new StMenuItem($String("Add"), $("addSpiroDesign"), new MenuPerformer(this, "addSpiroDesign")));
			_popupMenu.add(new StMenuItem($String("Remove"), $("removeSpiroDesign"), new MenuPerformer(this, "removeSpiroDesign")));
		}
		return (StPopupMenu) this.updateMenuIndication_(_popupMenu);
	}
}
