package jp.co.sra.jun.goodies.track;

import java.awt.Color;
import java.awt.Graphics;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunTrackSliderView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/12/10 (by MATSUDA Ryouichi)
 *  @updated   2002/10/28 (by nisinaka)
 *  @updated   2003/03/24 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTrackSliderView.java,v 8.10 2008/02/20 06:32:04 nisinaka Exp $
 */
public interface JunTrackSliderView extends JunAbstractView {

	public static final Color Gray20 = new Color(51, 51, 51);
	public static final Color Gray40 = new Color(102, 102, 102);
	public static final Color Gray70 = new Color(178, 178, 178);
	public static final Color Gray80 = new Color(204, 204, 204);
	public static final Color Gray90 = new Color(229, 229, 229);

	/**
	 * Answer the current another interval rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle anotherIntervalRectangle();

	/**
	 * Answer the current first marker rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle firstMarkerRectangle();

	/**
	 * Answer the current last marker rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle lastMarkerRectangle();

	/**
	 * Set the new first marker to the model via view.
	 * 
	 * @param x int
	 * @param y int
	 * @category accessing
	 */
	public void setModelFirstMarker_(int x, int y);

	/**
	 * Set the new interval to the model via view.
	 * 
	 * @param x int
	 * @param y int
	 * @category accessing
	 */
	public void setModelInterval_(int x, int y);

	/**
	 * Set the new last marker to the model via view.
	 * 
	 * @param x int
	 * @param y int
	 * @category accessing
	 */
	public void setModelLastMarker_(int x, int y);

	/**
	 * Set the new model value via view.
	 * 
	 * @param x int
	 * @param y int
	 * @category accessing
	 */
	public void setModelValue_(int x, int y);

	/**
	 * Answer the current slider area.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle sliderArea();

	/**
	 * Answer the current slider rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle sliderRectangle();

	/**
	 * Display on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics);

	/**
	 * Display the slider for the value on the graphics context with the color.
	 * 
	 * @param value double
	 * @param aGraphics java.awt.Graphics
	 * @param aColor java.awt.Color
	 * @category displaying
	 */
	public void displaySliderForValue_on_withColor_(double value, Graphics aGraphics, Color aColor);

	/**
	 * Display the slider on a graphics content with a color.
	 * 
	 * @param aGraphicsContext java.awt.Graphics
	 * @param aColor java.awt.Color
	 * @category displaying
	 */
	public void displaySliderOn_withColor_(Graphics aGraphicsContext, Color aColor);

	/**
	 * Answer the current model as a JunTrackSliderModel.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunTrackSliderModel
	 * @category model accessing
	 */
	public JunTrackSliderModel getTrackSliderModel();

	/**
	 * Set whether the slider is needed to be displayed or not.
	 * 
	 * @param aBoolean boolean
	 * @category private
	 */
	public void notDisplaySlider_(boolean aBoolean);
}
