package jp.co.sra.jun.goodies.wheels;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.SystemResourceSupport;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunThumbWheelView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/12/17 (by MATSUDA Ryouichi)
 *  @updated   2000/11/16 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2007/03/13 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunThumbWheelView.java,v 8.12 2008/02/20 06:32:14 nisinaka Exp $
 */
public interface JunThumbWheelView extends JunAbstractView {
	public static final Image ThumbWheelImage1 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage1.jpg");
	public static final Image ThumbWheelImage2 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage2.jpg");
	public static final Image ThumbWheelImage3 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage3.jpg");
	public static final Image ThumbWheelImage4 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage4.jpg");
	public static final Image ThumbWheelImage5 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage5.jpg");
	public static final Image ThumbWheelImage6 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage6.jpg");
	public static final Image ThumbWheelImage7 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage7.jpg");
	public static final Image ThumbWheelImage8 = SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/wheels/ThumbWheelImage8.jpg");

	public static final Image[] HorizontalThumbWheelImages = new Image[] { ThumbWheelImage1, ThumbWheelImage2, ThumbWheelImage3, ThumbWheelImage4 };
	public static final Image[] VerticalThumbWheelImages = new Image[] { ThumbWheelImage5, ThumbWheelImage6, ThumbWheelImage7, ThumbWheelImage8 };

	/**
	 * Answer the receiver's model as JunThumbWheel.
	 * 
	 * @return jp.co.sra.jun.goodies.wheels.JunThumbWheel
	 * @category model accessing
	 */
	public JunThumbWheel getModel();

	/**
	 * Answer the receiver's wheel area.
	 * 
	 * @return java.awt.Rectangle
	 * @category accessing
	 */
	public Rectangle thumbWheelArea();

	/**
	 * Answer true if the receiver's property is horizontal, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isHorizontal();

	/**
	 * Answer true if the receiver's property is vertical, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isVertical();

	/**
	 * Rotate with the specified delta point.
	 * 
	 * @param deltaPoint java.awt.Point
	 * @category rotating
	 */
	public abstract void rotateDelta_(Point deltaPoint);
}
