package jp.co.sra.jun.graphics.framework;

import java.awt.event.MouseEvent;

import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunGraphicController class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2003/12/11 (by Ryouichi Matsuda)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun640 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGraphicController.java,v 8.10 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunGraphicController extends JunAbstractController {
	private static boolean MacOSX = JunSystem.IsMacOSX();

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(java.awt.event.MouseEvent)
	 * @category control defaults
	 */
	public void mousePressed(MouseEvent event) {
		if (this.isPopupTrigger(event)) {
			super.mousePressed(event);
			return;
		}

		if (event.getButton() == MouseEvent.BUTTON1) {
			((JunGraphicModel) this.model()).redButtonPressedAt_(event.getPoint());
		} else {
			super.mousePressed(event);
		}
	}

	/**
	 * The isPopupTrigger() method that supported Mac OS X.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @return boolean
	 * @category mac os x support
	 */
	public boolean isPopupTrigger(MouseEvent event) {
		if (MacOSX) {
			return event.isPopupTrigger();
		} else {
			return event.isPopupTrigger() || event.isMetaDown();
		}
	}

	/**
	 * The isControlOrCommandDown() method that supported Mac OS X.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @return boolean
	 * @category mac os x support
	 */
	public boolean isControlOrCommandDown(MouseEvent event) {
		if (MacOSX) {
			return event.isMetaDown();
		} else {
			return event.isControlDown();
		}
	}
}
