package jp.co.sra.jun.graphics.framework;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.texteditor.JunTextEditor;
import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunGraphicModel class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2003/12/11 (by Ryouichi Matsuda)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun640 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGraphicModel.java,v 8.10 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunGraphicModel extends JunApplicationModel {
	protected Map keyStrokeDispatchTable;
	protected StPopupMenu yellowButtonMenu;

	/**
	 * Initialize the <code>JunGraphicModel</code> when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		keyStrokeDispatchTable = null;
		yellowButtonMenu = null;
	}

	/**
	 * Answer the display object.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public StDisplayable displayObject() {
		return null;
	}

	/**
	 * Left button pressed event with point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category actions
	 */
	public void redButtonPressedAt_(Point aPoint) {
		System.out.println(aPoint);
	}

	/**
	 * Flush the receiver's menus.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#flushMenus()
	 * @category flushing
	 */
	protected void flushMenus() {
		super.flushMenus();
		yellowButtonMenu = null;
	}

	/**
	 * Answer the default view of the model.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunGraphicViewAwt(this);
		} else {
			return new JunGraphicViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Graphics");
	}

	/**
	 * Answer my KeyListener which handles my keyboard events.
	 *
	 * @return java.awt.event.KeyListener
	 * @category keyboard
	 */
	public KeyListener _keyListener() {
		return null;
	}

	/**
	 * Convert the receiver to a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#toLispList()
	 * @category lisp support
	 */
	public JunLispCons toLispList() {
		JunLispCons list = this.lispCons();
		list.head_(this.kindName());
		return list;
	}

	/**
	 * Save the receiver on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @category lisp support
	 */
	public void saveOn_(Writer aWriter) throws IOException {
		JunCursors cursor = new JunCursors(new Cursor(Cursor.WAIT_CURSOR));
		try {
			cursor._show();
			this.toLispList().saveOn_(aWriter);
		} finally {
			cursor._restore();
		}
	}

	/**
	 * Open a new window with the receiver's lisp list.
	 * 
	 * @category lisp support
	 */
	public void showLispList() {
		this.showLispList_(this.toLispList());
	}

	/**
	 * Open a new window with the specified lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public void showLispList_(JunLispList aList) {
		Writer aWriter = null;
		try {
			aWriter = new StringWriter();
			aList.saveOn_(aWriter);
		} catch (IOException e) {
			System.err.println(e.getMessage());
			e.printStackTrace();
		} finally {
			if (aWriter != null) {
				try {
					aWriter.flush();
					aWriter.close();
				} catch (IOException e) {
					System.err.println(e.getMessage());
					e.printStackTrace();
				}
			}
		}

		JunTextEditor aModel = new JunTextEditor(aWriter.toString());
		aModel.beEditable(false);
		aModel.openIn_(new Rectangle(100, 100, 340, 180));
	}

	/**
	 * Inspect the receiver.
	 * 
	 * @category menu messages
	 */
	public void inspectModel() {
		System.out.println(this);
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (yellowButtonMenu == null) {
			StPopupMenu popupMenu = new StPopupMenu();
			popupMenu.add(new StMenuItem($String("Inspect"), $("inspectModel"), new MenuPerformer(this, "inspectModel")));
			yellowButtonMenu = popupMenu;
		}
		return yellowButtonMenu;
	}

	/**
	 * Answer the extra space.
	 * 
	 * @return java.awt.Rectangle
	 * @category scrolling
	 */
	public Rectangle extraSpace() {
		return new Rectangle(0, 0, 0, 0);
	}

	/**
	 * Fix the scrolling offset requested from the specified view.
	 * 
	 * @param aView jp.co.sra.jun.graphics.framework.JunGraphicView
	 * @category scrolling
	 */
	public void fixScrollingOffsetFrom_(JunGraphicView aView) {
		if (aView == null) {
			return;
		}
		return;
	}

	/**
	 * Answer the scrolling grid.
	 * 
	 * @return java.awt.Point
	 * @category scrolling
	 */
	public Point scrollGrid() {
		return new Point(1, 1);
	}

	/**
	 * Recompose the receiver in the specified bounds.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @category private
	 */
	public void recomposeIn_(Rectangle aRectangle) {
		return;
	}
}
