package jp.co.sra.jun.graphics.item;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunPrimitiveItemTestExamples class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2003/12/19 (by Ryouichi Matsuda)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPrimitiveItemTestExamples.java,v 8.9 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunPrimitiveItemTestExamples extends JunTestExamples {
	/**
	 * Test example #1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(20, 10), new Point(100, 50), StImage._OfArea(new Rectangle(0, 0, 200, 200)));

		Frame f = new Frame();
		f.add(new Canvas() {
			public void paint(Graphics g) {
				aPrimitiveItem.displayOn_(g);
			}
		});
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		f.setBounds(200, 200, 300, 300);
		f.setVisible(true);

		return true;
	}

	/**
	 * Test example #2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(20, 10), new Point(120, 50), StImage._OfArea(new Rectangle(0, 0, 100, 100)));
		aPrimitiveItem.borderWidth_(1);
		aPrimitiveItem.borderColor_(Color.red);
		aPrimitiveItem.emphasisState_(true);

		Frame f = new Frame();
		f.add(new Canvas() {
			public void paint(Graphics g) {
				aPrimitiveItem.displayOn_(g);
			}
		});
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		f.setBounds(200, 200, 300, 300);
		f.setVisible(true);

		return true;
	}

	/**
	 * Test example #3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(20, 10), new Point(100, 50), new StComposedText("JunJunJunJunJunJun"));
		aPrimitiveItem.borderWidth_(1);
		aPrimitiveItem.borderColor_(Color.red);
		aPrimitiveItem.emphasisState_(true);

		Frame f = new Frame();
		f.add(new Canvas() {
			public void paint(Graphics g) {
				aPrimitiveItem.displayOn_(g);
			}
		});
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		f.setBounds(200, 200, 300, 300);
		f.setVisible(true);

		return true;
	}

	/**
	 * Example icon item.
	 * 
	 * @return Image
	 * @category Examples data creation
	 */
	public static JunPrimitiveItem ExampleIconItem() {
		StImage anImage = new StImage(JunFileModel.DeviceIcon());
		JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), new Point(anImage.width() + 5, anImage.height() + 5), anImage);
		aPrimitiveItem.borderWidth_(1);
		aPrimitiveItem.borderColor_(Color.red);
		aPrimitiveItem.visualAlignment_($("center"));
		aPrimitiveItem.emphasisState_(false);
		return aPrimitiveItem;
	}

	/**
	 * Example image item.
	 * 
	 * @return Image
	 * @category Examples data creation
	 */
	public static JunPrimitiveItem ExampleImageItem() {
		StImage anImage = new StImage(JunCursors.PlayCursorImage());
		JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), new Point(anImage.width() + 5, anImage.height() + 5), anImage);
		aPrimitiveItem.borderWidth_(1);
		aPrimitiveItem.borderColor_(Color.red);
		aPrimitiveItem.visualAlignment_($("leftCenter"));
		aPrimitiveItem.emphasisState_(false);
		return aPrimitiveItem;
	}

	/**
	 * Example text item.
	 * 
	 * @return Image
	 * @category Examples data creation
	 */
	public static JunPrimitiveItem ExampleTextItem() {
		StComposedText aComposedText = new StComposedText("D: Work Volume");
		JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(0, 0), new Point(aComposedText.width() + 5, aComposedText.height() + 5), aComposedText);
		aPrimitiveItem.borderWidth_(1);
		aPrimitiveItem.borderColor_(Color.red);
		aPrimitiveItem.visualAlignment_($("leftCenter"));
		aPrimitiveItem.emphasisState_(false);
		return aPrimitiveItem;
	}

	/**
	 * Execure the example launcher.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunPrimitiveItemTestExamples();
	}
}
