package jp.co.sra.jun.graphics.navigator;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

import jp.co.sra.jun.graphics.list.JunFileList;
import jp.co.sra.jun.graphics.list.JunSequenceListViewAwt;

/**
 * JunEmbeddedFileListViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/11/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunEmbeddedFileListViewAwt.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunEmbeddedFileListViewAwt extends JunSequenceListViewAwt {
	/**
	 * Create a new instance of <code>JunEmbeddedFileListViewAwt</code> and initialize it.
	 * 
	 * @param aModel jp.co.sra.jun.graphics.navigator.JunEmbeddedFileList
	 * @category Instance creation
	 */
	public JunEmbeddedFileListViewAwt(JunEmbeddedFileList aModel) {
		super(aModel);
	}

	/**
	 * Display the canvas part of the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.jun.graphics.framework.JunGraphicViewSwing#displayCanvasOn_(java.awt.Graphics)
	 * @category displaying
	 */
	protected void displayCanvasOn_(Graphics aGraphics) {
		super.displayCanvasOn_(aGraphics);

		if (((JunFileList) this.model()).isNull()) {
			Color originalColor = aGraphics.getColor();
			try {
				Rectangle bounds = this.canvas().getBounds();
				aGraphics.setColor(Color.black);
				aGraphics.drawLine(bounds.x + bounds.width, bounds.y, bounds.x, bounds.y + bounds.height);
			} finally {
				aGraphics.setColor(originalColor);
			}
		}
	}
}
