package jp.co.sra.jun.graphics.navigator;

import java.awt.Color;

import jp.co.sra.jun.graphics.abstracts.JunAbstractVisual;
import jp.co.sra.jun.graphics.abstracts.JunAbstractItem.LookPreferences;

/**
 * JunEmbeddedLeftFileList class
 * 
 *  @author    nisinaka
 *  @created   2004/01/22 (by nisinaka)
 *  @updated   2006/11/29 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunEmbeddedLeftFileList.java,v 8.9 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunEmbeddedLeftFileList extends JunEmbeddedFileList {
	/**
	 * Answer my current look preferences.
	 * 
	 * @return jp.co.sra.jun.graphics.graphics.abstracts.JunAbstractItem.LookPreferences
	 * @see jp.co.sra.jun.graphics.list.JunFileList#lookPreferences()
	 * @category visual properties
	 */
	public LookPreferences lookPreferences() {
		if (lookPreferences == null) {
			lookPreferences = new LookPreferences();
			lookPreferences.setForegroundColor(JunAbstractVisual.ForegroundColor());
			lookPreferences.setBackgroundColor(JunAbstractVisual.BackgroundColor());
			lookPreferences.setSelectionForegroundColor(Color.black);
			lookPreferences.setSelectionBackgroundColor(Color.getHSBColor(0f, 0f, 0.833354f));
		}
		return lookPreferences;
	}
}
