package jp.co.sra.jun.graphics.navigator;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;

import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunFileRequesterDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2004/04/12 (by nisinaka)
 *  @updated   2006/11/29 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileRequesterDialogViewSwing.java,v 8.12 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunFileRequesterDialogViewSwing extends StSimpleDialogViewSwing implements JunFileRequesterDialogView {

	protected JunFileRequesterViewSwing fileRequesterView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of <code>JunFileRequesterDialogViewSwing</code> and initialize it.
	 * 
	 * @param aFileRequesterDialog jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog
	 * @category Instance creation
	 */
	public JunFileRequesterDialogViewSwing(JunFileRequesterDialog aFileRequesterDialog) {
		super(aFileRequesterDialog);
	}

	/**
	 * Answer the receiver's model as <code>JunFileRequesterDialog</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog
	 * @see jp.co.sra.jun.graphics.navigator.JunFileRequesterDialogView#getFileRequesterDialog()
	 * @category model accessing
	 */
	public JunFileRequesterDialog getFileRequesterDialog() {
		return (JunFileRequesterDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fileRequesterView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -40));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.33f, -45, 1f, -35, 0.33f, 45, 1f, -5));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.67f, -45, 1f, -35, 0.67f, 45, 1f, -5));
		this.setPreferredSize(new Dimension(540, 300));

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my file requester view.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunFileRequesterViewSwing
	 * @category user interface
	 */
	protected JunFileRequesterViewSwing fileRequesterView() {
		if (fileRequesterView == null) {
			fileRequesterView = new JunFileRequesterViewSwing(this.getFileRequesterDialog().fileModel());
		}
		return fileRequesterView;
	}

	/**
	 * Answer my accept button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton($String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunFileRequesterDialogViewSwing.this.getFileRequesterDialog().acceptButtonPressed()) {
						JunFileRequesterDialogViewSwing.this.getFileRequesterDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton($String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunFileRequesterDialogViewSwing.this.getFileRequesterDialog().cancelButtonPressed()) {
						JunFileRequesterDialogViewSwing.this.getFileRequesterDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.fileRequesterView()._setupKeyboard(aWindow);
	}

}
