package jp.co.sra.jun.metaball.atoms;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.metaball.abstracts.*;

/**
 * JunMetaRugbyball class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMetaRugbyball.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunMetaRugbyball extends JunDistanceMetaball {
	/** center1. */
	protected Jun3dPoint center1;

	/** center2. */
	protected Jun3dPoint center2;

	/**
	 * Create a new instance of JunMetaRugbyball and initialize it.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public JunMetaRugbyball(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2) {
		super();
		this.center1_(aJun3dPoint1);
		this.center2_(aJun3dPoint2);
	}

	/**
	 * Create a new instance of JunMetaRugbyball and initiazlie it.
	 * 
	 * @param aJun3dPoint1 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aJun3dPoint2 jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param order int
	 * @param weight double
	 */
	public JunMetaRugbyball(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, int order, double weight) {
		super(order, weight);
		this.center1_(aJun3dPoint1);
		this.center2_(aJun3dPoint2);
	}

	/**
	 * Create a new instance of JunMetaRugbyball and set it with center1,
	 * center2.
	 * 
	 * @param aJun3dPoint1
	 * @param aJun3dPoint2
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunMetaRugbyball
	 */
	public static JunMetaRugbyball Center_center_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2) {
		return new JunMetaRugbyball(aJun3dPoint1, aJun3dPoint2);
	}

	/**
	 * Create a new instance of JunMetaRugbyball and set it with center1,
	 * center2, order and weight.
	 * 
	 * @param aJun3dPoint1
	 * @param aJun3dPoint2
	 * @param aNumber1
	 * @param aNumber2
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunMetaRugbyball
	 */
	public static JunMetaRugbyball Center_center_order_weight_(Jun3dPoint aJun3dPoint1, Jun3dPoint aJun3dPoint2, int aNumber1, double aNumber2) {
		return new JunMetaRugbyball(aJun3dPoint1, aJun3dPoint2, aNumber1, aNumber2);
	}

	/**
	 * anser the center1.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint center1() {
		return this.center1;
	}

	/**
	 * set the center1.
	 * 
	 * @param aJun3dPoint
	 */
	public void center1_(Jun3dPoint aJun3dPoint) {
		this.center1 = aJun3dPoint;
	}

	/**
	 * anser the center2.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public Jun3dPoint center2() {
		return this.center2;
	}

	/**
	 * set the center2.
	 * 
	 * @param aJun3dPoint
	 */
	public void center2_(Jun3dPoint aJun3dPoint) {
		this.center2 = aJun3dPoint;
	}

	/**
	 * Answer a value of the distance.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return double
	 */
	public double distance_(Jun3dPoint aJun3dPoint) {
		return this.center1.distance_(aJun3dPoint) + this.center2.distance_(aJun3dPoint);
	}
}
