package jp.co.sra.jun.opengl.chart;

import java.awt.Rectangle;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunChartCombinationTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun642 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartCombinationTestExamples.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartCombinationTestExamples extends JunTestExamples {

	/**
	 * Example:
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		JunChartCombination aChart = new JunChartCombination();
		aChart.open();

		return true;
	}

	/**
	 * Example1:
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunChartBar chart1 = new JunChartBar(JunChartDataTestExamples.SampleSamples());
		chart1.showXAxis();
		chart1.showYAxisWithLabels();

		JunChartLine chart2 = new JunChartLine(JunChartDataTestExamples.SampleSamples());
		JunChartCombination combination = JunChartCombination.With_with_(chart1, chart2);
		combination.open();

		return true;
	}

	/**
	 * Example2:
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunChartBar chart1 = new JunChartBar(JunChartDataTestExamples.SampleSamples());
		chart1.labelHeight_(0.075);
		chart1.useScalableLabels();
		chart1.showXAxis();
		chart1.showYAxisWithLabels();
		chart1.extra3dObjects_(new JunOpenGL3dObject[] { JunOpenGL3dObject.Smalltalk().translatedBy_(new Jun3dPoint(1, 1, -1.01)) });

		JunChartLine chart2 = new JunChartLine(JunChartDataTestExamples.SampleSamples());
		chart2.labelHeight_(0.075);
		chart2.useScalableLabels();
		chart2.showXAxisWithLabels();
		chart2.showYAxis();

		JunChartCombination combination = JunChartCombination.With_with_(chart1, chart2);
		combination.openIn_(new Rectangle(150, 150, 600, 600));

		return true;
	}

	/**
	 * ExampleX:
	 * 
	 * @return boolean
	 */
	public static boolean ExampleX() {
		JunChartBar chart1 = new JunChartBar(JunChartDataTestExamples.SampleSamples());
		chart1.showXAxis();
		chart1.showYAxis();

		JunChartLine chart2 = new JunChartLine(JunChartDataTestExamples.SampleSamples());
		JunChartCombination combination = JunChartCombination.With_with_(chart1, chart2);
		combination.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunChartCombinationTestExamples();
	}

}
