package jp.co.sra.jun.opengl.chart;

import java.awt.Point;
import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunChartPlotWithNumericalKeys class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartPlotWithNumericalKeys.java,v 8.13 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartPlotWithNumericalKeys extends JunChartWithNumericalKeys {

	public static final double DefaultPointSize = 0.01;

	protected double pointSize;

	/**
	 * Create a new instance of <code>JunChartPlotWithNumericalKeys</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunChartPlotWithNumericalKeys() {
		super();
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection
	 * of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	public JunChartPlotWithNumericalKeys(Vector aCollectionOfSample) {
		super(aCollectionOfSample);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection
	 * of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	public JunChartPlotWithNumericalKeys(Vector aCollectionOfSample, int numberOfKeys) {
		super(aCollectionOfSample, numberOfKeys);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the
	 * JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	public JunChartPlotWithNumericalKeys(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		pointSize = DefaultPointSize;
	}

	/**
	 * Answer the point size of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double pointSize() {
		return pointSize;
	}

	/**
	 * Set the point size of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void pointSize_(double aNumber) {
		pointSize = aNumber;
	}

	/**
	 * Create a <code>JunOpenGL3dObject</code> which represents the chart.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#createChart3dObject()
	 * @category private
	 */
	protected JunOpenGL3dCompoundObject createChart3dObject() {
		final JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		final JunChartDataWithNumericalKeys myData = (JunChartDataWithNumericalKeys) this.data();
		final JunChartPlotWithNumericalKeys self = this;
		JunChartDataSheet[] sheets = myData.sheets();
		if (sheets == null) {
			return compoundObject;
		}

		for (int n = 0; n < sheets.length; n++) {
			final JunChartDataSheet sheet = sheets[n];
			final double z = this.intervalBetweenCharts() * n;
			sheet.valuesDoIJ_(new StBlockClosure() {
				public Object value_value_value_(Object anObject1, Object anObject2, Object anObject3) {
					double value = ((Number) anObject1).doubleValue();
					int i = ((Number) anObject2).intValue();
					// int j = ((Number) anObject3).intValue();
					double key = ((Number) sheet.keyAtPoint_(new Point(i, 0))).doubleValue();
					JunOpenGL3dObject vertex = self.createSmallCubeAt_(new Jun3dPoint(myData.normalizeKey_(key), myData.normalizeValue_(value), z));
					vertex.paint_(self.nextColor());
					compoundObject.add_(vertex);
					self.registerVisualObject_withValue_(vertex, new Object[] { new Double(key), new Double(value) });
					return null;
				}
			});
		}

		return compoundObject;
	}

	/**
	 * Create a small cube to represents the point.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject createSmallCubeAt_(Jun3dPoint a3dPoint) {
		double size = this.pointSize();
		JunOpenGL3dObject vertex = JunOpenGL3dObject.Box_(new Jun3dPoint(size, size, size));
		vertex = vertex.translatedBy_((Jun3dPoint) a3dPoint.minus_(size / 2));
		return vertex;
	}

}
