package jp.co.sra.jun.opengl.cosmos;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLMacrocosmModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/01/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun519 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLMacrocosmModelTestExamples.java,v 8.11 2008/02/20 06:32:18 nisinaka Exp $
 */
public class JunOpenGLMacrocosmModelTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGLMacrocosmModel macrocosmModel = new JunOpenGLMacrocosmModel();
		macrocosmModel.displayObject_(Example1DisplayObject());
		macrocosmModel.stencilObject_(Example1StencilObject());
		macrocosmModel.insideModel_(Example1InsideModel());
		macrocosmModel.insideModel().openIn_(new Rectangle(450, 100, 300, 300));
		macrocosmModel.openIn_(new Rectangle(100, 100, 300, 300));
		macrocosmModel.insideModel().zoom_(0.5);
		macrocosmModel.insideModel().grabButton().value_(true);
		macrocosmModel.dragButton().value_(true);
		return true;
	}

	/**
	 * Display object for Example1.
	 * 
	 * @return jp.co.sra.jun.opengl.object.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject Example1DisplayObject() {
		JunOpenGL3dObject displayObject = ((JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube()).components()[0];
		displayObject.paint_(Color.pink);
		return displayObject;
	}

	/**
	 * Stencil object for Example1.
	 * 
	 * @return jp.co.sra.jun.opengl.object.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject Example1StencilObject() {
		JunOpenGL3dCompoundObject anObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject aCube = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		JunOpenGL3dObject aPolygon = aCube.components()[0];
		aPolygon = aPolygon.scaledBy_(new Jun3dPoint(0.5, 0.5, 1));
		aPolygon = aPolygon.translatedBy_(new Jun3dPoint(0, 0, 0));
		anObject.add_(aPolygon);

		aCube = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		aPolygon = aCube.components()[0];
		aPolygon = aPolygon.rotatedBy_(JunAngle.FromDeg_(45));
		aPolygon = aPolygon.scaledBy_(new Jun3dPoint(0.5, 0.5, 1));
		aPolygon = aPolygon.translatedBy_(new Jun3dPoint(0, 0, 0));
		anObject.add_(aPolygon);

		JunOpenGL3dCompoundObject stencilObject = new JunOpenGL3dCompoundObject();
		stencilObject.add_(anObject);
		return stencilObject;
	}

	/**
	 * Inside model for Example1.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel Example1InsideModel() {
		return new JunOpenGLDisplayModel(JunOpenGL3dObject.Mickey());
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGLMacrocosmModel macrocosmModel = new JunOpenGLMacrocosmModel();
		macrocosmModel.displayObject_(Example2DisplayObject());
		macrocosmModel.stencilObject_(Example2StencilObject());
		macrocosmModel.insideModel_(Example2InsideModel());
		macrocosmModel.insideModel().openIn_(new Rectangle(450, 100, 300, 300));
		macrocosmModel.openIn_(new Rectangle(100, 100, 300, 300));
		return true;
	}

	/**
	 * Display object for Example2.
	 * 
	 * @return jp.co.sra.jun.opengl.object.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject Example2DisplayObject() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Cube();
		displayObject.paint_(Color.yellow);
		return displayObject;
	}

	/**
	 * Stencil object for Example2.
	 * 
	 * @return jp.co.sra.jun.opengl.object.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject Example2StencilObject() {
		JunOpenGL3dCompoundObject anObject = new JunOpenGL3dCompoundObject();

		JunOpenGL3dCompoundObject aCube = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		JunOpenGL3dObject aPolygon = aCube.components()[0];
		aPolygon = aPolygon.scaledBy_(new Jun3dPoint(0.5, 0.5, 1));
		aPolygon = aPolygon.translatedBy_(new Jun3dPoint(0, 0, 0));
		anObject.add_(aPolygon);

		aCube = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Cube();
		aPolygon = aCube.components()[0];
		aPolygon = aPolygon.rotatedBy_(JunAngle.FromDeg_(45));
		aPolygon = aPolygon.scaledBy_(new Jun3dPoint(0.5, 0.5, 1));
		aPolygon = aPolygon.translatedBy_(new Jun3dPoint(0, 0, 0));
		anObject.add_(aPolygon);

		JunOpenGL3dCompoundObject stencilObject = new JunOpenGL3dCompoundObject();
		stencilObject.add_(anObject);
		stencilObject.add_(anObject.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(-90))));
		stencilObject.add_(anObject.transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90))));
		return stencilObject;
	}

	/**
	 * Inside model for Example2.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel Example2InsideModel() {
		return new JunOpenGLDisplayModel(JunOpenGL3dObject.Benzene());
	}

	/**
	 * Example3: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunOpenGLMacrocosmModel macrocosmModel = new JunOpenGLMacrocosmModel();
		macrocosmModel.displayObject_(Example3DisplayObject());
		macrocosmModel.stencilObject_(Example3StencilObject());
		macrocosmModel.insideModel_(Example3InsideModel());
		macrocosmModel.insideModel().openIn_(new Rectangle(450, 100, 300, 300));
		macrocosmModel.openIn_(new Rectangle(100, 100, 300, 300));
		return true;
	}

	/**
	 * Display object for Example3.
	 * 
	 * @return jp.co.sra.jun.opengl.object.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject Example3DisplayObject() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Globe_(15);
		displayObject.primitivesDo_(new StBlockClosure() {
			public Object value_(Object aPrimitive) {
				((JunOpenGL3dObject) aPrimitive).paint_(Color.pink);
				return null;
			}
		});
		return displayObject;
	}

	/**
	 * Stencil object for Example3.
	 * 
	 * @return jp.co.sra.jun.opengl.object.JunOpenGL3dObject
	 * @category Examples
	 */
	protected static JunOpenGL3dObject Example3StencilObject() {
		JunOpenGL3dObject displayObject = Example3DisplayObject();
		final Vector polygonCollection = new Vector();
		displayObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				polygonCollection.add(aPolygon);
				return null;
			}
		});
		JunOpenGL3dCompoundObject stencilObject = new JunOpenGL3dCompoundObject();
		Enumeration enumeration = polygonCollection.elements();
		while (enumeration.hasMoreElements()) {
			JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) enumeration.nextElement();
			Jun3dPoint normalVector = aPolygon.normalVector();
			if (Math.abs(normalVector.x()) > 0.9 || Math.abs(normalVector.y()) > 0.9 || Math.abs(normalVector.z()) > 0.9) {
				stencilObject.add_(aPolygon);
			}
		}

		return stencilObject;
	}

	/**
	 * Inside model for Example3.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Examples
	 */
	protected static JunOpenGLDisplayModel Example3InsideModel() {
		return new JunOpenGLDisplayModel(JunOpenGL3dObject.Aoki1());
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLMacrocosmModelTestExamples();
	}
}
